/*
 * Decompiled with CFR 0.152.
 */
package com.dc.exception;

import com.dc.util.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseException
extends RuntimeException {
    private static Message msg = Message.getInstance();
    private Map scene = new HashMap(5);
    private List scene_names = new ArrayList(5);
    protected String errCode;

    public BaseException(String errCode) {
        this(errCode, msg.getMessage(errCode));
    }

    public BaseException(String errCode, Throwable e) {
        this(errCode, msg.getMessage(errCode), e);
    }

    public BaseException(String errCode, String message) {
        super(message);
        this.errCode = errCode;
    }

    public BaseException(String errCode, String message, Throwable e) {
        super(message, e);
        this.errCode = errCode;
    }

    public String errCode() {
        return this.errCode;
    }

    public void addScene(String name, Object obj) {
        this.scene.put(name, obj);
        this.scene_names.add(name);
    }

    public void addScene(String name, boolean b) {
        this.addScene(name, (Object)b);
    }

    public void addScene(String name, byte b) {
        this.addScene(name, new Byte(b));
    }

    public void addScene(String name, short s) {
        this.addScene(name, new Short(s));
    }

    public void addScene(String name, int i) {
        this.addScene(name, new Integer(i));
    }

    public void addScene(String name, long l) {
        this.addScene(name, new Long(l));
    }

    public void addScene(String name, float f) {
        this.addScene(name, new Float(f));
    }

    public void addScene(String name, double d) {
        this.addScene(name, new Double(d));
    }

    public Object getScene(String name) {
        return this.scene.get(name);
    }

    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName()).append(":\r\n");
        if (this.errCode != null) {
            buf.append("ErrorCode:[").append(this.errCode).append("]").append("\r\n");
        }
        buf.append("ErrorMesg:[").append(super.getMessage()).append("]").append("\r\n");
        if (this.scene.size() > 0) {
            buf.append("SceneInfo:\r\n");
            for (int i = 0; i < this.scene_names.size(); ++i) {
                String name = (String)this.scene_names.get(i);
                buf.append("\t");
                buf.append(name);
                buf.append(":[");
                if (this.scene.get(name) != null) {
                    buf.append(this.scene.get(name));
                }
                buf.append("]\r\n");
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.getMessage();
    }
}

