/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.util;

import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldType;
import java.util.Iterator;

public class CompositeDataHelper {
    public static void shadowCopy(CompositeData source, CompositeData dest) {
        dest.addBase(source);
    }

    public static void deepCopy(CompositeData source, CompositeData dest) {
        Iterator it = source.iterator();
        while (it.hasNext()) {
            AtomData data;
            String name = (String)it.next();
            AtomData atom = source.getObject(name);
            if (atom.isField()) {
                Field fld = new Field(((Field)atom).getAttr());
                CompositeDataHelper.deepCopy((Field)atom, fld);
                dest.addField(name, fld);
                continue;
            }
            if (atom.isArray()) {
                data = new Array();
                CompositeDataHelper.deepCopy((Array)atom, data);
                dest.addArray(name, (Array)data);
                continue;
            }
            if (!atom.isStruct()) continue;
            data = new CompositeData();
            CompositeDataHelper.deepCopy((CompositeData)atom, (CompositeData)data);
            dest.addStruct(name, (CompositeData)data);
        }
    }

    public static void deepCopy(Array source, Array dest) {
        for (int i = 0; i < source.size(); ++i) {
            AtomData data;
            AtomData atom = source.getObject(i);
            if (atom == null) continue;
            if (atom.isField()) {
                Field fld = new Field(((Field)atom).getAttr());
                CompositeDataHelper.deepCopy((Field)atom, fld);
                dest.addField(fld);
                continue;
            }
            if (atom.isArray()) {
                data = new Array();
                CompositeDataHelper.deepCopy((Array)atom, data);
                dest.addArray((Array)data);
                continue;
            }
            if (!atom.isStruct()) continue;
            data = new CompositeData();
            CompositeDataHelper.deepCopy((CompositeData)atom, (CompositeData)data);
            dest.addStruct((CompositeData)data);
        }
    }

    public static void deepCopy(Field source, Field dest) {
        FieldType ftype = dest.getFieldType();
        if (FieldType.integerType(ftype)) {
            if (FieldType.FIELD_BYTE == ftype) {
                dest.setValue(new Integer(source.intValue()).shortValue());
            } else if (FieldType.FIELD_INT24 == ftype) {
                dest.setValue(new Integer(source.intValue()).longValue());
            } else if (FieldType.FIELD_INT == ftype) {
                dest.setValue(source.intValue());
            } else if (FieldType.FIELD_SHORT == ftype) {
                dest.setValue(source.shortValue());
            } else if (FieldType.FIELD_LONG == ftype) {
                dest.setValue(new Integer(source.intValue()).longValue());
            }
        } else if (FieldType.decimalType(ftype)) {
            if (FieldType.FIELD_FLOAT == ftype) {
                Object st = source.getValue();
                if (st != null) {
                    dest.setValue(new Double(source.doubleValue()).floatValue());
                } else {
                    Float objD = null;
                    dest.setValue(objD);
                }
            } else if (FieldType.FIELD_DOUBLE == ftype) {
                Object st = source.getValue();
                if (st != null) {
                    dest.setValue((double)new Double(source.doubleValue()));
                } else {
                    Double objD = null;
                    dest.setValue(objD);
                }
            }
        } else if (ftype == FieldType.FIELD_STRING) {
            dest.setValue(source.strValue());
        } else if (ftype == FieldType.FIELD_IMAGE) {
            dest.setValue(source.imageValue());
        }
    }

    public static boolean atomEquals(AtomData source, AtomData dest) {
        if (source == null && dest == null) {
            return true;
        }
        if (source == null && dest != null || dest == null && source != null) {
            return false;
        }
        if (source.getType() != dest.getType()) {
            return false;
        }
        if (source.isField()) {
            if (!CompositeDataHelper.fieldEquals((Field)source, (Field)dest)) {
                return false;
            }
        } else if (source.isArray()) {
            if (!CompositeDataHelper.arrayEquals((Array)source, (Array)dest)) {
                return false;
            }
        } else if (source.isStruct()) {
            if (!CompositeDataHelper.structEquals((CompositeData)source, (CompositeData)dest)) {
                return false;
            }
        } else {
            throw new IllegalArgumentException("bad-value");
        }
        return true;
    }

    public static boolean fieldEquals(Field source, Field dest) {
        if (source == null && dest == null) {
            return true;
        }
        if (source == null && dest != null || dest == null && source != null) {
            return false;
        }
        if (!source.getAttr().equals(dest.getAttr())) {
            return false;
        }
        FieldType ftype = source.getFieldType();
        if (FieldType.integerType(ftype)) {
            if (FieldType.FIELD_SHORT == ftype ? source.shortValue() != dest.shortValue() : source.intValue() != dest.intValue()) {
                return false;
            }
        } else if (FieldType.decimalType(ftype)) {
            if (source.doubleValue() != dest.doubleValue()) {
                return false;
            }
        } else if (ftype == FieldType.FIELD_STRING) {
            if (!source.strValue().equals(dest.strValue())) {
                return false;
            }
        } else if (ftype == FieldType.FIELD_IMAGE) {
            byte[] imaged;
            byte[] images = source.imageValue();
            if (images.length != (imaged = dest.imageValue()).length) {
                return false;
            }
            for (int i = 0; i < images.length; ++i) {
                if (images[i] == imaged[i]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean arrayEquals(Array source, Array dest) {
        if (source == null && dest == null) {
            return true;
        }
        if (source == null && dest != null || dest == null && source != null) {
            return false;
        }
        if (source.size() != dest.size()) {
            return false;
        }
        for (int i = 0; i < source.size(); ++i) {
            if (CompositeDataHelper.atomEquals(source.getObject(i), dest.getObject(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean structEquals(CompositeData source, CompositeData dest) {
        if (source == null && dest == null) {
            return true;
        }
        if (source == null && dest != null || dest == null && source != null) {
            return false;
        }
        if (source.size() != dest.size()) {
            return false;
        }
        Iterator iterator = source.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!dest.contains(name)) {
                return false;
            }
            if (CompositeDataHelper.atomEquals(source.getObject(name), dest.getObject(name))) continue;
            return false;
        }
        return true;
    }
}

