/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.tools.loadrun;

import com.dc.eai.tools.loadrun.Controller;

public abstract class Worker
implements Runnable {
    protected String ID;
    int iteration;

    public void setID(String id) {
        this.ID = id;
    }

    protected abstract boolean execute();

    protected boolean start() {
        return true;
    }

    protected void end() {
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void run() {
        if (!this.start()) {
            return;
        }
        Controller controller = Controller.getInstance();
        for (int i = 0; i < this.iteration; ++i) {
            int tran_time;
            long end;
            long start = System.currentTimeMillis();
            try {
                boolean success = this.execute();
                end = System.currentTimeMillis();
                tran_time = (int)(end - start);
                controller.finish_tran(tran_time, success);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                end = System.currentTimeMillis();
                tran_time = (int)(end - start);
                controller.finish_tran(tran_time, false);
            }
        }
        controller.increase_finish_thread();
        this.end();
    }
}

