/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.tools.loadrun;

import com.dc.eai.tools.loadrun.Controller;
import com.dc.eai.tools.loadrun.Worker;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class LoadRun {
    static Controller controller = Controller.getInstance();
    static int wait_time = 2000;

    public static void main(String[] args) throws Exception {
        URL conf = LoadRun.class.getClassLoader().getResource("worker.properties");
        if (conf == null) {
            System.out.println("file [worker.conf] cannot found in class loader[" + LoadRun.class.getClassLoader() + "]");
        }
        Properties p = new Properties();
        InputStream pin = conf.openStream();
        p.load(pin);
        pin.close();
        if (p.getProperty("wait_time") != null) {
            wait_time = Integer.parseInt(p.getProperty("wait_time"));
        }
        Enumeration<Object> enn = p.keys();
        Vector<Thread> workers = new Vector<Thread>();
        while (enn.hasMoreElements()) {
            String key = (String)enn.nextElement();
            if (!key.startsWith("worker")) continue;
            String workClassName = key.substring(key.indexOf(".") + 1);
            String v = p.getProperty(key).trim();
            StringTokenizer tokens = new StringTokenizer(v);
            int threads = Integer.parseInt(tokens.nextToken());
            int iterals = Integer.parseInt(tokens.nextToken());
            String id = tokens.nextToken();
            for (int i = 0; i < threads; ++i) {
                Worker worker = (Worker)Class.forName(workClassName).newInstance();
                worker.setIteration(iterals);
                worker.setID(id);
                workers.add(new Thread(worker));
            }
        }
        controller.set_total_threads(workers.size());
        controller.set_start_time(System.currentTimeMillis());
        for (int i = 0; i < workers.size(); ++i) {
            ((Thread)workers.get(i)).start();
        }
        new Thread(new Printer()).start();
    }

    static class Printer
    implements Runnable {
        Printer() {
        }

        public void run() {
            boolean finished;
            do {
                finished = controller.wait_finish(wait_time);
                long end = System.currentTimeMillis();
                controller.set_end_time(end);
                System.out.println("\u5e76\u53d1\u5ea6:" + controller.get_total_threads());
                System.out.println("\u603b\u4ea4\u6613:" + controller.get_total_tran() + " \u6210\u529f:" + controller.get_succ_tran() + " \u5931\u8d25:" + controller.get_fail_tran());
                System.out.println("\u603b\u65f6\u95f4:" + controller.get_total_tran_time() + "\u6beb\u79d2");
                System.out.println("\u6700\u5927\u65f6\u95f4:" + controller.get_max_tran_time() + "\u6beb\u79d2 \u6700\u5c0f\u65f6\u95f4:" + controller.get_min_tran_time() + "\u6beb\u79d2 \u5e73\u5747\u65f6\u95f4:" + controller.get_average_tran_time() + "\u6beb\u79d2");
                System.out.println("\u541e\u5410\u91cf:" + controller.get_tran_per_second() + "\u7b14/\u79d2");
                System.out.println();
            } while (!finished);
        }
    }
}

