/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.tools.loadrun;

public final class Controller {
    private static Controller instance = new Controller();
    Object lock = new Object();
    int finish_threads = 0;
    int total_threads;
    int max_tran_time = 0;
    volatile int min_tran_time = 1000000;
    volatile int total_tran_time = 0;
    volatile int fail_tran = 0;
    volatile int succ_tran = 0;
    long start_time;
    long end_time;

    public static Controller getInstance() {
        return instance;
    }

    public synchronized int get_total_tran() {
        return this.succ_tran + this.fail_tran;
    }

    public synchronized int get_succ_tran() {
        return this.succ_tran;
    }

    public synchronized int get_fail_tran() {
        return this.fail_tran;
    }

    public synchronized int get_total_tran_time() {
        return (int)(this.end_time - this.start_time);
    }

    public synchronized int get_average_tran_time() {
        if (this.get_total_tran() == 0) {
            return 0;
        }
        return this.total_tran_time / (this.succ_tran + this.fail_tran);
    }

    public synchronized int get_max_tran_time() {
        return this.max_tran_time;
    }

    public synchronized int get_min_tran_time() {
        return this.min_tran_time;
    }

    public synchronized int get_tran_per_second() {
        if (this.get_total_tran_time() == 0) {
            return 0;
        }
        return this.get_total_tran() * 1000 / this.get_total_tran_time();
    }

    public synchronized int get_total_threads() {
        return this.total_threads;
    }

    public void set_start_time(long start_time) {
        this.start_time = start_time;
    }

    public void set_end_time(long end_time) {
        this.end_time = end_time;
    }

    public synchronized void set_total_threads(int total_threads) {
        this.total_threads = total_threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wait_finish(int wait_time) {
        Object object = this.lock;
        synchronized (object) {
            if (this.finish_threads < this.total_threads) {
                try {
                    this.lock.wait(wait_time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.finish_threads >= this.total_threads;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increase_finish_thread() {
        Object object = this.lock;
        synchronized (object) {
            ++this.finish_threads;
            if (this.finish_threads >= this.total_threads) {
                this.lock.notify();
            }
        }
    }

    public synchronized void finish_tran(int tran_time, boolean success) {
        if (tran_time > this.max_tran_time) {
            this.max_tran_time = tran_time;
        }
        if (tran_time < this.min_tran_time) {
            this.min_tran_time = tran_time;
        }
        this.total_tran_time += tran_time;
        if (success) {
            ++this.succ_tran;
        } else {
            ++this.fail_tran;
        }
    }

    private Controller() {
    }
}

