/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.startup;

import com.dc.eai.load.StandardClassLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bootstrap {
    private static ClassLoader commonLoader = null;
    private static ClassLoader platformLoader = null;
    private static ClassLoader componentSharedLoader = null;
    private static URL eai_home = Bootstrap.getEAIHome();
    private static Log log = LogFactory.getLog((Class)Bootstrap.class);

    public static void main(String[] args) throws Exception {
        URL[] u_path;
        ArrayList<URL> path;
        boolean new_root;
        if (log.isInfoEnabled()) {
            log.info((Object)("EAI_HOME: " + eai_home));
        }
        if (new_root = true) {
            path = new ArrayList<URL>();
            path.add(new URL(eai_home, "conf/"));
            path.add(new URL(eai_home, "common/"));
            path.add(new URL(eai_home, "common/classes/"));
            path.addAll(Arrays.asList(Bootstrap.getLibs(new URL(eai_home, "common/lib/").getFile())));
            u_path = new URL[path.size()];
            for (int i = 0; i < u_path.length; ++i) {
                u_path[i] = (URL)path.get(i);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("common[" + path.toString() + "]"));
            }
            commonLoader = Bootstrap.createClassLoader(u_path, Bootstrap.class.getClassLoader());
        } else {
            commonLoader = Bootstrap.class.getClassLoader();
        }
        path = new ArrayList();
        path.add(new URL(eai_home, "server/"));
        path.add(new URL(eai_home, "server/ext/"));
        path.add(new URL(eai_home, "server/ext/classes/"));
        URL[] ext_libs = Bootstrap.getLibs(new URL(eai_home, "server/ext/lib/").getFile());
        path.addAll(Arrays.asList(ext_libs));
        path.add(new URL(eai_home, "server/classes/"));
        URL[] svr_libs = Bootstrap.getLibs(new URL(eai_home, "server/lib/").getFile());
        path.addAll(Arrays.asList(svr_libs));
        URL[] u_path2 = new URL[path.size()];
        for (int i = 0; i < u_path2.length; ++i) {
            u_path2[i] = (URL)path.get(i);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("server[" + path.toString() + "]"));
        }
        platformLoader = Bootstrap.createClassLoader(u_path2, commonLoader);
        path = new ArrayList();
        path.add(new URL(eai_home, "shared/"));
        path.add(new URL(eai_home, "shared/classes/"));
        path.add(new URL(eai_home, "shared/db/ibatis/"));
        path.addAll(Arrays.asList(Bootstrap.getLibs(new URL(eai_home, "shared/lib/").getFile())));
        u_path = new URL[path.size()];
        for (int i = 0; i < u_path.length; ++i) {
            u_path[i] = (URL)path.get(i);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("shared[" + path.toString() + "]"));
        }
        componentSharedLoader = Bootstrap.createClassLoader(u_path, commonLoader);
        Class<?> cl = Class.forName("com.dc.eai.platform.BootRelay", true, platformLoader);
        cl.getMethod("boot", ClassLoader.class, ClassLoader.class).invoke(null, platformLoader, componentSharedLoader);
    }

    public static URL getEAIHome() {
        try {
            if (eai_home == null) {
                String home = System.getProperty("EAI_HOME");
                if (home != null) {
                    File dir = new File(home);
                    if (dir.exists()) {
                        eai_home = dir.toURL();
                    }
                } else if (home == null) {
                    URL root = new File("..").getCanonicalFile().toURL();
                    String path = root.getPath();
                    path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
                    File dir = new File(System.getProperty("EAI_HOME", path));
                    System.setProperty("EAI_HOME", path);
                    if (dir.exists()) {
                        eai_home = dir.toURL();
                    }
                }
            }
            return eai_home;
        }
        catch (Exception exception) {
            throw new NullPointerException("No such a dir:" + System.getProperty("EAI_HOME"));
        }
    }

    private static URL[] getLibs(String lib) {
        URL[] libs;
        block4: {
            libs = new URL[]{};
            try {
                File lib_dir = new File(lib);
                URL lib_url = null;
                if (lib_dir.exists()) {
                    lib_url = lib_dir.toURL();
                    File[] jars = lib_dir.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar");
                        }
                    });
                    libs = new URL[jars.length];
                    for (int i = 0; i < jars.length; ++i) {
                        libs[i] = new URL(lib_url, jars[i].getName());
                    }
                }
            }
            catch (MalformedURLException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Jars finding exception", (Throwable)e);
            }
        }
        return libs;
    }

    private static ClassLoader createClassLoader(URL[] urls, ClassLoader parent) {
        StandardClassLoader scl = null;
        String[] array = new String[urls.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = urls[i].toString();
        }
        scl = parent == null ? new StandardClassLoader(array) : new StandardClassLoader(array, parent);
        scl.setDelegate(true);
        return scl;
    }

    public static ClassLoader getCommonLoader() {
        return commonLoader;
    }

    public static ClassLoader getComponentSharedLoader() {
        return componentSharedLoader;
    }

    public static ClassLoader getPlatformLoader() {
        return platformLoader;
    }
}

