/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.reverse;

import com.dc.concurrent.Executor;
import com.dc.eai.config.ErrorAction;
import com.dc.eai.service.reverse.ReverseExecutorFactory;
import com.dc.eai.service.reverse.ReverseResult;
import com.dc.eai.service.reverse.ReverseStatus;
import com.dc.eai.service.reverse.ReverseTask;
import com.dc.eai.service.reverse.TaskTracer;
import com.dc.eai.service.reverse.exception.ReverseException;

public class SimpleTaskTracer
extends TaskTracer {
    private int try_times = 10;
    private volatile int tried_times = 0;
    private long min_interval = 10000L;
    private long sleep = 1000L;
    private long create = System.currentTimeMillis();

    public SimpleTaskTracer(ReverseTask task, String serialId, ErrorAction errorAction) {
        super(task, serialId, errorAction);
    }

    public void run() {
        Executor executor = ReverseExecutorFactory.getExecutor();
        long curTime = System.currentTimeMillis();
        if (this.tried_times < this.try_times) {
            if (this.tried_times == 0 || this.create + (long)this.tried_times * this.min_interval < curTime) {
                ++this.tried_times;
                ReverseResult result = this.task.execute(this.serialId, this.errorAction);
                if (result != null && (result.getStatus().equals(ReverseStatus.REVERSE_FAILED) || result.getStatus().equals(ReverseStatus.REVERSE_PARTLY_SUCCESS))) {
                    try {
                        executor.execute(this);
                    }
                    catch (InterruptedException ie) {
                        throw new ReverseException("\u51b2\u6b63\u7ebf\u7a0b\u6267\u884c\u5668\u6267\u884c\u5df2\u505c\u6b62", this.serialId, ie);
                    }
                }
            } else {
                try {
                    Thread.sleep(this.sleep);
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    executor.execute(this);
                }
                catch (InterruptedException ie) {
                    throw new ReverseException("\u51b2\u6b63\u7ebf\u7a0b\u6267\u884c\u5668\u6267\u884c\u5df2\u505c\u6b62", this.serialId, ie);
                }
            }
        }
    }

    public void setTask(ReverseTask task) {
        this.task = task;
    }

    public void setMin_interval(long l) {
        this.min_interval = l;
    }

    public void setSleep(long l) {
        this.sleep = l;
    }

    public void setTry_times(int i) {
        this.try_times = i;
    }
}

