/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.reverse;

import com.dc.eai.component.LifeCycle;
import com.dc.eai.config.CompositeServiceConfig;
import com.dc.eai.config.ErrorAction;
import com.dc.eai.config.SequenceStep;
import com.dc.eai.config.ServiceConfig;
import com.dc.eai.config.ServiceStep;
import com.dc.eai.config.ServiceType;
import com.dc.eai.data.CompositeData;
import com.dc.eai.dispatch.Context;
import com.dc.eai.service.Service;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.journal.JournalContext;
import com.dc.eai.service.reverse.ConsistencyEvaluator;
import com.dc.eai.service.reverse.Reverse;
import com.dc.eai.service.reverse.ReverseFactory;
import com.dc.eai.service.reverse.ReverseType;
import com.dc.eai.service.reverse.exception.NoExistedReverseServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceConsistencyProxy
implements Service,
LifeCycle {
    private Service service;
    private ServiceConfig config;
    private ReverseType reverseType = ReverseType.ASY_REVERSE;
    private static Log log = LogFactory.getLog((Class)ServiceConsistencyProxy.class);

    public ServiceConsistencyProxy(Service service) {
        this.service = service;
        this.config = service.getConfig();
    }

    public void start() {
        if (this.service instanceof LifeCycle) {
            ((LifeCycle)((Object)this.service)).start();
        }
    }

    public void stop() {
        if (this.service instanceof LifeCycle) {
            ((LifeCycle)((Object)this.service)).stop();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceResult execute(CompositeData data) {
        ServiceResult result;
        block31: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u4e00\u81f4\u6027\u4ee3\u7406\u6267\u884c\u5f00\u59cb");
            }
            result = null;
            if (this.config == null) {
                this.config = this.service.getConfig();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u6267\u884c\uff0c\u670d\u52a1\u540d=[" + this.config.getName() + "]"));
            }
            result = this.service.execute(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u7ed3\u679c\u72b6\u6001=[" + result.status().getName() + ":" + result.status().getValue() + "]"));
            }
            if (Context.getInstance().getProperty("isReverse") != null && ((Boolean)Context.getInstance().getProperty("isReverse")).booleanValue()) break block31;
            try {
                block32: {
                    Reverse reverseService;
                    String serialId;
                    ErrorAction errorAction;
                    block34: {
                        block35: {
                            ServiceType serviceType;
                            block33: {
                                if (ConsistencyEvaluator.eval(this.service, result)) break block32;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"\u670d\u52a1\u6267\u884c\u7ed3\u679c\u6570\u636e\u4e0d\u4e00\u81f4");
                                }
                                serviceType = this.config.getType();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("\u670d\u52a1\u7c7b\u578b=[" + serviceType + "]"));
                                }
                                errorAction = null;
                                if (!serviceType.equals(ServiceType.ATOM_SERVICE)) break block33;
                                if (((JournalContext)Context.getInstance().getProperty(JournalContext.JOURNAL_CONTEXT)).getLevel() > 0) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("\u7ec4\u5408\u670d\u52a1\u4e2d\u7684\u539f\u5b50\u670d\u52a1\u65e0\u9700\u51b2\u6b63\uff0c\u670d\u52a1\u540d=[" + this.config.getName() + "]"));
                                    }
                                    return result;
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("\u9700\u8981\u51b2\u6b63\uff0c\u670d\u52a1\u540d=[" + this.config.getName() + "]"));
                                }
                                break block34;
                            }
                            if (!serviceType.equals(ServiceType.COMPOSITE_SERVICE)) break block35;
                            try {
                                SequenceStep sequenceStep = (SequenceStep)((CompositeServiceConfig)this.config).getStep();
                                ServiceStep serviceStep = (ServiceStep)sequenceStep.getStep(((JournalContext)Context.getInstance().getProperty(JournalContext.JOURNAL_CONTEXT)).getSeq() - 1);
                                errorAction = serviceStep.getFailureAction();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("\u7ec4\u5408\u670d\u52a1\u7684ErrorAction=[" + errorAction.getName() + "]"));
                                }
                            }
                            catch (Exception e) {
                                if (log.isErrorEnabled()) {
                                    log.error((Object)("\u7ec4\u5408\u670d\u52a1\u7ed3\u679c\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u4f46\u672a\u80fd\u83b7\u53d6ErrorAction\uff0c\u65e0\u6cd5\u6267\u884c\u51b2\u6b63,\u670d\u52a1\u540d=[" + this.config.getName() + "]"), (Throwable)e);
                                }
                                return result;
                            }
                            if (errorAction.equals(ErrorAction.REVERSE) || errorAction.equals(ErrorAction.REVERSE_FROM_LAST)) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("\u9700\u8981\u51b2\u6b63\uff0c\u670d\u52a1\u540d=[" + this.config.getName() + "]"));
                                }
                                break block34;
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("\u65e0\u9700\u51b2\u6b63\uff0c\u670d\u52a1\u540d=[" + this.config.getName() + "]"));
                                }
                                return result;
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\u65e0\u9700\u51b2\u6b63\uff0c\u670d\u52a1\u540d=[" + this.config.getName() + "]"));
                        }
                        return result;
                    }
                    try {
                        serialId = Context.getInstance().getSerialId();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\u9700\u8981\u51b2\u6b63\u7684\u5e73\u53f0\u8ddf\u8e2a\u53f7=[" + serialId + "]"));
                        }
                    }
                    catch (Exception e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"\u83b7\u53d6\u5e73\u53f0\u8ddf\u8e2a\u53f7\u5931\u8d25, \u65e0\u6cd5\u6267\u884c\u51b2\u6b63", (Throwable)e);
                        }
                        return result;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"\u83b7\u53d6\u51b2\u6b63\u670d\u52a1");
                    }
                    if ((reverseService = ReverseFactory.getInstance().getReverse(this.reverseType.getName())) == null) {
                        NoExistedReverseServiceException ne = new NoExistedReverseServiceException("null_reverse_service");
                        ne.addScene("reverse_type", this.reverseType.getName());
                        throw ne;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u51b2\u6b63\u7c7b\u578b=[" + this.reverseType.getName() + "]"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"\u6267\u884c\u51b2\u6b63\u670d\u52a1");
                    }
                    reverseService.reverse(serialId, errorAction);
                    break block31;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u670d\u52a1\u6267\u884c\u7ed3\u679c\u6570\u636e\u4e00\u81f4");
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u4e00\u81f4\u6027\u4ee3\u7406\u6267\u884c\u5f02\u5e38", (Throwable)e);
                }
                return result;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4e00\u81f4\u6027\u4ee3\u7406\u6267\u884c\u7ed3\u675f");
        }
        return result;
    }

    public ServiceConfig getConfig() {
        return this.config;
    }

    public void setService(Service service) {
        this.service = service;
        this.config = service.getConfig();
    }

    public Service getService() {
        return this.service;
    }

    public void setReverseType(ReverseType type) {
        this.reverseType = type;
    }

    public ReverseType getReverseType() {
        return this.reverseType;
    }
}

