/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.reverse;

import com.dc.eai.config.ErrorAction;
import com.dc.eai.dispatch.Context;
import com.dc.eai.service.journal.Journal;
import com.dc.eai.service.journal.JournalColumns;
import com.dc.eai.service.journal.JournalFactory;
import com.dc.eai.service.journal.JournalRecord;
import com.dc.eai.service.journal.JournalRecordSet;
import com.dc.eai.service.journal.ServiceJournal;
import com.dc.eai.service.journal.ServiceJournalFactory;
import com.dc.eai.service.reverse.ForceReverseTimeout;
import com.dc.eai.service.reverse.ReverseItemFactory;
import com.dc.eai.service.reverse.ReverseLastOption;
import com.dc.eai.service.reverse.ReverseResult;
import com.dc.eai.service.reverse.ReverseStatus;
import com.dc.eai.service.reverse.exception.ReverseException;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReverseTask {
    private Log log = LogFactory.getLog((Class)ReverseTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReverseResult execute(String serialId, ErrorAction action) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"-----\u5185\u90e8\u51b2\u6b63\u4efb\u52a1\u6267\u884c\u5f00\u59cb-----");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u5e73\u53f0\u8ddf\u8e2a\u53f7\uff1a" + serialId));
        }
        Context.getInstance().addProperty("isReverse", new Boolean(true));
        ReverseResult result = new ReverseResult();
        JournalRecord journalRecord = null;
        int journalSize = 0;
        try {
            ServiceJournal serviceJournal;
            Journal journal;
            JournalRecordSet journalRecords;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u67e5\u8be2\u5f53\u524d\u670d\u52a1\u6d41\u6c34\u8868");
            }
            if ((journalRecords = (journal = (serviceJournal = ServiceJournalFactory.getInstance().getServiceJournal()).getJournal()).getJournalRecordset(serialId)).isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u67e5\u8be2\u7ffb\u724c\u524d\u7684\u670d\u52a1\u6d41\u6c34\u8868");
                }
                if ((journalRecords = (journal = this.getLastJournal(serviceJournal.getJournalName())).getJournalRecordset(serialId)).isEmpty()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"\u65e0\u6d41\u6c34\u8bb0\u5f55\uff0c\u65e0\u6cd5\u51b2\u6b63");
                    }
                    result.setStatus(ReverseStatus.REVERSE_FAILED);
                    result.setException(new ReverseException("\u65e0\u6d41\u6c34\u8bb0\u5f55\uff0c\u65e0\u6cd5\u51b2\u6b63", serialId));
                    ReverseResult reverseResult = result;
                    return reverseResult;
                }
                if (!ReverseLastOption.allowed()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"\u4e0d\u5141\u8bb8\u5bf9\u7ffb\u724c\u524d\u7684\u6d41\u6c34\u8868\u51b2\u6b63");
                    }
                    result.setStatus(ReverseStatus.REVERSE_FAILED);
                    result.setException(new ReverseException("\u4e0d\u5141\u8bb8\u5bf9\u7ffb\u724c\u524d\u7684\u6d41\u6c34\u8868\u51b2\u6b63", serialId));
                    ReverseResult reverseResult = result;
                    return reverseResult;
                }
            }
            if (journalRecords.get((journalSize = journalRecords.size()) - 1).getStatus() != 1) {
                if (this.isForceReverse(journalRecords.get(journalSize - 1))) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"\u5f3a\u5236\u51b2\u6b63");
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u6b63\u670d\u52a1\u6267\u884c\u672a\u7ed3\u675f\uff0c\u4e0d\u6267\u884c\u51b2\u6b63");
                    result.setStatus(ReverseStatus.REVERSE_FAILED);
                    result.setException(new ReverseException("\u6b63\u670d\u52a1\u6267\u884c\u6210\u529f\uff0c\u975e\u5f3a\u5236\u51b2\u6b63\uff0c\u4e0d\u6267\u884c\u51b2\u6b63", serialId));
                    ReverseResult reverseResult = result;
                    return reverseResult;
                }
            }
            if (action == null && journalSize == 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u539f\u5b50\u670d\u52a1\u51b2\u6b63");
                }
                journalRecord = journalRecords.get(0);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u5904\u7406\u5f00\u59cb\uff0c\u670d\u52a1\u5e8f\u53f7\uff1a" + journalRecord.getSeq()));
                }
                result = ReverseItemFactory.getReverseItem().doReverse(journalRecord, result, journal);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u5904\u7406\u7ed3\u675f\uff0c\u670d\u52a1\u5e8f\u53f7\uff1a" + journalRecord.getSeq()));
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u975e\u539f\u5b50\u670d\u52a1\u51b2\u6b63");
                }
                int ii = 0;
                if (action.equals(ErrorAction.REVERSE_FROM_LAST)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"\u4ece\u4e0a\u4e00\u4e2a\u6267\u884c\u6210\u529f\u7684\u670d\u52a1\u5f00\u59cb\u51b2\u6b63");
                    }
                    ii = journalSize - 2;
                } else if (action.equals(ErrorAction.REVERSE)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"\u4ece\u5f53\u524d\u670d\u52a1\u5f00\u59cb\u51b2\u6b63");
                    }
                    ii = journalSize - 1;
                }
                if (ii < 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"\u7ec4\u5408\u670d\u52a1\u7684\u7b2c\u4e00\u4e2a\u6b65\u9aa4\u6267\u884c\u5931\u8d25\uff0c\u4e0d\u8fdb\u884c\u51b2\u6b63");
                    }
                    result.setStatus(ReverseStatus.REVERSE_FAILED);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("\u5185\u90e8\u51b2\u6b63\u4efb\u52a1\u6267\u884c\u7ed3\u679c=[" + result.getStatus().getName() + ":" + result.getStatus().getValue() + "]"));
                    }
                    ReverseResult reverseResult = result;
                    return reverseResult;
                }
                while (ii >= 0) {
                    journalRecord = journalRecords.get(ii);
                    boolean isContinue = this.sequentialReverse(journalRecord, result, journal);
                    if (!isContinue) {
                        if (journalRecord.getSeq() != journalSize) {
                            result.setStatus(ReverseStatus.REVERSE_PARTLY_SUCCESS);
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("\u5185\u90e8\u51b2\u6b63\u4efb\u52a1\u6267\u884c\u7ed3\u679c=[" + result.getStatus().getName() + ":" + result.getStatus().getValue() + "]"));
                        }
                        ReverseResult reverseResult = result;
                        return reverseResult;
                    }
                    --ii;
                }
            }
        }
        catch (ReverseException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u51b2\u6b63\u5904\u7406\u5f02\u5e38=[" + e.errCode() + "]"));
                e.printStackTrace();
            }
            result.setException(e);
            result.setStatus(ReverseStatus.REVERSE_FAILED);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u51b2\u6b63\u4efb\u52a1\u6267\u884c\u5f02\u5e38=[" + e.getMessage() + "]"));
                e.printStackTrace();
            }
            result.setException(new ReverseException("\u51b2\u6b63\u4efb\u52a1\u6267\u884c\u5f02\u5e38", serialId, e));
            result.setStatus(ReverseStatus.REVERSE_FAILED);
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("-----\u5185\u90e8\u51b2\u6b63\u4efb\u52a1\u6267\u884c\u7ed3\u675f-----\u670d\u52a1\u6d41\u6c34\u53f7\uff1a" + serialId));
            }
        }
        if (!result.getStatus().equals(ReverseStatus.REVERSE_FAILED)) {
            result.setStatus(ReverseStatus.REVERSE_SUCCESS);
        } else if (journalRecord != null && journalRecord.getSeq() != journalSize) {
            result.setStatus(ReverseStatus.REVERSE_PARTLY_SUCCESS);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u5185\u90e8\u51b2\u6b63\u4efb\u52a1\u6267\u884c\u7ed3\u679c=[" + result.getStatus().getName() + ":" + result.getStatus().getValue() + "]"));
        }
        return result;
    }

    private boolean isForceReverse(JournalRecord record) {
        long time;
        String currentTime = JournalColumns.TIME_FORMAT.format(new Date());
        String startTime = record.getStartTime();
        try {
            long currentTimeValue = JournalColumns.TIME_FORMAT.parse(currentTime).getTime();
            long startTimeValue = JournalColumns.TIME_FORMAT.parse(startTime).getTime();
            time = currentTimeValue - startTimeValue;
        }
        catch (ParseException e) {
            throw new ReverseException("parse_time_error", record.getId(), e);
        }
        String serviceName = record.getServiceName();
        if (!ForceReverseTimeout.contains(serviceName)) {
            return false;
        }
        int timeout = ForceReverseTimeout.getReverseTimeout(serviceName);
        return time >= (long)timeout;
    }

    private Journal getLastJournal(String name) {
        String lastName = name.equals("fw_sys_journal1") ? "fw_sys_journal2" : "fw_sys_journal1";
        return JournalFactory.getInstance().getJournal(lastName);
    }

    private boolean sequentialReverse(JournalRecord journalRecord, ReverseResult result, Journal journal) {
        ReverseStatus status;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u5904\u7406\u5f00\u59cb\uff0c\u670d\u52a1\u5e8f\u53f7\uff1a" + journalRecord.getSeq()));
        }
        result = ReverseItemFactory.getReverseItem().doReverse(journalRecord, result, journal);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u5904\u7406\u7ed3\u675f\uff0c\u670d\u52a1\u5e8f\u53f7\uff1a" + journalRecord.getSeq()));
        }
        return !(status = result.getStatus()).equals(ReverseStatus.REVERSE_FAILED);
    }
}

