/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.reverse;

import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.AtomServiceConfig;
import com.dc.eai.config.ServiceConfig;
import com.dc.eai.config.TransactionType;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.CompositeDataSet;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.service.Service;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import com.dc.eai.service.journal.Journal;
import com.dc.eai.service.journal.JournalRecord;
import com.dc.eai.service.reverse.ReversePermissionMap;
import com.dc.eai.service.reverse.ReverseResult;
import com.dc.eai.service.reverse.ReverseStatus;
import com.dc.eai.service.reverse.exception.ReverseException;
import com.dc.util.SerializeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReverseItem {
    private static final Log log = LogFactory.getLog((Class)ReverseItem.class);
    private static final String TX_LOG_NO = "reverse_log_no";
    private static final String DEFAULT_LOG_NO = "0000000000000000000";

    public ReverseResult doReverse(JournalRecord journalRecord, ReverseResult result, Journal journal) {
        ReverseStatus reverseStatus = null;
        String serviceName = journalRecord.getServiceName();
        int permission = ReversePermissionMap.getReversePermission(serviceName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u670d\u52a1[" + serviceName + "]\u7684\u51b2\u6b63\u6743\u9650=[" + permission + "]"));
        }
        if (permission == 1) {
            try {
                ServiceResult reverseResult;
                CompositeDataSet dataSet;
                if ((journalRecord.getResult() == 0 || journalRecord.getResult() == 3 || journalRecord.getResult() == 4) && journalRecord.getReverseStatus() != 1) {
                    Service reverseService;
                    Service service = (Service)ComponentManagerGetter.getManager().getComponent(serviceName);
                    if (service.getConfig() != null) {
                        AtomServiceConfig config = (AtomServiceConfig)service.getConfig();
                        TransactionType transactionType = config.getTransactionType();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("TransactionType=[" + transactionType.getName() + "]"));
                        }
                        if (!transactionType.equals(TransactionType.REVERSE)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\u8be5\u539f\u5b50\u670d\u52a1\u4e0d\u8fdb\u884c\u51b2\u6b63\uff0c\u670d\u52a1\u540d=[" + serviceName + "]," + "\u5e73\u53f0\u8ddf\u8e2a\u53f7=[" + journalRecord.getId() + "]," + "\u670d\u52a1\u6b65\u9aa4=[" + journalRecord.getSeq() + "]"));
                            }
                            result.setStatus(ReverseStatus.REVERSE_SUCCESS);
                            return result;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"\u627e\u51b2\u6b63\u539f\u5b50\u670d\u52a1");
                    }
                    try {
                        reverseService = this.getReverseService(service);
                    }
                    catch (Exception e) {
                        throw new ReverseException("\u627e\u51b2\u6b63\u539f\u5b50\u670d\u52a1\u5931\u8d25", journalRecord.getId(), e);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"\u83b7\u53d6\u51b2\u6b63\u8bf7\u6c42\u6570\u636e");
                    }
                    CompositeData requestData = this.getRequest(journalRecord);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"\u51b2\u6b63\u8bf7\u6c42\u6620\u5c04");
                    }
                    dataSet = result.getValue() == null ? new CompositeDataSet() : result.getValue();
                    int seq = journalRecord.getSeq();
                    dataSet.putData(seq + ".IN", requestData);
                    requestData = this.reverseMapping(requestData, service);
                    Field cycleFld = new Field(new FieldAttr(FieldType.FIELD_STRING, 8));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u9700\u51b2\u6b63\u7684\u670d\u52a1\u7cfb\u7edf\u4ea4\u6613\u5468\u671f=[" + journalRecord.getRespCycle() + "]"));
                    }
                    cycleFld.setValue(journalRecord.getRespCycle());
                    requestData.addField("resp_cycle", cycleFld);
                    Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 19));
                    String txLogNo = journalRecord.getRespTraceNo();
                    if (txLogNo == null || txLogNo.equals(DEFAULT_LOG_NO)) {
                        txLogNo = this.getFlowId(journalRecord);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u9700\u51b2\u6b63\u7684\u4ea4\u6613\u6d41\u6c34\u53f7=[" + txLogNo + "]"));
                    }
                    fld.setValue(txLogNo);
                    requestData.addField(TX_LOG_NO, fld);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u8bf7\u6c42\u6570\u636e=[" + requestData.toString() + "]"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"\u51b2\u6b63\u539f\u5b50\u670d\u52a1\u6267\u884c\u5f00\u59cb");
                    }
                    reverseResult = reverseService.execute(requestData);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u51b2\u6b63\u539f\u5b50\u670d\u52a1\u6267\u884c\u7ed3\u679c=[" + reverseResult.status().getValue() + "]"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"\u83b7\u5f97\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u7ed3\u679c\u72b6\u6001");
                    }
                    if (reverseResult.getOutput() != null) {
                        dataSet.putData(seq + ".OUT", reverseResult.getOutput());
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\u8be5\u539f\u5b50\u670d\u52a1\u5df2\u51b2\u6b63\u6210\u529f,\u4e0d\u518d\u5bf9\u5176\u51b2\u6b63,\u670d\u52a1\u540d=[" + serviceName + "]," + "\u5e73\u53f0\u8ddf\u8e2a\u53f7=[" + journalRecord.getId() + "]," + "\u670d\u52a1\u6b65\u9aa4=[" + journalRecord.getSeq() + "]"));
                    }
                    result.setStatus(ReverseStatus.REVERSE_SUCCESS);
                    return result;
                }
                result.setValue(dataSet);
                reverseStatus = this.getReverseStatus(reverseResult, result);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                    e.printStackTrace();
                }
                reverseStatus = ReverseStatus.REVERSE_FAILED;
                result.setException(new ReverseException("\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u6267\u884c\u5f02\u5e38", journalRecord.getId(), e));
            }
        } else if (permission == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u65e0\u9700\u51b2\u6b63,\u670d\u52a1\u540d=[" + serviceName + "]"));
            }
            reverseStatus = ReverseStatus.NO_NEED_REVERSE;
        } else if (permission == 2) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u62d2\u7edd\u51b2\u6b63,\u670d\u52a1\u540d=[" + serviceName + "]"));
            }
            reverseStatus = ReverseStatus.REVERSE_REFUSED;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u66f4\u65b0\u670d\u52a1\u6d41\u6c34\u8868");
        }
        journalRecord.setReverseStatus(reverseStatus.getValue());
        journal.updateJournalRecord(journalRecord);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u72b6\u6001=[" + reverseStatus.getName() + ":" + reverseStatus.getValue() + "]"));
        }
        result.setStatus(reverseStatus);
        return result;
    }

    private CompositeData reverseMapping(CompositeData data, Service service) {
        CompositeData mapData = new CompositeData();
        ServiceConfig serviceConfig = service.getConfig();
        if (serviceConfig != null) {
            AtomServiceConfig config = (AtomServiceConfig)serviceConfig;
            if (config.getReverseMapper() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u8bf7\u6c42\u6620\u5c04\u524d\u6570\u636e=[" + data + "]"));
                }
                ExpressionDataMapper mapper = new ExpressionDataMapper(config.getReverseMapper());
                mapper.map(data, mapData);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u8bf7\u6c42\u6620\u5c04\u540e\u6570\u636e=[" + mapData + "]"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"\u65e0\u539f\u5b50\u670d\u52a1\u51b2\u6b63\u8bf7\u6c42\u6620\u5c04\u914d\u7f6e\uff0c\u4e0d\u8fdb\u884c\u6d41\u6c34\u6620\u5c04");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"\u65e0\u539f\u5b50\u670d\u52a1\u914d\u7f6e\uff0c\u4e0d\u8fdb\u884c\u51b2\u6b63\u8bf7\u6c42\u6620\u5c04");
        }
        return mapData;
    }

    private CompositeData getRequest(JournalRecord journalRecord) {
        try {
            CompositeData requestData = (CompositeData)SerializeHelper.convert(journalRecord.getRequest());
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u6b63\u670d\u52a1\u8bf7\u6c42\u6570\u636e=[" + requestData.toString() + "]"));
            }
            return requestData;
        }
        catch (Exception e) {
            throw new ReverseException("\u83b7\u5f97\u539f\u5b50\u670d\u52a1\u8bf7\u6c42\u6570\u636e\u5931\u8d25", journalRecord.getId(), e);
        }
    }

    private Service getReverseService(Service originalService) {
        String reverseServiceName = ((AtomServiceConfig)originalService.getConfig()).getName();
        if (reverseServiceName == null && log.isErrorEnabled()) {
            log.error((Object)("null reverseServiceName, originalService=[" + originalService.getConfig().getName() + "]"));
        }
        Service reverseService = (Service)ComponentManagerGetter.getManager().getComponent(reverseServiceName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u51b2\u6b63\u539f\u5b50\u670d\u52a1\u540d=[" + reverseServiceName + "]"));
        }
        return reverseService;
    }

    private ReverseStatus getReverseStatus(ServiceResult reverseResult, ReverseResult result) {
        ServiceResultStatus status = reverseResult.status();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u51b2\u6b63\u539f\u5b50\u670d\u52a1\u7ed3\u679c=[" + status.getName() + ":" + status.getValue() + "]"));
        }
        if (status == ServiceResultStatus.ERROR || status == ServiceResultStatus.FAIL_BEFORE_REQUEST || status == ServiceResultStatus.UNKNOWN) {
            result.setStatus(ReverseStatus.REVERSE_FAILED);
            return ReverseStatus.REVERSE_FAILED;
        }
        result.setStatus(ReverseStatus.REVERSE_SUCCESS);
        return ReverseStatus.REVERSE_SUCCESS;
    }

    private String getFlowId(JournalRecord journalRecord) {
        int seq = journalRecord.getSeq();
        String serviceSequence = null;
        serviceSequence = seq < 10 ? "0" : "";
        serviceSequence = serviceSequence + seq;
        return journalRecord.getEaiId() + journalRecord.getId() + serviceSequence;
    }
}

