/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.reverse;

import com.dc.concurrent.Executor;
import com.dc.eai.config.ErrorAction;
import com.dc.eai.service.reverse.Reverse;
import com.dc.eai.service.reverse.ReverseExecutorFactory;
import com.dc.eai.service.reverse.ReverseResult;
import com.dc.eai.service.reverse.ReverseStatus;
import com.dc.eai.service.reverse.ReverseTaskFactory;
import com.dc.eai.service.reverse.SimpleTaskTracer;
import com.dc.eai.service.reverse.exception.ReverseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyReverse
implements Reverse {
    private Log log = LogFactory.getLog((Class)AsyReverse.class);

    public ReverseResult reverse(String serialId, ErrorAction action) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5f02\u6b65\u51b2\u6b63\u5904\u7406\u5f00\u59cb");
        }
        ReverseResult result = new ReverseResult();
        Executor executor = ReverseExecutorFactory.getExecutor();
        if (executor == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"\u4e0d\u80fd\u83b7\u5f97\u51b2\u6b63\u7ebf\u7a0b\u6267\u884c\u5668");
            }
            ReverseException re = new ReverseException("get_reverse_executor_error", serialId);
            result.setStatus(ReverseStatus.REVERSE_FAILED);
            result.setException(re);
            return result;
        }
        SimpleTaskTracer tracer = null;
        try {
            tracer = new SimpleTaskTracer(ReverseTaskFactory.getReverseTask(), serialId, action);
        }
        catch (Exception e) {
            ReverseException re = new ReverseException("create_task_tracer_error", serialId, e);
            result.setStatus(ReverseStatus.REVERSE_FAILED);
            result.setException(re);
            return result;
        }
        try {
            executor.execute(tracer);
        }
        catch (Exception e) {
            ReverseException re = new ReverseException("asy_reverse_service_error", serialId, e);
            result.setStatus(ReverseStatus.REVERSE_FAILED);
            result.setException(re);
            return result;
        }
        result.setStatus(ReverseStatus.REVERSE_SUCCESS);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5f02\u6b65\u51b2\u6b63\u5904\u7406\u7ed3\u675f");
        }
        return result;
    }
}

