/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.journal;

import com.dc.datastore.DataStoreMan;
import com.dc.db.DBRecord;
import com.dc.db.DBSql;
import com.dc.eai.service.journal.DBJournalHelper;
import com.dc.eai.service.journal.Journal;
import com.dc.eai.service.journal.JournalFactory;
import com.dc.eai.service.journal.ServiceJournal;
import com.dc.eai.service.journal.exception.JournalNotExistException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceJournalFactory {
    private static final Log log = LogFactory.getLog((Class)ServiceJournalFactory.class);
    private static ServiceJournalFactory factory = new ServiceJournalFactory();
    private static String JOURNAL_NAME_CONFIG = "journalname";
    private ServiceJournal serviceJournal = null;
    private String journalName = null;

    private ServiceJournalFactory() {
    }

    public static ServiceJournalFactory getInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("service_journal_factory=[" + factory + "]"));
        }
        return factory;
    }

    public synchronized ServiceJournal getServiceJournal() {
        if (this.serviceJournal == null) {
            this.serviceJournal = new ServiceJournal();
            this.updateServiceJournal();
        }
        return this.serviceJournal;
    }

    synchronized void updateServiceJournal() {
        Journal journal;
        if (this.serviceJournal == null) {
            this.serviceJournal = new ServiceJournal();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u5f53\u524d\u670d\u52a1\u6d41\u6c34\u8868=[" + this.serviceJournal.getJournalName() + "]"));
        }
        DBRecord rec = new DBRecord();
        rec = DBSql.getInstance(DBJournalHelper.DB_NAME).query("selectActiveJournal", rec);
        DataStoreMan.getInstance().getDataStore(DBJournalHelper.DB_NAME).close(true);
        this.journalName = rec.getString("journal_name").trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u5f85\u66f4\u65b0\u670d\u52a1\u6d41\u6c34\u8868=[" + this.journalName + "]"));
        }
        if ((journal = JournalFactory.getInstance().getJournal(this.journalName)) == null) {
            JournalNotExistException jne = new JournalNotExistException("journal_not_exist");
            jne.addScene("journalName", this.journalName);
            throw jne;
        }
        this.serviceJournal.setJournal(journal);
        this.serviceJournal.setJournalName(this.journalName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u66f4\u65b0\u540e\u670d\u52a1\u6d41\u6c34\u8868=[" + this.serviceJournal.getJournalName() + "]"));
        }
    }
}

