/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.journal;

import com.dc.db.DBException;
import com.dc.eai.data.CompositeData;
import com.dc.eai.dispatch.Context;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.journal.Journal;
import com.dc.eai.service.journal.JournalContext;
import com.dc.eai.service.journal.JournalRecord;
import com.dc.eai.service.journal.exception.JournalArgumentException;
import com.dc.eai.service.journal.exception.JournalExistException;
import com.dc.util.SerializeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceJournal {
    private static final Log log = LogFactory.getLog((Class)ServiceJournal.class);
    private String journalName;
    private Journal journal;
    private static final String eai_id = System.getProperty("eai_id");

    public void addServiceJournal(CompositeData request, CompositeData response) {
        JournalContext journalContext = this.getJournalContext();
        String serialId = journalContext.getSerialId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u589e\u52a0\u7684\u670d\u52a1\u6d41\u6c34\u8bb0\u5f55\u7684\u5e73\u53f0\u8ddf\u8e2a\u53f7=[" + serialId + "]"));
        }
        int seq = journalContext.getSeq();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u589e\u52a0\u7684\u670d\u52a1\u6d41\u6c34\u8bb0\u5f55\u7684\u670d\u52a1\u6b65\u9aa4=[" + seq + "]"));
        }
        JournalRecord journalRecord = this.generateJournalRecord(serialId, seq, journalContext, request, response);
        try {
            this.journal.addJournalRecord(journalRecord);
        }
        catch (DBException e) {
            if (e.errCode().equals("dbtable_insert_sqlexception")) {
                throw new JournalExistException("add_journal_record_exist", e);
            }
            throw e;
        }
    }

    public void updateServiceJournal(CompositeData request, CompositeData response) {
        JournalContext journalContext = this.getJournalContext();
        String serialId = journalContext.getSerialId();
        int seq = journalContext.getSeq();
        JournalRecord journalRecord = this.generateJournalRecord(serialId, seq, journalContext, request, response);
        this.journal.updateJournalRecord(journalRecord);
    }

    public void updateServiceJournal(int serviceStatus) {
        JournalContext journalContext = this.getJournalContext();
        String serialId = journalContext.getSerialId();
        int count = journalContext.getSeq();
        for (int seq = 1; seq <= count; ++seq) {
            this.journal.updateJournalStatus(serialId, seq, serviceStatus);
        }
    }

    private JournalContext getJournalContext() {
        if (!Context.getInstance().containsProperty(JournalContext.JOURNAL_CONTEXT)) {
            JournalArgumentException jae = new JournalArgumentException("null_journalContext");
            throw jae;
        }
        return (JournalContext)Context.getInstance().getProperty(JournalContext.JOURNAL_CONTEXT);
    }

    private JournalRecord generateJournalRecord(String id, int seq, JournalContext journalContext, CompositeData request, CompositeData response) {
        Context context = Context.getInstance();
        JournalRecord journalRecord = new JournalRecord();
        journalRecord.setApp(journalContext.getApp());
        journalRecord.setEndTime(journalContext.getEndTime());
        journalRecord.setId(id);
        journalRecord.setRequest(SerializeHelper.convert(request));
        journalRecord.setResponse(SerializeHelper.convert(response));
        ServiceResult result = journalContext.getResult();
        if (result != null) {
            journalRecord.setResult(result.status().getValue());
        } else {
            journalRecord.setResult(4);
        }
        journalRecord.setSeq(seq);
        journalRecord.setServiceName(context.getServiceName());
        journalRecord.setStartTime(journalContext.getStartTime());
        journalRecord.setStatus(journalContext.getStatus());
        journalRecord.setTranName(context.getTranName());
        journalRecord.setEaiId(eai_id);
        journalRecord.setSenderNodeId(context.getSenderNodeId());
        journalRecord.setSenderTraceNo(context.getSenderTraceNo());
        journalRecord.setSenderSysType(context.getSenderSysType());
        journalRecord.setSenderCycle(journalContext.getSenderCycle());
        journalRecord.setOriginalNodeId(context.getOriginalNodeId());
        journalRecord.setOriginalTraceNo(context.getOriginalTraceNo());
        journalRecord.setOriginalSysType(context.getOriginalSysType());
        journalRecord.setBranchId(context.getBranchId());
        journalRecord.setOriginalCycle(journalContext.getOriginalCycle());
        journalRecord.setRespTraceNo(context.getRespTraceNo());
        journalRecord.setRespCode(context.getRespCode());
        journalRecord.setRespDesc(context.getRespDesc());
        journalRecord.setRespCycle(journalContext.getRespCycle());
        journalRecord.setIsCompressed("0");
        return journalRecord;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public String getJournalName() {
        return this.journalName;
    }

    public void setJournalName(String journalName) {
        this.journalName = journalName;
    }
}

