/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.journal;

import com.dc.datastore.DataStore;
import com.dc.datastore.DataStoreMan;
import com.dc.datastore.PMException;
import com.dc.db.DBException;
import com.dc.db.DBRecord;
import com.dc.db.DBSql;
import com.dc.eai.service.journal.DBJournalHelper;
import com.dc.eai.service.journal.SerialIdQueue;
import com.dc.eai.service.journal.exception.IdGenerateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerialIdProducer
implements Runnable {
    private int size = 1000;
    private int defaultSize = 2000;
    private int sleepTime = 2000;
    private Log log = LogFactory.getLog((Class)SerialIdProducer.class);
    private boolean isStartup = true;
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("yyyyMMdd");

    public void run() {
        while (true) {
            if (this.isStartup) {
                this.produce(this.defaultSize);
                this.isStartup = false;
                continue;
            }
            this.produce(this.size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produce(int newSize) {
        block25: {
            if (SerialIdQueue.size() < this.size) {
                DBRecord rec;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u521b\u9020\u5e73\u53f0\u8ddf\u8e2a\u53f7\u5f00\u59cb");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u67e5\u8be2\u5f53\u524d\u6700\u5927\u5e73\u53f0\u8ddf\u8e2a\u53f7\u8868");
                }
                try {
                    rec = DBSql.getInstance(DBJournalHelper.DB_NAME).query("getMaxSerialID", new DBRecord());
                }
                finally {
                    DataStoreMan.getInstance().getDataStore(DBJournalHelper.DB_NAME).close(true);
                }
                if (rec == null) {
                    IdGenerateException ide = new IdGenerateException("null max_serial_id in database");
                    throw ide;
                }
                String maxSerialId = null;
                if (rec.columnSet().contains("max_serial_id")) {
                    maxSerialId = rec.getString("max_serial_id");
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("\u5f53\u524d\u6700\u5927\u5e73\u53f0\u8ddf\u8e2a\u53f7=[" + maxSerialId + "]"));
                    }
                }
                String today = timeFormat.format(new Date());
                long newId = 0L;
                newId = maxSerialId.startsWith(today) ? Long.parseLong(maxSerialId) + 1L : Long.parseLong(today + "00000000");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("\u9700\u521b\u9020\u7684\u6700\u5c0f\u5e73\u53f0\u8ddf\u8e2a\u53f7=[" + newId + "]"));
                }
                long i = 0L;
                while (i < (long)newSize) {
                    SerialIdQueue.putSerialId(Long.toString(newId));
                    ++i;
                    ++newId;
                }
                try {
                    DBRecord updateRec = new DBRecord();
                    updateRec.setString("max_serial_id", "" + --newId);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("\u521b\u9020\u7684\u6700\u5927\u5e73\u53f0\u8ddf\u8e2a\u53f7=[" + newId + "]"));
                    }
                    DataStore dataStore = DataStoreMan.getInstance().getDataStore(DBJournalHelper.DB_NAME);
                    try {
                        DBSql.getInstance(DBJournalHelper.DB_NAME).execute("updateMaxSerialID", updateRec);
                    }
                    catch (DBException dbe) {
                        throw dbe;
                    }
                    catch (Exception e) {
                        throw new DBException("dbsql_execute_error", e);
                    }
                    finally {
                        dataStore.close(true);
                    }
                }
                catch (PMException e) {
                    this.log.error((Object)"\u66f4\u65b0\u5f53\u524d\u6700\u5927\u5e73\u53f0\u8ddf\u8e2a\u53f7\u8868\u5f02\u5e38\uff01");
                    this.log.error((Object)"\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
                    IdGenerateException ide = new IdGenerateException(e.errCode());
                    ide.addScene("maxId", newId);
                    throw ide;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"\u521b\u9020\u5e73\u53f0\u8ddf\u8e2a\u53f7\u7ed3\u675f");
                }
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                if (!this.log.isDebugEnabled()) break block25;
                this.log.debug((Object)(e + "\n" + e.getMessage()));
            }
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }
}

