/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.journal;

import com.dc.eai.component.LifeCycle;
import com.dc.eai.config.ServiceConfig;
import com.dc.eai.config.ServiceType;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.dispatch.Context;
import com.dc.eai.service.Service;
import com.dc.eai.service.ServiceException;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import com.dc.eai.service.journal.IdGenerator;
import com.dc.eai.service.journal.JournalColumns;
import com.dc.eai.service.journal.JournalContext;
import com.dc.eai.service.journal.SequentialErrorHelper;
import com.dc.eai.service.journal.SerialIdGenerator;
import com.dc.eai.service.journal.ServiceJournal;
import com.dc.eai.service.journal.ServiceJournalFactory;
import com.dc.eai.service.journal.ServiceStatus;
import com.dc.eai.service.journal.exception.JournalArgumentException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JournalServiceProxy
implements Service,
LifeCycle {
    private Service service;
    private ServiceConfig config;
    private static Log log = LogFactory.getLog((Class)JournalServiceProxy.class);
    private static IdGenerator idGenerator = SerialIdGenerator.getInstance();

    public JournalServiceProxy(Service service) {
        this.service = service;
        this.config = service.getConfig();
    }

    public void start() {
        if (this.service instanceof LifeCycle) {
            ((LifeCycle)((Object)this.service)).start();
        }
    }

    public void stop() {
        if (this.service instanceof LifeCycle) {
            ((LifeCycle)((Object)this.service)).stop();
        }
    }

    public ServiceResult execute(CompositeData data) {
        ServiceResult result;
        ServiceJournal serviceJournal;
        int level;
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6d41\u6c34\u4ee3\u7406\u6267\u884c\u5f00\u59cb");
        }
        Context globalContext = Context.getInstance();
        String serialId = idGenerator.id();
        Boolean isReverse = (Boolean)globalContext.getProperty("isReverse");
        if (isReverse != null && isReverse.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u51b2\u6b63\u670d\u52a1\uff0c\u4e0d\u8bb0\u6d41\u6c34\uff0c\u670d\u52a1\u540d=[" + this.config.getName() + "]"));
            }
            ServiceResult result2 = this.service.execute(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u7ed3\u679c\u72b6\u6001=[" + result2.status().getName() + ":" + result2.status().getValue() + "]"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u6d41\u6c34\u4ee3\u7406\u6267\u884c\u7ed3\u675f");
            }
            return result2;
        }
        globalContext.setSerialId(serialId);
        if (globalContext.getSenderNodeId() == null || "".equals(globalContext.getSenderNodeId())) {
            globalContext.setSenderNodeId("rmi0000001");
        }
        JournalContext journalContext = (JournalContext)globalContext.getProperty(JournalContext.JOURNAL_CONTEXT);
        try {
            if (this.config == null) {
                this.config = this.service.getConfig();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u6d41\u6c34\u4e0a\u4e0b\u6587=[" + journalContext + "]"));
            }
            if (journalContext == null || !journalContext.getSerialId().equals(serialId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u521b\u5efa\u6d41\u6c34\u4e0a\u4e0b\u6587");
                }
                journalContext = new JournalContext();
                if (serialId == null) {
                    JournalArgumentException jae = new JournalArgumentException("null_serialId");
                    throw jae;
                }
                journalContext.setSerialId(serialId);
                journalContext.setServiceJournal(ServiceJournalFactory.getInstance().getServiceJournal());
                Context.getInstance().addProperty(JournalContext.JOURNAL_CONTEXT, journalContext);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5e73\u53f0\u8ddf\u8e2a\u53f7=[" + Context.getInstance().getSerialId() + "]"));
            }
            journalContext = (JournalContext)Context.getInstance().getProperty(JournalContext.JOURNAL_CONTEXT);
            level = journalContext.getLevel();
            journalContext.setLevel(++level);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u66f4\u65b0\u6d41\u6c34\u4e2d\u670d\u52a1\u5c42\u6b21");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u5c42\u6b21=[" + level + "]"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u83b7\u5f97\u670d\u52a1\u6d41\u6c34\u8868");
            }
            if ((serviceJournal = journalContext.getServiceJournal()) == null) {
                JournalArgumentException jae = new JournalArgumentException("null_serviceJournal");
                log.error((Object)"\u670d\u52a1\u6d41\u6c34\u8868\u4e3a\u7a7a", (Throwable)jae);
                ServiceResult result3 = new ServiceResult();
                result3.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                result3.setException(jae);
                return result3;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u6d41\u6c34\u8868\u540d=[" + serviceJournal.getJournalName() + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)"\u670d\u52a1\u6267\u884c\u524d\u6d41\u6c34\u5904\u7406\u5f02\u5e38", (Throwable)e);
            ServiceResult result4 = new ServiceResult();
            result4.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
            result4.setException(e);
            return result4;
        }
        if (this.config.getType().equals(ServiceType.ATOM_SERVICE) || this.config.getType().equals(ServiceType.EXTEND_SERVICE)) {
            boolean isSequentialError;
            String serviceName = this.config.getName();
            Context context = Context.getInstance();
            context.setServiceName(serviceName);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" edit by zhoujie \u670d\u52a1\u6267\u884c\u524d\u6d41\u6c34\u5904\u7406\u670d\u52a1\u7c7b\u578b\uff1a" + this.config.getType() + "  \u670d\u52a1\u540d\u79f0\uff1a" + this.config.getName()));
            }
            try {
                isSequentialError = !this.beforeServiceExecute(data, serviceJournal);
            }
            catch (Exception e) {
                log.error((Object)"\u670d\u52a1\u6267\u884c\u524d\u6d41\u6c34\u5904\u7406\u5f02\u5e38", (Throwable)e);
                ServiceResult result5 = new ServiceResult();
                result5.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                result5.setException(e);
                return result5;
            }
            if (isSequentialError) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u65f6\u5e8f\u9519\u8bef");
                }
                return journalContext.getResult();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u6267\u884c\uff0c\u670d\u52a1\u540d=[" + this.config.getName() + "]"));
            }
            result = this.service.execute(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u670d\u52a1\u6267\u884c\u540e\u6d41\u6c34\u5904\u7406");
            }
            try {
                this.afterServiceExecute(result, serviceJournal);
            }
            catch (Exception e) {
                log.error((Object)"\u670d\u52a1\u6267\u884c\u540e\u6d41\u6c34\u5904\u7406\u5f02\u5e38", (Throwable)e);
                result = new ServiceResult();
                result.setStatus(ServiceResultStatus.FAIL_AFTER_REQUEST);
                result.setException(e);
                return result;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u670d\u52a1\u6267\u884c");
        }
        result = this.service.execute(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u670d\u52a1\u7ed3\u679c\u72b6\u6001=[" + result.status().getName() + ":" + result.status().getValue() + "]"));
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u66f4\u65b0\u6d41\u6c34\u4e2d\u670d\u52a1\u5c42\u6b21");
            }
            journalContext.setLevel(--level);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u5c42\u6b21=[" + level + "]"));
            }
            if (level == 0) {
                serviceJournal.updateServiceJournal(1);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u670d\u52a1\u6267\u884c\u540e\u6d41\u6c34\u4ee3\u7406\u6267\u884c\u5f02\u5e38", (Throwable)e);
            result = new ServiceResult();
            result.setStatus(ServiceResultStatus.FAIL_AFTER_REQUEST);
            result.setException(e);
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6d41\u6c34\u4ee3\u7406\u6267\u884c\u7ed3\u675f");
        }
        return result;
    }

    private boolean beforeServiceExecute(CompositeData data, ServiceJournal serviceJournal) {
        Field senderTraceNoFld;
        String senderTraceNo;
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u670d\u52a1\u6267\u884c\u524d\u6d41\u6c34\u5904\u7406\u5f00\u59cb");
        }
        if ((senderTraceNo = Context.getInstance().getSenderTraceNo()) == null || senderTraceNo == "") {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u81ea\u52a8\u751f\u6210\u4e1a\u52a1\u8ddf\u8e2a\u53f7");
            }
            senderTraceNo = Context.getInstance().getSerialId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u4e1a\u52a1\u8ddf\u8e2a\u53f7=[" + senderTraceNo + "]"));
            }
            Context.getInstance().setSenderTraceNo(senderTraceNo);
        }
        boolean sequentialError = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u5224\u65ad\u65f6\u5e8f\u662f\u5426\u9519\u8bef");
        }
        sequentialError = SequentialErrorHelper.isSequentialError();
        CompositeData mapData = new CompositeData();
        if (this.config != null) {
            if (this.config.getJournalMapper() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u6d41\u6c34\u6620\u5c04");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u6d41\u6c34\u6620\u5c04\u524d\u6570\u636e=[" + data + "]"));
                }
                ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getJournalMapper());
                mapper.map(data, mapData);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u6d41\u6c34\u6620\u5c04\u540e\u6570\u636e=[" + mapData + "]"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"\u65e0\u6d41\u6c34\u6620\u5c04\u914d\u7f6e\uff0c\u4e0d\u8fdb\u884c\u6d41\u6c34\u6620\u5c04");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"\u65e0\u670d\u52a1\u914d\u7f6e\uff0c\u4e0d\u8fdb\u884c\u6d41\u6c34\u6620\u5c04");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u66f4\u65b0\u6d41\u6c34\u4e0a\u4e0b\u6587");
        }
        JournalContext journalContext = (JournalContext)Context.getInstance().getProperty(JournalContext.JOURNAL_CONTEXT);
        journalContext.setApp(mapData);
        int seq = journalContext.getSeq();
        journalContext.setSeq(++seq);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u670d\u52a1\u6b65\u9aa4\u53f7=[" + seq + "]"));
        }
        journalContext.setStatus(2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u670d\u52a1\u6267\u884c\u72b6\u6001=[" + ServiceStatus.PROCESSING.getName() + ":" + 2 + "]"));
        }
        journalContext.setResult(null);
        journalContext.setEndTime(null);
        String startTime = JournalColumns.TIME_FORMAT.format(new Date());
        journalContext.setStartTime(startTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u670d\u52a1\u6267\u884c\u5f00\u59cb\u65f6\u95f4=[" + startTime + "]"));
        }
        if (sequentialError) {
            String endTime = JournalColumns.TIME_FORMAT.format(new Date());
            journalContext.setStatus(1);
            journalContext.setEndTime(endTime);
            ServiceResult error = new ServiceResult();
            error.setStatus(ServiceResultStatus.SEQUENTIAL_ERROR);
            error.setException(new ServiceException("sequential_error"));
            journalContext.setResult(error);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u589e\u52a0\u670d\u52a1\u6d41\u6c34\u8bb0\u5f55");
        }
        serviceJournal.addServiceJournal(data, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u66f4\u65b0\u670d\u52a1\u8bf7\u6c42\u6570\u636e");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u66f4\u65b0\u524d\u670d\u52a1\u8bf7\u6c42\u6570\u636e=[" + data + "]"));
        }
        if ((senderTraceNoFld = data.getField("sender_trace_no")) == null) {
            senderTraceNoFld = new Field(new FieldAttr(FieldType.FIELD_STRING, 16));
            senderTraceNoFld.setValue(senderTraceNo);
            data.addField("sender_trace_no", senderTraceNoFld);
        } else {
            senderTraceNoFld.setValue(senderTraceNo);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u66f4\u65b0\u540e\u670d\u52a1\u8bf7\u6c42\u6570\u636e=[" + data + "]"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u670d\u52a1\u6267\u884c\u524d\u6d41\u6c34\u5904\u7406\u7ed3\u675f");
        }
        return true;
    }

    private void afterServiceExecute(ServiceResult serviceResult, ServiceJournal serviceJournal) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u670d\u52a1\u6267\u884c\u540e\u6d41\u6c34\u5904\u7406\u5f00\u59cb");
        }
        String endTime = JournalColumns.TIME_FORMAT.format(new Date());
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u83b7\u5f97\u670d\u52a1\u54cd\u5e94\u62a5\u6587");
        }
        CompositeData respData = serviceResult.getOutput();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u670d\u52a1\u54cd\u5e94\u62a5\u6587=[" + respData + "]"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u66f4\u65b0\u6d41\u6c34\u4e0a\u4e0b\u6587");
        }
        JournalContext journalContext = (JournalContext)Context.getInstance().getProperty(JournalContext.JOURNAL_CONTEXT);
        if (Context.getInstance().containsProperty("resp_cycle")) {
            journalContext.setRespCycle((String)Context.getInstance().getProperty("resp_cycle"));
        }
        if (Context.getInstance().containsProperty(JournalContext.JOURNAL_CONTEXT)) {
            journalContext.setEndTime(endTime);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u6267\u884c\u7ed3\u675f\u65f6\u95f4=[" + endTime + "]"));
            }
            journalContext.setResult(serviceResult);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u7ed3\u679c\u72b6\u6001=[" + serviceResult.status().getName() + ":" + serviceResult.status().getValue() + "]"));
            }
            journalContext.setStatus(2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u670d\u52a1\u6267\u884c\u72b6\u6001=[" + ServiceStatus.PROCESSING.getName() + ":" + 2 + "]"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u66f4\u65b0\u670d\u52a1\u6d41\u6c34\u8bb0\u5f55");
        }
        serviceJournal.updateServiceJournal(null, respData);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u670d\u52a1\u6267\u884c\u540e\u6d41\u6c34\u5904\u7406\u7ed3\u675f");
        }
    }

    public ServiceConfig getConfig() {
        return this.config;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
        this.config = service.getConfig();
    }
}

