/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.journal;

import com.dc.db.DBException;
import com.dc.db.DBRecord;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.DataDictionary;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.service.Service;
import com.dc.eai.service.journal.JournalRecord;
import com.dc.eai.service.journal.exception.JournalArgumentException;
import com.dc.eai.service.journal.exception.JournalRecordException;
import com.dc.eai.service.journal.exception.JournalRetrieveException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JournalHelper {
    private static Log log = LogFactory.getLog((Class)JournalHelper.class);

    public static DBRecord convert(JournalRecord journalRecord) {
        CompositeData app;
        String compressedType;
        String isCompressed;
        String respCycle;
        String respNodeId;
        String respDesc;
        String respCode;
        String respTraceNo;
        String originalCycle;
        String branchId;
        String originalSysType;
        String originalTraceNo;
        String originalNodeId;
        String senderCycle;
        String senderSysType;
        String senderTraceNo;
        String endTime;
        String startTime;
        byte[] response;
        String tranName;
        if (journalRecord == null) {
            return null;
        }
        DBRecord dbRecord = new DBRecord();
        String eaiId = journalRecord.getEaiId();
        if (eaiId == null) {
            JournalArgumentException jae = new JournalArgumentException("null_eai_id");
            jae.addScene("eai_id", eaiId);
            throw jae;
        }
        dbRecord.setString("eai_id", eaiId);
        String serialId = journalRecord.getId();
        if (serialId == null) {
            JournalRecordException jre = new JournalRecordException("null_serial_id");
            jre.addScene("serial_id", serialId);
            throw jre;
        }
        dbRecord.setString("serial_id", serialId);
        int seq = journalRecord.getSeq();
        if (seq == 0) {
            JournalRecordException jre = new JournalRecordException("service_sequence error");
            jre.addScene("service_sequence", seq);
            throw jre;
        }
        String senderNodeId = journalRecord.getSenderNodeId();
        if (senderNodeId == null) {
            JournalRecordException jre = new JournalRecordException("null_sender_node_id");
            jre.addScene("sender_node_id", senderNodeId);
            throw jre;
        }
        dbRecord.setString("sender_node_id", senderNodeId);
        dbRecord.setInt("service_sequence", seq);
        String serviceName = journalRecord.getServiceName();
        if (serviceName != null) {
            dbRecord.setString("service_name", serviceName);
        }
        if ((tranName = journalRecord.getTranName()) != null) {
            dbRecord.setString("tran_name", tranName);
        }
        dbRecord.setInt("service_status", journalRecord.getStatus());
        dbRecord.setInt("service_result_status", journalRecord.getResult());
        dbRecord.setInt("reverse_status", journalRecord.getReverseStatus());
        dbRecord.setString("is_compressed", "0");
        byte[] request = journalRecord.getRequest();
        if (request != null) {
            dbRecord.setBytes("service_request", request);
        }
        if ((response = journalRecord.getResponse()) != null) {
            dbRecord.setBytes("service_response", response);
        }
        if ((startTime = journalRecord.getStartTime()) != null) {
            dbRecord.setString("start_time", startTime);
        }
        if ((endTime = journalRecord.getEndTime()) != null) {
            dbRecord.setString("end_time", endTime);
        }
        if ((senderTraceNo = journalRecord.getSenderTraceNo()) != null) {
            dbRecord.setString("sender_trace_no", senderTraceNo);
        }
        if ((senderSysType = journalRecord.getSenderSysType()) != null) {
            dbRecord.setString("sender_sys_type", senderSysType);
        }
        if ((senderCycle = journalRecord.getSenderCycle()) != null) {
            dbRecord.setString("sender_cycle", senderCycle);
        }
        if ((originalNodeId = journalRecord.getOriginalNodeId()) != null) {
            dbRecord.setString("original_node_id", originalNodeId);
        }
        if ((originalTraceNo = journalRecord.getOriginalTraceNo()) != null) {
            dbRecord.setString("original_trace_no", originalTraceNo);
        }
        if ((originalSysType = journalRecord.getOriginalSysType()) != null) {
            dbRecord.setString("original_sys_type", originalSysType);
        }
        if ((branchId = journalRecord.getBranchId()) != null) {
            dbRecord.setString("branch_id", branchId);
        }
        if ((originalCycle = journalRecord.getOriginalCycle()) != null) {
            dbRecord.setString("original_cycle", originalCycle);
        }
        if ((respTraceNo = journalRecord.getRespTraceNo()) != null) {
            dbRecord.setString("resp_trace_no", respTraceNo);
        }
        if ((respCode = journalRecord.getRespCode()) != null) {
            dbRecord.setString("resp_code", respCode);
        }
        if ((respDesc = journalRecord.getRespDesc()) != null) {
            dbRecord.setString("resp_desc", respDesc);
        }
        if ((respNodeId = journalRecord.getRespDesc()) != null) {
            dbRecord.setString("resp_node_id", respNodeId);
        }
        if ((respCycle = journalRecord.getRespCycle()) != null) {
            dbRecord.setString("resp_cycle", respCycle);
        }
        if ((isCompressed = journalRecord.getIsCompressed()) != null) {
            dbRecord.setString("is_compressed", isCompressed);
        }
        if ((compressedType = journalRecord.getCompressedType()) != null) {
            dbRecord.setString("compressed_type", compressedType);
        }
        if ((app = journalRecord.getApp()) != null) {
            Iterator it = app.iterator();
            while (it.hasNext()) {
                String fldName = null;
                try {
                    fldName = (String)it.next();
                    if (!app.getObject(fldName).isField()) continue;
                    Field fld = app.getField(fldName);
                    if (fld.getFieldType().equals(FieldType.FIELD_BYTE) || fld.getFieldType().equals(FieldType.FIELD_INT) || fld.getFieldType().equals(FieldType.FIELD_SHORT)) {
                        dbRecord.setInt(fldName, fld.intValue());
                        continue;
                    }
                    if (fld.getFieldType().equals(FieldType.FIELD_DOUBLE) || fld.getFieldType().equals(FieldType.FIELD_FLOAT)) {
                        dbRecord.setDouble(fldName, fld.doubleValue());
                        continue;
                    }
                    if (fld.getFieldType().equals(FieldType.FIELD_INT24) || fld.getFieldType().equals(FieldType.FIELD_LONG)) {
                        dbRecord.setLong(fldName, fld.longValue());
                        continue;
                    }
                    if (fld.getFieldType().equals(FieldType.FIELD_STRING)) {
                        dbRecord.setString(fldName, fld.strValue());
                        continue;
                    }
                    dbRecord.setBytes(fldName, fld.imageValue());
                }
                catch (Exception e) {
                    JournalRecordException jre = new JournalRecordException("journal2DBRecord_error");
                    jre.addScene("fldName", fldName);
                    throw jre;
                }
            }
        }
        return dbRecord;
    }

    /*
     * Unable to fully structure code
     */
    public static JournalRecord convert(DBRecord dbRecord) {
        if (dbRecord == null) {
            return null;
        }
        journalRecord = new JournalRecord();
        columns = dbRecord.columnSet();
        if (!columns.contains("serial_id")) {
            jre = new JournalRetrieveException("null_serial_id");
            throw jre;
        }
        journalRecord.setId(dbRecord.getString("serial_id"));
        if (!columns.contains("service_sequence")) {
            jre = new JournalRetrieveException("null_service_sequence");
            throw jre;
        }
        journalRecord.setSeq(dbRecord.getInt("service_sequence"));
        if (!columns.contains("eai_id")) {
            jre = new JournalRetrieveException("null_eai_id");
            throw jre;
        }
        journalRecord.setEaiId(dbRecord.getString("eai_id"));
        if (columns.contains("tran_name")) {
            journalRecord.setTranName(dbRecord.getString("tran_name"));
        } else {
            journalRecord.setTranName(null);
        }
        if (columns.contains("service_status")) {
            journalRecord.setStatus(dbRecord.getInt("service_status"));
        } else {
            journalRecord.setStatus(0);
        }
        if (columns.contains("service_result_status")) {
            journalRecord.setResult(dbRecord.getInt("service_result_status"));
        } else {
            journalRecord.setResult(4);
        }
        if (columns.contains("reverse_status")) {
            journalRecord.setReverseStatus(dbRecord.getInt("reverse_status"));
        } else {
            journalRecord.setReverseStatus(0);
        }
        if (columns.contains("service_request")) {
            journalRecord.setRequest(dbRecord.getBytes("service_request"));
        } else {
            journalRecord.setRequest(null);
        }
        if (columns.contains("service_response")) {
            journalRecord.setResponse(dbRecord.getBytes("service_response"));
        } else {
            journalRecord.setResponse(null);
        }
        if (columns.contains("start_time")) {
            journalRecord.setStartTime(dbRecord.getString("start_time"));
        } else {
            journalRecord.setStartTime(null);
        }
        if (columns.contains("end_time")) {
            journalRecord.setEndTime(dbRecord.getString("end_time"));
        } else {
            journalRecord.setEndTime(null);
        }
        if (columns.contains("sender_trace_no")) {
            journalRecord.setSenderTraceNo(dbRecord.getString("sender_trace_no"));
        } else {
            journalRecord.setSenderTraceNo(null);
        }
        if (columns.contains("sender_node_id")) {
            journalRecord.setSenderNodeId(dbRecord.getString("sender_node_id"));
        } else {
            journalRecord.setSenderNodeId(null);
        }
        if (columns.contains("sender_sys_type")) {
            journalRecord.setSenderSysType(dbRecord.getString("sender_sys_type"));
        } else {
            journalRecord.setSenderSysType(null);
        }
        if (columns.contains("original_node_id")) {
            journalRecord.setOriginalNodeId(dbRecord.getString("original_node_id"));
        } else {
            journalRecord.setOriginalNodeId(null);
        }
        if (columns.contains("original_trace_no")) {
            journalRecord.setOriginalTraceNo(dbRecord.getString("original_trace_no"));
        } else {
            journalRecord.setOriginalTraceNo(null);
        }
        if (columns.contains("original_sys_type")) {
            journalRecord.setOriginalSysType(dbRecord.getString("original_sys_type"));
        } else {
            journalRecord.setOriginalSysType(null);
        }
        if (columns.contains("branch_id")) {
            journalRecord.setBranchId(dbRecord.getString("branch_id"));
        } else {
            journalRecord.setBranchId(null);
        }
        if (columns.contains("original_cycle")) {
            journalRecord.setOriginalCycle(dbRecord.getString("original_cycle"));
        } else {
            journalRecord.setOriginalCycle(null);
        }
        if (columns.contains("resp_trace_no")) {
            journalRecord.setRespTraceNo(dbRecord.getString("resp_trace_no"));
        } else {
            journalRecord.setRespTraceNo(null);
        }
        if (columns.contains("resp_code")) {
            journalRecord.setRespCode(dbRecord.getString("resp_code"));
        } else {
            journalRecord.setRespCode(null);
        }
        if (columns.contains("resp_desc")) {
            journalRecord.setRespDesc(dbRecord.getString("resp_desc"));
        } else {
            journalRecord.setRespDesc(null);
        }
        if (columns.contains("resp_node_id")) {
            journalRecord.setRespNodeId(dbRecord.getString("resp_node_id"));
        } else {
            journalRecord.setRespNodeId(null);
        }
        if (columns.contains("resp_cycle")) {
            journalRecord.setRespCycle(dbRecord.getString("resp_cycle"));
        } else {
            journalRecord.setRespCycle(null);
        }
        if (columns.contains("sender_cycle")) {
            journalRecord.setSenderCycle(dbRecord.getString("sender_cycle"));
        } else {
            journalRecord.setSenderCycle(null);
        }
        if (columns.contains("is_compressed")) {
            journalRecord.setIsCompressed(dbRecord.getString("is_compressed"));
        } else {
            journalRecord.setIsCompressed(null);
        }
        if (columns.contains("compressed_type")) {
            journalRecord.setCompressedType(dbRecord.getString("compressed_type"));
        } else {
            journalRecord.setCompressedType(null);
        }
        serviceName = null;
        if (columns.contains("service_name")) {
            serviceName = dbRecord.getString("service_name");
            journalRecord.setServiceName(serviceName);
            if (serviceName != null) {
                app = null;
                service = ComponentManagerGetter.getManager().getComponent(serviceName);
                if (service != null && (config = ((Service)service).getConfig()) != null && (mapper = config.getJournalMapper()) != null) {
                    app = new CompositeData();
                    for (i = 0; i < mapper.size(); ++i) {
                        fldName = null;
                        try {
                            block78: {
                                fldName = mapper.getItemName(i);
                                dict = DataDictionary.instance().getItem(fldName);
                                type = dict.getType();
                                length = dict.getLength();
                                scale = dict.getScale();
                                fld = new Field(new FieldAttr(type, length, scale));
                                if (type.equals(FieldType.FIELD_BYTE) || type.equals(FieldType.FIELD_INT) || type.equals(FieldType.FIELD_SHORT)) {
                                    try {
                                        fld.setValue(dbRecord.getInt(fldName));
                                    }
                                    catch (DBException e) {
                                        if (e.errCode().equals("column_not_exist_in_dbrecord")) ** GOTO lbl165
                                        throw e;
                                    }
                                } else if (type.equals(FieldType.FIELD_DOUBLE) || type.equals(FieldType.FIELD_FLOAT)) {
                                    try {
                                        fld.setValue(dbRecord.getDouble(fldName));
                                    }
                                    catch (DBException e) {
                                        if (e.errCode().equals("column_not_exist_in_dbrecord")) ** GOTO lbl165
                                        throw e;
                                    }
                                } else if (type.equals(FieldType.FIELD_INT24) || type.equals(FieldType.FIELD_LONG)) {
                                    try {
                                        fld.setValue(dbRecord.getLong(fldName));
                                    }
                                    catch (DBException e) {
                                        if (e.errCode().equals("column_not_exist_in_dbrecord")) ** GOTO lbl165
                                        throw e;
                                    }
                                } else if (type.equals(FieldType.FIELD_STRING)) {
                                    try {
                                        fld.setValue(dbRecord.getString(fldName));
                                    }
                                    catch (DBException e) {
                                        if (e.errCode().equals("column_not_exist_in_dbrecord")) ** GOTO lbl165
                                        throw e;
                                    }
                                } else {
                                    try {
                                        fld.setValue(dbRecord.getBytes(fldName));
                                    }
                                    catch (DBException e) {
                                        if (e.errCode().equals("column_not_exist_in_dbrecord")) break block78;
                                        throw e;
                                    }
                                }
                            }
                            app.addField(fldName, fld);
                            continue;
                        }
                        catch (Exception e) {
                            jre = new JournalRetrieveException("DBRecord2journal_error");
                            jre.addScene("fldName", fldName);
                            throw jre;
                        }
                    }
                }
                journalRecord.setApp(app);
            } else if (JournalHelper.log.isErrorEnabled()) {
                JournalHelper.log.error((Object)"\u670d\u52a1\u540d\u4e3a\u7a7a");
            }
        }
        return journalRecord;
    }
}

