/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.journal;

import com.dc.eai.service.journal.Journal;
import com.dc.eai.service.journal.exception.JournalExistException;
import com.dc.eai.service.journal.exception.JournalNotExistException;
import java.util.HashMap;
import java.util.Map;

public class JournalFactory {
    private static JournalFactory factory = new JournalFactory();
    private Map journalMap = new HashMap(20);

    private JournalFactory() {
    }

    public static JournalFactory getInstance() {
        return factory;
    }

    public Journal getJournal(String name) {
        Journal journal = null;
        if (!this.journalMap.containsKey(name)) {
            JournalNotExistException je = new JournalNotExistException("journal_not_exist");
            je.addScene("journalName", name);
            throw je;
        }
        journal = (Journal)this.journalMap.get(name);
        return journal;
    }

    public void addJournal(String name, Journal journal) {
        if (this.journalMap.containsKey(name)) {
            JournalExistException je = new JournalExistException("journal_exist");
            je.addScene("journalName", name);
            throw je;
        }
        this.journalMap.put(name, journal);
    }

    public void removeJournal(String name) {
        if (this.journalMap.containsKey(name)) {
            this.journalMap.remove(name);
        }
    }
}

