/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.journal;

import com.dc.datastore.DataStore;
import com.dc.datastore.DataStoreMan;
import com.dc.db.DBException;
import com.dc.db.DBRecord;
import com.dc.db.DBRecordSet;
import com.dc.db.DBSql;
import com.dc.db.DBTable;
import com.dc.eai.service.journal.Journal;
import com.dc.eai.service.journal.JournalHelper;
import com.dc.eai.service.journal.JournalRecord;
import com.dc.eai.service.journal.JournalRecordSet;
import com.dc.eai.service.journal.exception.JournalArgumentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBJournal
implements Journal {
    private String dbName;
    private String tbName;
    private static Log log = LogFactory.getLog((Class)DBJournal.class);
    private static final String GET_JOURNAL_RECORDS = "getJournalRecordsFrom";

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTbName() {
        return this.tbName;
    }

    public void setTbName(String tbName) {
        this.tbName = tbName;
    }

    private void checkParam(JournalRecord journalRecord) {
        if (journalRecord == null || journalRecord.getId() == null || journalRecord.getId().trim().equals("") || journalRecord.getSeq() < 0) {
            JournalArgumentException e = new JournalArgumentException("journal_argument_exception");
            e.addScene("rule", "\u6709\u6548\u6027\u89c4\u5219\uff1arecord\u4e0d\u80fd\u4e3anull; id\u4e0d\u80fd\u4e3anull;level\u4e0d\u80fd\u5c0f\u4e8e0;seq\u4e0d\u80fd\u5c0f\u4e8e0");
            e.addScene("record", journalRecord);
            if (journalRecord != null) {
                e.addScene("id", journalRecord.getId());
                e.addScene("seq", journalRecord.getSeq());
            }
            throw e;
        }
    }

    public void addJournalRecord(JournalRecord journalRecord) {
        this.checkParam(journalRecord);
        DBRecord dbRecord = JournalHelper.convert(journalRecord);
        DataStore dataStore = DataStoreMan.getInstance().getDataStore(this.dbName);
        try {
            DBTable.getInstance(this.dbName).insert(this.tbName, dbRecord);
        }
        catch (DBException dbe) {
            throw dbe;
        }
        catch (Exception e) {
            throw new DBException("dbtable_insert_error", e);
        }
        finally {
            dataStore.close(true);
        }
    }

    public void updateJournalRecord(JournalRecord journalRecord) {
        this.checkParam(journalRecord);
        DBRecord dbRecord = JournalHelper.convert(journalRecord);
        DataStore dataStore = DataStoreMan.getInstance().getDataStore(this.dbName);
        try {
            DBTable.getInstance(this.dbName).update(this.tbName, dbRecord);
        }
        catch (DBException dbe) {
            throw dbe;
        }
        catch (Exception e) {
            throw new DBException("dbtable_update_error", e);
        }
        finally {
            dataStore.close(true);
        }
    }

    public void updateJournalStatus(String id, int seq, int status) {
        DBRecord dbRecord = new DBRecord();
        String eaiId = System.getProperty("eai_id");
        if (eaiId == null) {
            JournalArgumentException jae = new JournalArgumentException("null eai_id");
            jae.addScene("eai_id", eaiId);
            throw jae;
        }
        dbRecord.setString("eai_id", eaiId);
        dbRecord.setString("serial_id", id);
        dbRecord.setInt("service_sequence", seq);
        dbRecord.setInt("service_status", status);
        DataStore dataStore = DataStoreMan.getInstance().getDataStore(this.dbName);
        try {
            DBTable.getInstance(this.dbName).update(this.tbName, dbRecord);
        }
        catch (DBException dbe) {
            throw dbe;
        }
        catch (Exception e) {
            throw new DBException("dbtable_update_error", e);
        }
        finally {
            dataStore.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JournalRecordSet getJournalRecordset(String id) {
        DBRecordSet records;
        DBRecord record = new DBRecord();
        record.setString("serial_id", id);
        try {
            records = DBSql.getInstance(this.dbName).queryRecords(GET_JOURNAL_RECORDS + this.tbName, record);
        }
        finally {
            DataStoreMan.getInstance().getDataStore(this.dbName).close(true);
        }
        JournalRecordSet journalRecords = new JournalRecordSet();
        for (int i = 0; i < records.size(); ++i) {
            JournalRecord journalRecord = JournalHelper.convert(records.getRow(i));
            journalRecords.add(journalRecord);
        }
        return journalRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JournalRecord getJournalRecord(String id, int seq) {
        DBRecord record = new DBRecord();
        String eaiId = System.getProperty("eai_id");
        if (eaiId == null) {
            JournalArgumentException jae = new JournalArgumentException("null eai_id");
            jae.addScene("eai_id", eaiId);
            throw jae;
        }
        record.setString("eai_id", eaiId);
        record.setString("serial_id", id);
        record.setInt("service_sequence", seq);
        try {
            record = DBTable.getInstance(this.dbName).queryByPK(this.tbName, record);
        }
        finally {
            DataStoreMan.getInstance().getDataStore(this.dbName).close(true);
        }
        JournalRecord journalRecord = JournalHelper.convert(record);
        return journalRecord;
    }

    public void deleteJournalRecord(String id, int seq) {
        DBRecord record = new DBRecord();
        String eaiId = System.getProperty("eai_id");
        if (eaiId == null) {
            JournalArgumentException jae = new JournalArgumentException("null eai_id");
            jae.addScene("eai_id", eaiId);
            throw jae;
        }
        record.setString("eai_id", eaiId);
        record.setString("serial_id", id);
        record.setInt("service_sequence", seq);
        DataStore dataStore = DataStoreMan.getInstance().getDataStore(this.dbName);
        try {
            DBTable.getInstance(this.dbName).delete(this.tbName, record);
        }
        catch (DBException dbe) {
            throw dbe;
        }
        catch (Exception e) {
            throw new DBException("dbtable_delete_error", e);
        }
        finally {
            dataStore.close(true);
        }
    }
}

