/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.composite;

import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.ErrorAction;
import com.dc.eai.config.MapperConfig;
import com.dc.eai.config.ServiceStep;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.CompositeDataSet;
import com.dc.eai.dispatch.Context;
import com.dc.eai.flow.Action;
import com.dc.eai.flow.ActionContext;
import com.dc.eai.service.Service;
import com.dc.eai.service.ServiceConstants;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import com.dc.eai.service.composite.ActionContextImpl;
import com.dc.eai.util.CompositeDataHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ServiceAction
implements Action {
    private static Log log = LogFactory.getLog((Class)ServiceAction.class);
    private ServiceStep config = null;

    public ServiceAction(ServiceStep config) {
        this.config = config;
    }

    public boolean doAction(ActionContext context) {
        CompositeData actionOut;
        boolean flag = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u5f00\u59cb\u6267\u884c\u670d\u52a1\u8282\u70b9[" + this.config.getName() + "]"));
        }
        ActionContextImpl actionContext = (ActionContextImpl)context;
        CompositeDataSet dataSet = actionContext.getCompositeDataSet();
        CompositeData request = new CompositeData();
        ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getBeforeMapper());
        mapper.map(dataSet, request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7ec4\u5408\u670d\u52a1\u6267\u884c\u6d41\u7a0b-\u8bf7\u6c42\u6570\u636e[" + request));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u5408\u670d\u52a1\u6267\u884c\u6d41\u7a0b-\u7ed9dataset\u8bbe\u7f6e\u8bf7\u6c42\u4fe1\u606f");
        }
        this.addDataSet(dataSet, this.config.getName() + ServiceConstants.IN_DATA_SUFFIX, request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7ec4\u5408\u670d\u52a1\u6267\u884c\u6d41\u7a0b-\u5f00\u59cb\u6267\u884c\u670d\u52a1[" + this.config.getServiceName() + "]"));
        }
        ServiceResult result = this.executeService(request);
        CompositeData dataOut = result.getOutput();
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7ec4\u5408\u670d\u52a1\u6267\u884c\u6d41\u7a0b-\u670d\u52a1[" + this.config.getServiceName() + "]\u6267\u884c\u7ed3\u679c\uff1a" + dataOut));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u5408\u670d\u52a1\u6267\u884c\u6d41\u7a0b-\u7ed9dataset\u8bbe\u7f6e\u54cd\u5e94\u4fe1\u606f");
        }
        this.addDataSet(dataSet, this.config.getName() + ServiceConstants.OUT_DATA_SUFFIX, dataOut);
        if (result.status() == ServiceResultStatus.ERROR) {
            actionOut = this.mapping(dataSet, this.config.getErrorMapper());
        } else if (result.status() == ServiceResultStatus.SUCCESS) {
            actionOut = this.mapping(dataSet, this.config.getOutMapper());
        } else {
            throw (RuntimeException)result.exception();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7ec4\u5408\u670d\u52a1\u6267\u884c\u6d41\u7a0b-\u5bf9\u670d\u52a1\u6267\u884c\u7ed3\u679c\u8fdb\u884c\u6620\u5c04\uff0c\u6620\u5c04\u540e\u6570\u636e[" + actionOut));
        }
        CompositeData dest = new CompositeData();
        CompositeDataHelper.deepCopy(actionOut, dest);
        CompositeDataHelper.deepCopy(dataSet.getData(ServiceConstants.IN_DATA), dest);
        this.addDataSet(dataSet, ServiceConstants.IN_DATA, dest);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u670d\u52a1\u8282\u70b9[" + this.config.getName() + "] \u6267\u884c\u7ed3\u675f\uff01"));
        }
        if (!this.dealResult(result)) {
            return false;
        }
        return flag;
    }

    private boolean dealResult(ServiceResult result) {
        boolean flag = true;
        ServiceResultStatus srs = result.status();
        if (srs != ServiceResultStatus.SUCCESS) {
            ErrorAction errorAction;
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u53f6\u5b50\u8282\u70b9\u670d\u52a1[" + this.config.getName() + "]\u6267\u884c\u5931\u8d25\uff01"));
            }
            if ((errorAction = this.config.getFailureAction()) == ErrorAction.CONTINUE) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u7ee7\u7eed");
                }
                flag = true;
            } else {
                Context gContext = Context.getInstance();
                gContext.addProperty("CompositeService_ActionError", this.config.getFailureAction());
                flag = false;
            }
        }
        return flag;
    }

    private ServiceResult executeService(CompositeData request) {
        Service service = (Service)ComponentManagerGetter.getManager().getComponent(this.config.getServiceName());
        ServiceResult sr = service.execute(request);
        return sr;
    }

    private void addDataSet(CompositeDataSet dataSet, String name, CompositeData data) {
        dataSet.putData(name, data);
    }

    private CompositeData mapping(CompositeDataSet dataSet, MapperConfig mConfig) {
        ExpressionDataMapper mapper = new ExpressionDataMapper(mConfig);
        CompositeData data = new CompositeData();
        mapper.map(dataSet, data);
        return data;
    }

    public String getName() {
        return this.config.getName();
    }
}

