/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.composite;

import com.dc.eai.config.BranchStep;
import com.dc.eai.config.FlowStep;
import com.dc.eai.config.SequenceStep;
import com.dc.eai.config.ServiceStep;
import com.dc.eai.flow.Action;
import com.dc.eai.flow.BranchAction;
import com.dc.eai.flow.SequenceAction;
import com.dc.eai.service.composite.ExprCondition;
import com.dc.eai.service.composite.NullAction;
import com.dc.eai.service.composite.ServiceAction;
import com.dc.expr.Exp;

class CompositeServiceHelper {
    private static final Action nullAction = new NullAction();

    CompositeServiceHelper() {
    }

    public static Action convert(FlowStep step) {
        if (step == null) {
            return nullAction;
        }
        if (SequenceStep.class.isInstance(step)) {
            return CompositeServiceHelper.convert((SequenceStep)step);
        }
        if (BranchStep.class.isInstance(step)) {
            return CompositeServiceHelper.convert((BranchStep)step);
        }
        if (ServiceStep.class.isInstance(step)) {
            return CompositeServiceHelper.convert((ServiceStep)step);
        }
        return nullAction;
    }

    public static Action convert(BranchStep step) {
        if (step == null) {
            return nullAction;
        }
        BranchAction action = new BranchAction();
        Exp exp = step.getExpr();
        ExprCondition condition = new ExprCondition(exp);
        action.setConditon(condition);
        action.setTrueAction(CompositeServiceHelper.convert(step.getTrueStep()));
        action.setFalseAction(CompositeServiceHelper.convert(step.getFalseStep()));
        return action;
    }

    public static Action convert(SequenceStep step) {
        if (step == null) {
            return nullAction;
        }
        SequenceAction action = new SequenceAction();
        for (int i = 0; i < step.size(); ++i) {
            action.addAction(CompositeServiceHelper.convert(step.getStep(i)));
        }
        return action;
    }

    public static Action convert(ServiceStep step) {
        if (step == null) {
            return nullAction;
        }
        ServiceAction action = new ServiceAction(step);
        return action;
    }
}

