/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.composite;

import com.dc.eai.config.CompositeServiceConfig;
import com.dc.eai.config.MapperConfig;
import com.dc.eai.config.ServiceConfig;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.CompositeDataSet;
import com.dc.eai.flow.Action;
import com.dc.eai.service.Service;
import com.dc.eai.service.ServiceConstants;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import com.dc.eai.service.composite.ActionContextImpl;
import com.dc.eai.service.composite.CompositeServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeService
implements Service {
    private CompositeServiceConfig config = null;
    private Action action = null;
    private static Log log = LogFactory.getLog((Class)CompositeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResult execute(CompositeData data) {
        if (log.isInfoEnabled()) {
            log.info((Object)("\u5f00\u59cb\u6267\u884c\u7ec4\u5408\u670d\u52a1[" + this.config.getName() + "]"));
        }
        ServiceResult result = new ServiceResult();
        CompositeDataSet dataSet = new CompositeDataSet();
        dataSet.putData(ServiceConstants.IN_DATA, data);
        ActionContextImpl context = new ActionContextImpl();
        context.setCompositeDataSet(dataSet);
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)"\u7ec4\u5408\u670d\u52a1\u6267\u884c\u6d41\u7a0b");
            }
            boolean flag = this.action.doAction(context);
            MapperConfig map = null;
            ServiceResultStatus status = null;
            if (flag) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u7ec4\u5408\u670d\u52a1\u6267\u884c\u6210\u529f \u6267\u884c\u54cd\u5e94\u6620\u5c04");
                }
                map = this.config.getResponseMapper();
                status = ServiceResultStatus.SUCCESS;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u7ec4\u5408\u670d\u52a1\u6267\u884c\u8bf7\u6c42\u53d1\u9001\u540e\u5931\u8d25 \u6267\u884c\u5f02\u5e38\u6620\u5c04");
                }
                map = this.config.getErrorMapper();
                status = ServiceResultStatus.FAIL_AFTER_REQUEST;
            }
            ExpressionDataMapper mapper = new ExpressionDataMapper(map);
            CompositeData out = new CompositeData();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u7ec4\u5408\u670d\u52a1\u6620\u5c04");
            }
            mapper.map(dataSet, out);
            result.setOutput(out);
            result.setStatus(status);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u7ec4\u5408\u670d\u52a1\u6267\u884c\u540e\u7ed3\u679c\u4e3a[" + result + "]"));
            }
            ServiceResult serviceResult = result;
            return serviceResult;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("\u7ec4\u5408\u670d\u52a1[" + this.config.getName() + "]\u6267\u884c\u5f02\u5e38:"), (Throwable)e);
            }
            ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getSystemErrorMapper());
            CompositeData out = new CompositeData();
            mapper.map(dataSet, out);
            result.setOutput(out);
            result.setStatus(ServiceResultStatus.UNKNOWN);
            result.setException(e);
            ServiceResult serviceResult = result;
            return serviceResult;
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info((Object)("\u7ec4\u5408\u670d\u52a1" + this.config.getName() + "\u6267\u884c\u5b8c\u6bd5\uff0c\u7ed3\u679c\uff1a\n" + result));
            }
        }
    }

    public ServiceConfig getConfig() {
        return this.config;
    }

    public void setConfig(CompositeServiceConfig config) {
        this.action = CompositeServiceHelper.convert(config.getStep());
        this.config = config;
    }
}

