/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.service.atom;

import com.dc.eai.adapter.Adapter;
import com.dc.eai.adapter.AdapterCloseException;
import com.dc.eai.adapter.AdapterConnectException;
import com.dc.eai.adapter.AdapterInitException;
import com.dc.eai.adapter.AdapterReceiveDataException;
import com.dc.eai.adapter.AdapterSendDataException;
import com.dc.eai.adapter.AdapterTimeoutException;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.AtomServiceConfig;
import com.dc.eai.config.ServiceConfig;
import com.dc.eai.data.CompositeData;
import com.dc.eai.server.BaseService;
import com.dc.eai.server.ServerAdapter;
import com.dc.eai.service.Service;
import com.dc.eai.service.ServiceException;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtomService
implements Service {
    private AtomServiceConfig config = null;
    private static Log log = LogFactory.getLog((Class)AtomService.class);

    public AtomService() {
    }

    public AtomService(AtomServiceConfig config) {
        this.config = config;
    }

    public ServiceResult execute(CompositeData data) {
        ServiceResult tResult;
        ServerAdapter adapter;
        if (log.isInfoEnabled()) {
            log.info((Object)("\u539f\u5b50\u670d\u52a1[" + this.config.getName() + "]\u5f00\u59cb\u6267\u884c\uff1a"));
        }
        if ((adapter = this.getServerAdapter(tResult = new ServiceResult())) == null) {
            return tResult;
        }
        BaseService baseService = this.getBaseService(adapter, tResult);
        if (baseService == null) {
            return tResult;
        }
        Object pack = this.pack(baseService, data, tResult);
        if (pack == null) {
            return tResult;
        }
        Adapter commAdapter = this.getCommAdapter(adapter, tResult);
        if (commAdapter == null) {
            return tResult;
        }
        Object resultComm = this.doComm(commAdapter, pack, tResult);
        if (resultComm == null) {
            return tResult;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u6267\u884c\u670d\u52a1\u7ed3\u675f");
        }
        ServiceResult sr = this.unpack(baseService, resultComm);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u539f\u5b50\u670d\u52a1[" + this.config.getName() + "]\u6267\u884c\u5b8c\u6bd5\uff0c" + "\u670d\u52a1\u6267\u884c\u72b6\u6001[" + sr.status() + "]\n \u670d\u52a1\u6267\u884c\u8fd4\u56de\u6570\u636e\uff1a" + sr.getOutput()));
        }
        return sr;
    }

    private ServiceResult unpack(BaseService baseService, Object data) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u54cd\u5e94\u62a5\u6587\u62c6\u5305\u5f00\u59cb");
        }
        try {
            return baseService.unpack(data);
        }
        catch (Exception e) {
            ServiceResult result = new ServiceResult();
            if (log.isErrorEnabled()) {
                log.error((Object)"\u54cd\u5e94\u62a5\u6587\u62c6\u5305\u5f02\u5e38", (Throwable)e);
            }
            result.setStatus(ServiceResultStatus.FAIL_AFTER_REQUEST);
            result.setOutput(null);
            this.setException("after_request_unpack_exception", result);
            return result;
        }
    }

    private void setException(String errorCode, ServiceResult result) {
        if (result == null) {
            return;
        }
        ServiceException ex = new ServiceException(errorCode);
        result.setException(ex);
    }

    private Object doComm(Adapter commAdapter, Object data, ServiceResult result) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u901a\u8baf\u63a5\u51fa\u7ec4\u4ef6\u5f00\u59cb\u6267\u884c");
        }
        Object resultComm = null;
        try {
            resultComm = commAdapter.doComm(data);
        }
        catch (AdapterTimeoutException Te) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u901a\u8baf\u8fde\u63a5\u8d85\u65f6\u5f02\u5e38", (Throwable)Te);
            }
            result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
            this.setException("before_request_comm_exception", result);
            return resultComm;
        }
        catch (AdapterSendDataException Se) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u901a\u8baf\u63a5\u51fa\u53d1\u9001\u6570\u636e\u5f02\u5e38", (Throwable)Se);
            }
            result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
            this.setException("before_request_comm_exception", result);
            return resultComm;
        }
        catch (AdapterReceiveDataException Re) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u901a\u8baf\u63a5\u51fa\u63a5\u6536\u6570\u636e\u5f02\u5e38", (Throwable)Re);
            }
            result.setStatus(ServiceResultStatus.FAIL_AFTER_REQUEST);
            this.setException("after_request_comm_exception", result);
            return resultComm;
        }
        catch (AdapterInitException AIe) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u901a\u8baf\u63a5\u51fa\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)AIe);
            }
            result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
            this.setException("before_request_comm_exception", result);
            return resultComm;
        }
        catch (AdapterConnectException ACe) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u901a\u8baf\u63a5\u51fa\u8fde\u63a5\u5f02\u5e38", (Throwable)ACe);
            }
            result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
            this.setException("before_request_comm_exception", result);
            return resultComm;
        }
        catch (AdapterCloseException Ce) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u901a\u8baf\u63a5\u51fa\u5173\u95ed\u8fde\u63a5\u5f02\u5e38", (Throwable)Ce);
            }
            result.setStatus(ServiceResultStatus.FAIL_AFTER_REQUEST);
            this.setException("after_request_comm_exception", result);
            return resultComm;
        }
        catch (Exception re) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u901a\u8baf\u5931\u8d25\uff0c\u672a\u77e5\u5f02\u5e38", (Throwable)re);
            }
            result.setStatus(ServiceResultStatus.UNKNOWN);
            result.setOutput(null);
            this.setException("request_unknown_exception", result);
            return resultComm;
        }
        return resultComm;
    }

    private Adapter getCommAdapter(ServerAdapter sAdapter, ServiceResult result) {
        Adapter commAdapter;
        block5: {
            String adapterName = sAdapter.getConfig().getCommAdapter();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5f00\u59cb\u83b7\u53d6\u901a\u8baf\u63a5\u51fa\u7ec4\u4ef6[" + adapterName + "]"));
            }
            commAdapter = null;
            try {
                commAdapter = (Adapter)ComponentManagerGetter.getManager().getComponent(adapterName);
                if (commAdapter == null) {
                    result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                    this.setException("before_request_retrieve_comm_exception", result);
                    if (log.isErrorEnabled()) {
                        log.error((Object)("\u83b7\u53d6\u901a\u4fe1\u63a5\u51fa\u7ec4\u4ef6[" + adapterName + "]\u4e3anull\uff01"));
                    }
                }
            }
            catch (Exception e) {
                result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                this.setException("before_request_retrieve_comm_exception", result);
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"\u83b7\u53d6\u901a\u4fe1\u7ec4\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        return commAdapter;
    }

    private Object pack(BaseService baseService, CompositeData data, ServiceResult result) {
        Object pack;
        block6: {
            pack = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u670d\u52a1\u8bf7\u6c42\u6570\u636e\u6253\u5305\u5f00\u59cb");
                }
                pack = baseService.pack(data);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u670d\u52a1\u8bf7\u6c42\u6570\u636e\u6253\u5305\u7ed3\u675f");
                }
                if (pack == null) {
                    result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                    this.setException("before_request_pack_exception", result);
                    if (log.isErrorEnabled()) {
                        log.error((Object)"\u670d\u52a1\u8bf7\u6c42\u6570\u636e\u6253\u5305\u5f02\u5e38\uff01");
                    }
                }
            }
            catch (Exception e) {
                result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                this.setException("before_request_pack_exception", result);
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"\u670d\u52a1\u8bf7\u6c42\u6570\u636e\u6253\u5305\u5f02\u5e38", (Throwable)e);
            }
        }
        return pack;
    }

    private ServerAdapter getServerAdapter(ServiceResult result) {
        ServerAdapter adapter;
        block7: {
            adapter = null;
            String serverName = this.config.getServerName();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u5f00\u59cb\u83b7\u53d6\u670d\u52a1\u7cfb\u7edf\u7ec4\u4ef6[" + serverName + "]"));
                }
                if ((adapter = (ServerAdapter)ComponentManagerGetter.getManager().getComponent(serverName)) == null) {
                    result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                    this.setException("before_request_retrieve_server_exception", result);
                    if (log.isErrorEnabled()) {
                        log.error((Object)("\u83b7\u53d6[" + serverName + "]\u670d\u52a1\u7cfb\u7edf\u7ec4\u4ef6\u4e3anull\uff01"));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("\u670d\u52a1\u7cfb\u7edf\u7ec4\u4ef6[" + serverName + "]\u83b7\u53d6\u6210\u529f\uff01"));
                }
            }
            catch (Exception e) {
                result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                this.setException("before_request_retrieve_server_exception", result);
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"\u83b7\u53d6\u670d\u52a1\u7cfb\u7edf\u7ec4\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        return adapter;
    }

    private BaseService getBaseService(ServerAdapter adapter, ServiceResult result) {
        BaseService baseService;
        block7: {
            baseService = null;
            String bsvrName = this.config.getBaseServiceName();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u83b7\u53d6\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1[" + bsvrName + "]"));
                }
                if ((baseService = adapter.getBaseService(bsvrName)) == null) {
                    result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                    this.setException("before_request_retrieve_baseservice_exception", result);
                    if (log.isErrorEnabled()) {
                        log.error((Object)("\u83b7\u53d6\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u7ec4\u4ef6[" + bsvrName + "]\u4e3anull!"));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1[" + bsvrName + "]\u83b7\u53d6\u6210\u529f\uff01"));
                }
            }
            catch (Exception e) {
                result.setStatus(ServiceResultStatus.FAIL_BEFORE_REQUEST);
                this.setException("before_request_retrieve_baseservice_exception", result);
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"\u83b7\u53d6\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u7ec4\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        return baseService;
    }

    public ServiceConfig getConfig() {
        return this.config;
    }

    public void setConfig(AtomServiceConfig config) {
        this.config = config;
    }
}

