/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.server.traditional;

import com.dc.eai.channel.exception.TranDataConvertProcessException;
import com.dc.eai.config.BaseServiceConfig;
import com.dc.eai.config.PackageConfig;
import com.dc.eai.config.ServerConfig;
import com.dc.eai.conv.ExpressionDataMapper;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.server.BaseService;
import com.dc.eai.server.exception.IllegalResponseDataException;
import com.dc.eai.server.traditional.ServerSpecialProcess;
import com.dc.eai.server.traditional.TraditionalServerAdapter;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraditionalBaseService
implements BaseService {
    private static Log log = LogFactory.getLog((Class)TraditionalBaseService.class);
    private BaseServiceConfig config;
    private ServerConfig serverConfig;
    private ServerSpecialProcess specialProcess;
    private PackageConverter errConverter;
    private PackageConverter reqConverter;
    private PackageConverter respConverter;
    private TraditionalServerAdapter traditionalServerAdapter;

    public TraditionalBaseService(ServerSpecialProcess serverSpecialProcess, ServerConfig serverConfig) {
        this.specialProcess = serverSpecialProcess;
        this.serverConfig = serverConfig;
    }

    public ServiceResult unpack(Object data) {
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u62c6\u5305\u5f00\u59cb");
        }
        if (!(data instanceof byte[])) {
            if (log.isDebugEnabled()) {
                log.error((Object)"\u670d\u52a1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff01");
            }
            IllegalResponseDataException ce = new IllegalResponseDataException(data);
            ce.addScene("\u9700\u8981\u7684\u7c7b\u578b", "byte[]");
            ce.addScene("\u5b9e\u9645\u7c7b\u578b", data.getClass());
            throw ce;
        }
        byte[] respBytes = (byte[])data;
        InputPacket packet = new InputPacket(respBytes);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6536\u5230\u54cd\u5e94\u6570\u636e\u540e\u5904\u7406....");
        }
        this.specialProcess.afterRecvResponse(respBytes);
        CompositeData respData = new CompositeData();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62c6\u5305\u524d\u9884\u5904\u7406");
        }
        this.specialProcess.beforeUnpack(packet, respData);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u670d\u52a1\u6267\u884c\u662f\u5426\u6210\u529f\u5224\u65ad");
        }
        boolean b = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u670d\u52a1\u6267\u884c\u72b6\u6001\uff1a" + b));
        }
        ServiceResult result = new ServiceResult();
        if (b) {
            PackageConfig pc = this.config.getResponse();
            if (pc != null && pc.getIOConfig() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u62c6\u62a5\u6587\u4f53\u5f00\u59cb");
                }
                this.respConverter.unpack(packet, respData, pc.getIOConfig());
            }
        } else {
            PackageConfig pc = this.config.getError();
            if (pc != null && pc.getIOConfig() != null) {
                if (log.isDebugEnabled()) {
                    log.info((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u62c6\u9519\u8bef\u5305\u5f00\u59cb");
                }
                this.errConverter.unpack(packet, respData, pc.getIOConfig());
            }
            result.setStatus(ServiceResultStatus.ERROR);
            result.setOutput(respData);
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u62c6\u5305\u540e\u6570\u636e:" + respData));
            log.debug((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u5f00\u59cb\u6620\u5c04");
            log.debug((Object)"\u62a5\u6587\u4f53\u7684\u6620\u5c04\u5f00\u59cb");
            log.debug((Object)("\u62a5\u6587\u4f53\u7684\u6620\u5c04\u524d\u6570\u636e:" + respData));
        }
        try {
            ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getResponseMapper());
            mapper.map(respData, respData);
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("map_in", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bf7\u6c42\u6620\u5c04\u5931\u8d25", (Throwable)e);
            }
            throw de;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4f20\u7edf\u6e20\u9053\u8bf7\u6c42\u4ea4\u6613\u6620\u5c04\u540e\u7684\u6570\u636e:" + respData));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u62c6\u5305\u7ed3\u675f");
        }
        result.setOutput(respData);
        result.setStatus(ServiceResultStatus.SUCCESS);
        return result;
    }

    public Object pack(CompositeData data) {
        PackageConfig pc;
        OutputPacket packet = new OutputPacket();
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u7ec4\u5305\u5f00\u59cb ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7ec4\u5305\u524d\u7279\u6b8a\u5904\u7406\u524d  \u6570\u636e" + data));
        }
        this.specialProcess.beforePack(packet, data);
        CompositeData alludeData = new CompositeData();
        try {
            ExpressionDataMapper mapper = new ExpressionDataMapper(this.config.getRequestMapper());
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u7ec4\u5305\u524d\u6620\u5c04\u5904\u7406\uff0c\u6620\u5c04\u524d\u6570\u636e\uff1a\n" + data));
            }
            mapper.map(data, alludeData);
        }
        catch (Exception e) {
            TranDataConvertProcessException de = new TranDataConvertProcessException("map_out", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u54cd\u5e94\u6620\u5c04\u5931\u8d25", (Throwable)e);
            }
            throw de;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u7ec4\u5305\u524d\u6620\u5c04\u5904\u7406\uff0c\u6620\u5c04\u540e\u6570\u636e\uff1a\n" + alludeData));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u7ec4\u5305\u5934\u7ed3\u675f \u6570\u636e" + alludeData));
            log.debug((Object)"\u7ec4\u62a5\u6587\u4f53\u5f00\u59cb");
        }
        if ((pc = this.config.getRequest()) != null && pc.getIOConfig() != null) {
            this.reqConverter.pack(packet, alludeData, pc.getIOConfig());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u62a5\u6587\u4f53\u7ed3\u675f");
        }
        byte[] buff = new byte[packet.getOffset()];
        System.arraycopy(packet.getBuff(), 0, buff, 0, packet.getOffset());
        byte[] resultByte = this.specialProcess.beforeSendRequest(buff);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u7ec4\u5305\u540e\u6570\u636e" + new String(resultByte)));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"\u4f20\u7edf\u670d\u52a1\u7cfb\u7edf\u57fa\u7840\u670d\u52a1\u7ec4\u5305\u7ed3\u675f\u3002");
        }
        return resultByte;
    }

    public BaseServiceConfig getConfig() {
        return this.config;
    }

    public void setConfig(BaseServiceConfig config) {
        this.config = config;
        PackageModeFactory factory = PackageModeFactory.getFactory();
        this.errConverter = factory.getPackageMode(config.getError().getPackageMode());
        this.reqConverter = factory.getPackageMode(config.getRequest().getPackageMode());
        this.respConverter = factory.getPackageMode(config.getResponse().getPackageMode());
    }
}

