/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.server.selfstring;

import com.dc.eai.config.BaseServiceConfig;
import com.dc.eai.config.ServerConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.server.BaseService;
import com.dc.eai.server.exception.IllegalResponseDataException;
import com.dc.eai.server.selfstring.SelfEvidentStringServerAdapter;
import com.dc.eai.server.selfstring.ServerSpecialProcess;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfEvidentStringBaseService
implements BaseService {
    private BaseServiceConfig config;
    private ServerConfig serverConfig;
    private ServerSpecialProcess specialProcess;
    private SelfEvidentStringServerAdapter selfStringServerAdapter;
    private PackageConverter errConverter;
    private PackageConverter reqConverter;
    private PackageConverter respConverter;
    private static Log log = LogFactory.getLog((Class)SelfEvidentStringBaseService.class);

    public SelfEvidentStringBaseService(ServerSpecialProcess serverSpecialProcess, ServerConfig configtemp) {
        this.specialProcess = serverSpecialProcess;
        this.serverConfig = configtemp;
    }

    void initConv() {
        PackageModeFactory factory = PackageModeFactory.getFactory();
        if (this.errConverter == null) {
            this.errConverter = factory.getPackageMode(this.serverConfig.getDefaultErrorPackageMode());
        }
        if (this.reqConverter == null) {
            this.reqConverter = factory.getPackageMode(this.serverConfig.getDefaultRequestPackageMode());
        }
        if (this.respConverter == null) {
            this.respConverter = factory.getPackageMode(this.serverConfig.getDefaultResponsePackageMode());
        }
    }

    public Object pack(CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u81ea\u63cf\u8ff0\u5b57\u7b26\u670d\u52a1\u7cfb\u7edf\u7ec4\u5305\u5f00\u59cb\uff0c\u7ec4\u5305\u524d\u7edf\u4e00\u6570\u636e\u63a5\u53e3\u4e3a\uff1a\n" + data));
        }
        OutputPacket outPack = new OutputPacket();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u5305\u524d\u5904\u7406....");
        }
        this.specialProcess.beforePack(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u5305:");
        }
        this.reqConverter.pack(outPack, data, null);
        byte[] bytes = new byte[outPack.getOffset()];
        System.arraycopy(outPack.getBuff(), 0, bytes, 0, outPack.getOffset());
        String out = new String(bytes);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u8bf7\u6c42\u62a5\u6587\u53d1\u9001\u524d\u5904\u7406.");
        }
        String result = this.specialProcess.beforeSendRequest(out);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u81ea\u63cf\u8ff0\u5b57\u7b26\u670d\u52a1\u7cfb\u7edf\u7ec4\u5305\u7ed3\u675f\u3002\u62a5\u6587\u4e3a\uff1a\n" + result));
        }
        return result;
    }

    public ServiceResult unpack(Object data) {
        boolean success;
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u81ea\u63cf\u8ff0\u5b57\u7b26\u670d\u52a1\u7cfb\u7edf\u62c6\u5305\u5f00\u59cb....");
        }
        if (!(data instanceof String)) {
            if (log.isDebugEnabled()) {
                log.error((Object)"\u670d\u52a1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff01");
            }
            IllegalResponseDataException ce = new IllegalResponseDataException(data);
            ce.addScene("\u9700\u8981\u7684\u7c7b\u578b", "String");
            ce.addScene("\u5b9e\u9645\u7c7b\u578b", data.getClass());
            throw ce;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6536\u5230\u54cd\u5e94\u6570\u636e\u540e\u5904\u7406....");
        }
        String dataAfterProcess = this.specialProcess.afterRecvResponse((String)data);
        CompositeData cdata = new CompositeData();
        ServiceResult result = new ServiceResult();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62c6\u5305\u524d\u9884\u5904\u7406");
        }
        this.specialProcess.beforeUnpack(dataAfterProcess, cdata);
        InputPacket inpacket = new InputPacket(dataAfterProcess.trim().getBytes());
        this.respConverter.unpack(inpacket, cdata, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u670d\u52a1\u6267\u884c\u662f\u5426\u6210\u529f\u5224\u65ad");
        }
        if (success = this.specialProcess.isSuccess(dataAfterProcess, cdata)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u670d\u52a1\u6267\u884c\u6210\u529f\u540e\u62c6\u5305\uff1a");
            }
            result.setStatus(ServiceResultStatus.SUCCESS);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u670d\u52a1\u6267\u884c\u5931\u8d25\u540e\u62c6\u5305\uff1a");
            }
            result.setStatus(ServiceResultStatus.ERROR);
        }
        result.setOutput(cdata);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u81ea\u63cf\u8ff0\u5b57\u7b26\u670d\u52a1\u7cfb\u7edf\u62c6\u5305\u7ed3\u675f....");
        }
        return result;
    }

    public BaseServiceConfig getConfig() {
        return this.config;
    }

    public void setConfig(BaseServiceConfig config) {
        this.config = config;
    }
}

