/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.server.selfbyte;

import com.dc.eai.config.BaseServiceConfig;
import com.dc.eai.config.ServerConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.data.CompositeData;
import com.dc.eai.server.BaseService;
import com.dc.eai.server.exception.IllegalResponseDataException;
import com.dc.eai.server.exception.NoConverterException;
import com.dc.eai.server.selfbyte.SelfEvidentByteServerAdapter;
import com.dc.eai.server.selfbyte.ServerSpecialProcess;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfEvidentByteBaseService
implements BaseService {
    private static Log log = LogFactory.getLog((Class)SelfEvidentByteServerAdapter.class);
    private BaseServiceConfig config;
    private PackageConverter errConverter;
    private PackageConverter reqConverter;
    private PackageConverter respConverter;
    private ServerConfig serverConfig;
    private ServerSpecialProcess specialProcess;
    private SelfEvidentByteServerAdapter selfByteServerAdapter;

    public SelfEvidentByteBaseService(ServerSpecialProcess serverSpecialProcess, ServerConfig configTemp) {
        this.specialProcess = serverSpecialProcess;
        this.serverConfig = configTemp;
        this.initConv();
    }

    void initConv() {
        PackageModeFactory factory = PackageModeFactory.getFactory();
        if (this.errConverter == null) {
            this.errConverter = factory.getPackageMode(this.serverConfig.getDefaultErrorPackageMode());
            if (this.errConverter == null) {
                NoConverterException ce = new NoConverterException("no_converter_exception");
                throw ce;
            }
        }
        if (this.reqConverter == null) {
            this.reqConverter = factory.getPackageMode(this.serverConfig.getDefaultRequestPackageMode());
            if (this.errConverter == null) {
                NoConverterException ce = new NoConverterException("no_converter_exception");
                throw ce;
            }
        }
        if (this.respConverter == null) {
            this.respConverter = factory.getPackageMode(this.serverConfig.getDefaultResponsePackageMode());
            if (this.errConverter == null) {
                NoConverterException ce = new NoConverterException("no_converter_exception");
                throw ce;
            }
        }
    }

    public Object pack(CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u81ea\u63cf\u8ff0\u5b57\u8282\u670d\u52a1\u7cfb\u7edf\u7ec4\u5305\u5f00\u59cb,\u7ec4\u5305\u524d\u6570\u636e\u4e3a\uff1a\n" + data));
        }
        OutputPacket outPack = new OutputPacket();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u5305\u524d\u5904\u7406....");
        }
        this.specialProcess.beforePack(outPack, data);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u5305..");
        }
        this.reqConverter.pack(outPack, data, null);
        byte[] out = new byte[outPack.getOffset()];
        System.arraycopy(outPack.getBuff(), 0, out, 0, outPack.getOffset());
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u8bf7\u6c42\u62a5\u6587\u53d1\u9001\u524d\u5904\u7406.");
        }
        byte[] result = this.specialProcess.beforeSendRequest(out);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u81ea\u63cf\u8ff0\u5b57\u8282\u670d\u52a1\u7cfb\u7edf\u7ec4\u5305\u7ed3\u675f\uff0c\u62a5\u6587\u4e3a\uff1a\n" + new String(result)));
        }
        return result;
    }

    public ServiceResult unpack(Object data) {
        ServiceResult result = new ServiceResult();
        if (log.isInfoEnabled()) {
            log.debug((Object)"\u81ea\u63cf\u8ff0\u5b57\u8282\u670d\u52a1\u7cfb\u7edf\u62c6\u5305\u5f00\u59cb....");
        }
        if (!(data instanceof byte[])) {
            if (log.isDebugEnabled()) {
                log.error((Object)"\u670d\u52a1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff01");
            }
            IllegalResponseDataException ce = new IllegalResponseDataException(data);
            ce.addScene("\u9700\u8981\u7684\u7c7b\u578b", "byte[]");
            ce.addScene("\u5b9e\u9645\u7c7b\u578b", data.getClass());
            throw ce;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6536\u5230\u54cd\u5e94\u6570\u636e\u540e\u5904\u7406....");
        }
        byte[] bytesData = this.specialProcess.afterRecvResponse((byte[])data);
        InputPacket inPack = new InputPacket(bytesData);
        CompositeData cdata = new CompositeData();
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u62c6\u5305\u524d\u9884\u5904\u7406");
        }
        this.specialProcess.beforeUnpack(inPack, cdata);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u670d\u52a1\u6267\u884c\u662f\u5426\u6210\u529f\u5224\u65ad");
        }
        this.respConverter.unpack(inPack, cdata, null);
        boolean success = this.specialProcess.isSuccess(bytesData, cdata);
        if (success) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u670d\u52a1\u6267\u884c\u6210\u529f\u540e\u62c6\u5305");
            }
            result.setStatus(ServiceResultStatus.SUCCESS);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u670d\u52a1\u6267\u884c\u5931\u8d25\u540e\u62c6\u5305");
            }
            result.setStatus(ServiceResultStatus.ERROR);
        }
        result.setOutput(cdata);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u81ea\u63cf\u8ff0\u5b57\u8282\u670d\u52a1\u7cfb\u7edf\u62c6\u5305\u7ed3\u675f....  ");
        }
        return result;
    }

    public void setConfig(BaseServiceConfig config) {
        this.config = config;
    }
}

