/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security.securityManage;

import com.dc.datastore.DataStoreMan;
import com.dc.db.DBRecord;
import com.dc.db.DBSql;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.security.KeyStoreFactory;
import com.dc.eai.security.Normalsecurity;
import com.dc.eai.security.keystore.DESKey;
import com.dc.eai.security.securityManage.SecuritySendNode;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecuritySendKey
extends Normalsecurity {
    private static Log log = LogFactory.getLog((Class)SecuritySendNode.class);
    private String errormsg = "";

    public ServiceResult execute(CompositeData data) {
        String key;
        String encryptMode;
        String keyType;
        String nodeID;
        Field fld;
        CompositeData cd;
        ServiceResult sr;
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u6269\u5c55\u670d\u52a1->\u5206\u53d1\u5bc6\u94a5<-\u5f00\u59cb\u6267\u884c");
            }
            sr = new ServiceResult();
            cd = new CompositeData();
            fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 48));
            fld.setValue("\u53d1\u9001\u5bc6\u94a5");
            nodeID = (String)data.getField("nodeid").getValue();
            keyType = (String)data.getField("keytype").getValue();
            encryptMode = (String)data.getField("encryptmode").getValue();
            if (!KeyStoreFactory.getorg2node().containsValue(nodeID)) {
                sr.setStatus(ServiceResultStatus.ERROR);
                fld.setValue("z\u8be5\u8282\u70b9\u4fe1\u606f\u4e0d\u5b58\u5728");
                cd.addField("errormsg", fld);
                sr.setOutput(cd);
                return sr;
            }
            System.setProperty("key", nodeID);
            fld.setValue(keyType);
            cd.addField("keytype", fld);
            DESKey dk = new DESKey();
            key = null;
            try {
                key = dk.creatDES();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)("\u751f\u6210\u5bc6\u94a5\u5931\u8d25" + e.getMessage()));
            }
        }
        String key2send = this.key2send(keyType, key, encryptMode, nodeID);
        if (key2send.equalsIgnoreCase("")) {
            sr.setStatus(ServiceResultStatus.ERROR);
            fld.setValue("z" + this.errormsg);
            cd.addField("errormsg", fld);
            sr.setOutput(cd);
            return sr;
        }
        String saveResult = this.saveKey(keyType, key, nodeID);
        if (!saveResult.equalsIgnoreCase("")) {
            sr.setStatus(ServiceResultStatus.ERROR);
            fld.setValue("z" + saveResult);
            cd.addField("errormsg", fld);
            sr.setOutput(cd);
            return sr;
        }
        fld.setValue(key2send);
        cd.addField("trankey", fld);
        sr.setOutput(cd);
        sr.setStatus(ServiceResultStatus.SUCCESS);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveKey(String keytype, String key, String nodeID) {
        DBSql dbsql = DBSql.getInstance("local");
        try {
            Object result2;
            Date currentDate = Calendar.getInstance().getTime();
            String formatDate = this.doFormatDate(currentDate, true);
            String decKeytype = "";
            String encKey = "";
            String mK = "";
            String bK = "";
            String encryptedKey = "";
            decKeytype = "0";
            DBRecord dbr = new DBRecord();
            dbr.setString("Keytype", decKeytype);
            dbr.setString("Keysign", "0");
            DBRecord result = dbsql.query("getKeylocal", dbr);
            String tmpKey = result.getString("key");
            try {
                mK = DESKey.desDecrypt(tmpKey, "1231231212abc324");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                String string = "\u4e2d\u5fc3\u8282\u70b9\u89e3\u5bc6\u4e3b\u5bc6\u94a5\u5931\u8d25";
                DataStoreMan.getInstance().getDataStore("local").close(true);
                return string;
            }
            if (keytype.equalsIgnoreCase("1")) {
                encKey = mK;
            } else {
                DBRecord dbr2 = new DBRecord();
                dbr2.setString("Keytype", "1");
                dbr2.setString("Keysign", "0");
                dbr2.setString("NodeID", nodeID);
                System.out.println(dbr2.toString());
                result2 = dbsql.query("getKey", dbr2);
                String tmpbK = ((DBRecord)result2).getString("key");
                try {
                    bK = DESKey.desDecrypt(tmpbK, mK);
                }
                catch (Exception e) {
                    String string = "\u4e2d\u5fc3\u8282\u70b9\u89e3\u5bc6\u4e3b\u5bc6\u94a5\u5931\u8d25";
                    DataStoreMan.getInstance().getDataStore("local").close(true);
                    return string;
                }
                encKey = bK;
            }
            try {
                encryptedKey = DESKey.desEncrypt(key, encKey);
            }
            catch (Exception e) {
                result2 = "\u4e2d\u5fc3\u8282\u70b9\u52a0\u5bc6\u7533\u8bf7\u7684\u5bc6\u94a5\u5931\u8d25";
                DataStoreMan.getInstance().getDataStore("local").close(true);
                return result2;
            }
            String delFlag = "";
            DBRecord dbr3 = new DBRecord();
            if (keytype.equalsIgnoreCase("1")) {
                delFlag = "0";
                dbr3 = new DBRecord();
                dbr3.setString("NodeID", nodeID);
                dbr3.setString("Keytype", delFlag);
                dbr3.setString("KeySign", "1");
                dbsql.execute("deleteOldBK", dbr3);
                dbr3 = new DBRecord();
                dbr3.setString("NodeID", nodeID);
                dbr3.setString("Keytype", delFlag);
                dbr3.setString("KeySign", "1");
                dbr3.setString("KeySign_old", "0");
                dbr3.setString("ModifyDate", formatDate);
                dbsql.execute("alterBKInfo", dbr3);
            } else {
                dbr3 = new DBRecord();
                dbr3.setString("NodeID", nodeID);
                dbr3.setString("Keytype", keytype);
                dbr3.setString("KeySign", "1");
                dbsql.execute("deleteOldWK", dbr3);
                dbr3 = new DBRecord();
                dbr3.setString("NodeID", nodeID);
                dbr3.setString("Keytype", keytype);
                dbr3.setString("KeySign", "1");
                dbr3.setString("KeySign_old", "0");
                dbr3.setString("ModifyDate", formatDate);
                dbsql.execute("alterKeyInfo", dbr3);
            }
            dbr3 = new DBRecord();
            dbr3.setString("NodeID", nodeID);
            dbr3.setString("Keytype", keytype);
            dbr3.setString("KeySign", "0");
            dbr3.setString("Key", encryptedKey);
            dbr3.setString("CreateDate", formatDate);
            dbsql.execute("saveKey", dbr3);
            KeyStoreFactory.setKeyUpdated(true);
            String string = "";
            return string;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String key2send(String keytype, String key, String encryptMode, String nodeID) {
        DBSql dbsql = DBSql.getInstance("local");
        try {
            String key2key = "";
            String key2send = "";
            String mK = "";
            if (encryptMode.equalsIgnoreCase("0")) {
                for (int i = 0; i < key.length(); ++i) {
                    key2key = key2key + "0";
                }
            } else {
                DBRecord dbr = new DBRecord();
                dbr.setString("NodeID", nodeID);
                dbr.setString("Keytype", "1");
                dbr.setString("Keysign", "0");
                DBRecord result = dbsql.query("getKey", dbr);
                if (result == null) {
                    this.errormsg = "\u4e2d\u5fc3\u8282\u70b9\u83b7\u53d6\u57fa\u672c\u5bc6\u94a5\u5931\u8d25";
                    String string = "";
                    return string;
                }
                key2key = result.getString("key");
                dbr = new DBRecord();
                dbr.setString("Keytype", "0");
                dbr.setString("Keysign", "0");
                DBRecord result2 = dbsql.query("getKeylocal", dbr);
                if (result == null) {
                    this.errormsg = "\u4e2d\u5fc3\u8282\u70b9\u83b7\u53d6\u4e3b\u5bc6\u94a5\u5931\u8d25";
                    String string = "";
                    return string;
                }
                String tmpMK = result2.getString("key");
                try {
                    mK = DESKey.desDecrypt(tmpMK, "1231231212abc324");
                    key2key = DESKey.desDecrypt(key2key, mK);
                }
                catch (Exception e) {
                    this.errormsg = "\u4e2d\u5fc3\u8282\u70b9\u89e3\u5bc6\u4e3b\u5bc6\u94a5\u6216\u57fa\u672c\u5bc6\u94a5\u5931\u8d25";
                    String string = "";
                    DataStoreMan.getInstance().getDataStore("local").close(true);
                    return string;
                }
            }
            try {
                key2send = DESKey.desEncrypt(key, key2key);
            }
            catch (Exception e) {
                this.errormsg = "\u4e2d\u5fc3\u8282\u70b9\u4f7f\u7528\u57fa\u672c\u5bc6\u94a5\u52a0\u5bc6\u8bf7\u6c42\u5bc6\u94a5\u5931\u8d25";
                String string = "";
                DataStoreMan.getInstance().getDataStore("local").close(true);
                return string;
            }
            String string = key2send;
            return string;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    public String doFormatDate(Date dtIn, boolean bShowTimePartIn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dtIn);
    }
}

