/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security.securityManage;

import com.dc.datastore.DataStoreMan;
import com.dc.db.DBRecord;
import com.dc.db.DBSql;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.security.KeyStoreFactory;
import com.dc.eai.security.Normalsecurity;
import com.dc.eai.security.securityManage.SecuritySaveNode;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecuritySaveNodeCentral
extends Normalsecurity {
    private static Log log = LogFactory.getLog((Class)SecuritySaveNode.class);

    public ServiceResult execute(CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6269\u5c55\u670d\u52a1->\u4e2d\u5fc3\u8282\u70b9\u4fdd\u5b58\u8282\u70b9\u4fe1\u606f<-\u5f00\u59cb\u6267\u884c");
        }
        ServiceResult sr = new ServiceResult();
        CompositeData cd = new CompositeData();
        Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 9));
        String orgID = (String)data.getField("orgid").getValue();
        String nodeip = data.getField("nodeip").strValue();
        String nodeid = "";
        String maxNodeID = this.getMaxNodeID();
        String newNodeID = String.valueOf(Integer.parseInt(maxNodeID) + 1);
        for (int i = newNodeID.length(); i < 4; ++i) {
            newNodeID = "0" + newNodeID;
        }
        String nodeattr = data.getField("nodeattr").strValue();
        if (nodeattr.equalsIgnoreCase("1") && this.isCentralExist()) {
            Field fld2 = new Field(new FieldAttr(FieldType.FIELD_STRING, 16));
            fld2.setValue("\u4e2d\u5fc3\u8282\u70b9\u5df2\u7ecf\u5b58\u5728\uff01");
            cd.addField("keymsg", fld2);
            fld.setValue("         ");
            cd.addField("nodeid", fld);
            sr.setOutput(cd);
            sr.setStatus(ServiceResultStatus.SUCCESS);
            return sr;
        }
        if (this.isExist(orgID)) {
            Field fld2 = new Field(new FieldAttr(FieldType.FIELD_STRING, 16));
            fld2.setValue("\u8be5\u673a\u6784\u7684\u8282\u70b9\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728");
            cd.addField("keymsg", fld2);
            fld.setValue("         ");
            cd.addField("nodeid", fld);
        } else if (this.isIPExist(nodeip)) {
            Field fld2 = new Field(new FieldAttr(FieldType.FIELD_STRING, 16));
            fld2.setValue("\u8be5IP\u5df2\u7ecf\u5b58\u5728");
            cd.addField("keymsg", fld2);
            fld.setValue("         ");
            cd.addField("nodeid", fld);
        } else {
            nodeid = this.saveNodeINfo(data, newNodeID);
            fld.setValue(nodeid);
            cd.addField("nodeid", fld);
            Field fld2 = new Field(new FieldAttr(FieldType.FIELD_STRING, 16));
            fld2.setValue("\u751f\u6210\u8282\u70b9\u7f16\u53f7\u4e3a:");
            cd.addField("keymsg", fld2);
            this.alterMaxNodeID(newNodeID);
        }
        sr.setOutput(cd);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6269\u5c55\u670d\u52a1->\u6570\u636e\u5305\u53d1\u9001<-\u5f00\u59cb\u6267\u884c");
        }
        sr.setStatus(ServiceResultStatus.SUCCESS);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExist(String orgID) {
        try {
            DBRecord dbr = new DBRecord();
            dbr.setString("OrgID", orgID);
            dbr.setString("status", "0");
            DBRecord rec = DBSql.getInstance("local").query("getNodeinfo", dbr);
            boolean bl = rec != null;
            return bl;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCentralExist() {
        try {
            DBRecord dbr = new DBRecord();
            dbr.setString("nodeattr", "1");
            dbr.setString("status", "0");
            DBRecord rec = DBSql.getInstance("local").query("getCentralNodeinfo", dbr);
            boolean bl = rec != null;
            return bl;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMaxNodeID() {
        try {
            String maxNodeID;
            DBRecord dbr = new DBRecord();
            dbr.setString("ParaType", "maxNodeID");
            DBRecord rec = DBSql.getInstance("local").query("getMaxNodeID", dbr);
            String string = maxNodeID = rec.getString("ParaValue");
            return string;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveNodeINfo(CompositeData data, String maxNodeID) {
        DBSql dbsql = DBSql.getInstance("local");
        try {
            Date currentDate = Calendar.getInstance().getTime();
            String formatDate = this.doFormatDate(currentDate, true);
            String jgbh = data.getField("orgid").strValue();
            String nodeip = data.getField("nodeip").strValue();
            String nodeattr = data.getField("nodeattr").strValue();
            String nodemark = data.getField("nodemark").strValue();
            DBRecord dbr = new DBRecord();
            dbr.setString("orgid", jgbh);
            dbr.setString("status", "1");
            dbsql.execute("deleteOldNode", dbr);
            String nodeID = jgbh + maxNodeID + nodeattr;
            dbr = new DBRecord();
            dbr.setString("NodeID", nodeID);
            dbr.setString("OrgID", jgbh);
            dbr.setString("NodeIP", nodeip);
            dbr.setString("NodeAttr", nodeattr);
            dbr.setString("Remark", nodemark);
            dbr.setString("status", "0");
            dbr.setString("CreateDate", formatDate);
            dbsql.execute("saveNodeInfo", dbr);
            if (nodeattr.equalsIgnoreCase("1")) {
                dbr = new DBRecord();
                dbr.setString("ParaType", "localNodeId");
                dbr.setString("ParaValue", nodeID);
                dbsql.execute("saveLocalNodeInfo", dbr);
            }
            KeyStoreFactory.setNodeUpdated(true);
            String string = nodeID;
            return string;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIPExist(String ip) {
        try {
            DBRecord dbr = new DBRecord();
            dbr.setString("nodeip", ip);
            dbr.setString("status", "0");
            DBRecord rec = DBSql.getInstance("local").query("getNodeinfobyIP", dbr);
            boolean bl = rec != null;
            return bl;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterMaxNodeID(String maxNodeID) {
        try {
            DBRecord dbr = new DBRecord();
            dbr.setString("ParaType", "maxNodeID");
            dbr.setString("ParaValue", maxNodeID);
            DBSql.getInstance("local").execute("alterMaxNodeID", dbr);
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    private String doFormatDate(Date dtIn, boolean bShowTimePartIn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dtIn);
    }
}

