/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security.securityManage;

import com.dc.datastore.DataStoreMan;
import com.dc.db.DBRecord;
import com.dc.db.DBSql;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.security.KeyStoreFactory;
import com.dc.eai.security.Normalsecurity;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecuritySaveNode
extends Normalsecurity {
    private static Log log = LogFactory.getLog((Class)SecuritySaveNode.class);

    public ServiceResult execute(CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6269\u5c55\u670d\u52a1->\u4e0b\u7ea7\u8282\u70b9\u4fdd\u5b58\u8282\u70b9\u4fe1\u606f<-\u5f00\u59cb\u6267\u884c");
        }
        ServiceResult sr = new ServiceResult();
        CompositeData cd = new CompositeData();
        Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 9));
        String orgID = (String)data.getField("orgid").getValue();
        String nodeid = "";
        if (this.isExist(orgID)) {
            this.deleteNode();
        }
        nodeid = this.saveNodeINfo(data);
        fld.setValue(nodeid);
        cd.addField("nodeid", fld);
        Field fld2 = new Field(new FieldAttr(FieldType.FIELD_STRING, 16));
        fld2.setValue("\u8282\u70b9\u5df2\u6210\u529f\u4fdd\u5b58\u8282\u70b9\u4fe1\u606f:" + nodeid);
        cd.addField("keymsg", fld2);
        sr.setOutput(cd);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6269\u5c55\u670d\u52a1->\u6570\u636e\u5305\u53d1\u9001<-\u5f00\u59cb\u6267\u884c");
        }
        sr.setStatus(ServiceResultStatus.SUCCESS);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNode() {
        try {
            DBRecord dbr = new DBRecord();
            DBSql.getInstance("local").execute("deletebranchNodeinfo", dbr);
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExist(String orgID) {
        try {
            DBRecord dbr = new DBRecord();
            DBRecord rec = DBSql.getInstance("local").query("getlocalNodeinfo", dbr);
            boolean bl = rec != null;
            return bl;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveNodeINfo(CompositeData data) {
        DBSql dbsql = DBSql.getInstance("local");
        try {
            Date currentDate = Calendar.getInstance().getTime();
            String formatDate = this.doFormatDate(currentDate, true);
            String nodeID = data.getField("nodeid").strValue();
            String jgbh = data.getField("orgid").strValue();
            String nodeip = data.getField("nodeip").strValue();
            String nodeattr = data.getField("nodeattr").strValue();
            String nodemark = data.getField("nodemark").strValue();
            DBRecord dbr = new DBRecord();
            dbr.setString("NodeID", nodeID);
            dbr.setString("OrgID", jgbh);
            dbr.setString("NodeIP", nodeip);
            dbr.setString("NodeAttr", nodeattr);
            dbr.setString("Remark", nodemark);
            dbr.setString("status", "0");
            dbr.setString("CreateDate", formatDate);
            dbsql.execute("saveNodeInfo", dbr);
            dbr = new DBRecord();
            dbr.setString("ParaType", "localNodeId");
            dbr.setString("ParaValue", nodeID);
            dbsql.execute("saveLocalNodeInfo", dbr);
            KeyStoreFactory.setSysUpdated(true);
            String string = nodeID;
            return string;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    public String doFormatDate(Date dtIn, boolean bShowTimePartIn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dtIn);
    }
}

