/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security.securityManage;

import com.dc.datastore.DataStoreMan;
import com.dc.db.DBRecord;
import com.dc.db.DBRecordSet;
import com.dc.db.DBSql;
import com.dc.eai.adapter.Adapter;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.security.KeyStoreFactory;
import com.dc.eai.security.Normalsecurity;
import com.dc.eai.security.keystore.DESKey;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecurityRequestKey
extends Normalsecurity {
    private static Log log = LogFactory.getLog((Class)SecurityRequestKey.class);
    private String errMsg = "";

    public ServiceResult execute(CompositeData arg0) {
        ServiceResult sr = new ServiceResult();
        CompositeData cd = new CompositeData();
        String keyType = arg0.getField("keytype").strValue();
        if (!this.verifyStatus(keyType)) {
            Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 32));
            fld.setValue(this.errMsg);
            cd.addField("errormsg", fld);
            sr.setOutput(cd);
            sr.setStatus(ServiceResultStatus.ERROR);
            return sr;
        }
        String encryptMode = arg0.getField("encryptmode").strValue();
        String nodeID = this.getlocalNodeID();
        String msg = this.packSendMeg(nodeID, keyType, encryptMode);
        Adapter adapter = (Adapter)ComponentManagerGetter.getManager().getComponent("security-tcp-adapter");
        String resultStr = "";
        try {
            byte[] result = (byte[])adapter.doComm(msg.getBytes());
            resultStr = new String(result);
        }
        catch (Exception e) {
            Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 32));
            fld.setValue("\u540c\u4e2d\u5fc3\u8282\u70b9\u901a\u8baf\u5f02\u5e38");
            cd.addField("errormsg", fld);
            sr.setOutput(cd);
            sr.setStatus(ServiceResultStatus.ERROR);
            return sr;
        }
        if (resultStr.startsWith("z")) {
            Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 32));
            fld.setValue(resultStr.substring(1));
            cd.addField("errormsg", fld);
            sr.setOutput(cd);
            sr.setStatus(ServiceResultStatus.ERROR);
            return sr;
        }
        String key = resultStr.substring(1, 49);
        String resultSave = this.saveKey(keyType, key, encryptMode, nodeID);
        if (resultSave.startsWith("0")) {
            Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 32));
            fld.setValue(resultSave.substring(1));
            cd.addField("errormsg", fld);
            sr.setOutput(cd);
            sr.setStatus(ServiceResultStatus.ERROR);
            return sr;
        }
        Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 32));
        fld.setValue(resultSave);
        cd.addField("keymsg", fld);
        sr.setOutput(cd);
        if (cd.getField("status") == null) {
            sr.setStatus(ServiceResultStatus.SUCCESS);
            return sr;
        }
        if ("1".equalsIgnoreCase(cd.getField("status").strValue())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8bbe\u7f6e\u670d\u52a1\u6267\u884c\u72b6\u6001\u4e3aerror");
            }
            sr.setStatus(ServiceResultStatus.ERROR);
        } else {
            sr.setStatus(ServiceResultStatus.SUCCESS);
        }
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getlocalNodeID() {
        try {
            DBRecord dbr = new DBRecord();
            dbr.setString("ParaType", "localNodeId");
            DBRecord rec = DBSql.getInstance("local").query("getlocalNodetype", dbr);
            if (rec != null) {
                String temp = rec.getString("ParaValue");
                String string = temp.substring(0, 9);
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    private String packSendMeg(String nodeID, String keyType, String encryptMode) {
        return "Security30Security30" + nodeID + keyType + encryptMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveKey(String keytype, String key, String encryptMode, String localNodeID) {
        DBSql dbsql = DBSql.getInstance("local");
        try {
            String mK = "";
            String decKey = "";
            String bK = "";
            String encryptedKey = "";
            DBRecord dbr = new DBRecord();
            dbr.setString("Keytype", "0");
            dbr.setString("Keysign", "0");
            DBRecord result = dbsql.query("getKeylocal", dbr);
            if (result == null) {
                String string = "0\u83b7\u53d6\u4e3b\u5bc6\u94a5\u5931\u8d25";
                return string;
            }
            String tmpKey = result.getString("key");
            try {
                mK = DESKey.desDecrypt(tmpKey, "1231231212abc324");
            }
            catch (Exception e) {
                String string = "0\u89e3\u5bc6\u4e3b\u5bc6\u94a5\u5931\u8d25";
                DataStoreMan.getInstance().getDataStore("local").close(true);
                return string;
            }
            if (keytype.equalsIgnoreCase("1")) {
                if (encryptMode.equalsIgnoreCase("0")) {
                    for (int i = 0; i < key.length(); ++i) {
                        decKey = decKey + "0";
                    }
                } else {
                    dbr = new DBRecord();
                    dbr.setString("Keytype", "1");
                    dbr.setString("Keysign", "0");
                    result = dbsql.query("getKeylocal", dbr);
                    if (result == null) {
                        String i = "0\u65e0\u6cd5\u83b7\u5f97\u76f8\u5e94\u89e3\u5bc6\u57fa\u672c\u5bc6\u94a5";
                        return i;
                    }
                    decKey = result.getString("key");
                    try {
                        decKey = bK = DESKey.desDecrypt(decKey, mK);
                    }
                    catch (Exception e) {
                        String string = "0\u89e3\u5bc6\u57fa\u672c\u5bc6\u94a5\u5931\u8d25";
                        DataStoreMan.getInstance().getDataStore("local").close(true);
                        return string;
                    }
                }
                try {
                    String basekey = DESKey.desDecrypt(key, decKey);
                    encryptedKey = DESKey.desEncrypt(basekey, mK);
                }
                catch (Exception e) {
                    String string = "0\u52a0\u89e3\u5bc6\u5bc6\u94a5\u5931\u8d25";
                    DataStoreMan.getInstance().getDataStore("local").close(true);
                    return string;
                }
                this.deleteBK(localNodeID, dbsql);
            } else {
                encryptedKey = key;
                this.deleteWK(localNodeID, keytype, dbsql);
            }
            Date currentDate = Calendar.getInstance().getTime();
            String formatDate = this.doFormatDate(currentDate, true);
            DBRecord dbr3 = new DBRecord();
            dbr3.setString("NodeID", localNodeID);
            dbr3.setString("Keytype", keytype);
            dbr3.setString("KeySign", "0");
            dbr3.setString("CreateDate", formatDate);
            dbr3.setString("Key", encryptedKey);
            dbsql.execute("saveKey", dbr3);
            KeyStoreFactory.setKeyUpdated(true);
            String string = "\u7533\u8bf7\u5bc6\u94a5\u5e76\u5b58\u50a8\u6210\u529f";
            return string;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    private void deleteBK(String localNodeID, DBSql dbsql) {
        Date currentDate = Calendar.getInstance().getTime();
        String formatDate = this.doFormatDate(currentDate, true);
        DBRecord dbr3 = new DBRecord();
        dbr3.setString("NodeID", localNodeID);
        dbr3.setString("Keytype", "0");
        dbr3.setString("KeySign", "1");
        dbsql.execute("deleteOldBK", dbr3);
        dbr3.setString("NodeID", localNodeID);
        dbr3.setString("Keytype", "0");
        dbr3.setString("KeySign", "1");
        dbr3.setString("KeySign_old", "0");
        dbr3.setString("ModifyDate", formatDate);
        dbsql.execute("alterBKInfo", dbr3);
    }

    private void deleteWK(String localNodeID, String keytype, DBSql dbsql) {
        Date currentDate = Calendar.getInstance().getTime();
        String formatDate = this.doFormatDate(currentDate, true);
        DBRecord dbr3 = new DBRecord();
        dbr3.setString("NodeID", localNodeID);
        dbr3.setString("Keytype", keytype);
        dbr3.setString("KeySign", "1");
        dbsql.execute("deleteOldWK", dbr3);
        dbr3.setString("NodeID", localNodeID);
        dbr3.setString("Keytype", keytype);
        dbr3.setString("KeySign", "1");
        dbr3.setString("KeySign_old", "0");
        dbr3.setString("ModifyDate", formatDate);
        dbsql.execute("alterKeyInfo", dbr3);
    }

    private String doFormatDate(Date dtIn, boolean bShowTimePartIn) {
        if (bShowTimePartIn) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dtIn);
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(dtIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyStatus(String keyType2Req) {
        try {
            boolean bl;
            HashSet<String> keys = new HashSet<String>();
            DBRecord dbr = new DBRecord();
            dbr.setString("KeySign", "0");
            DBRecordSet rec = DBSql.getInstance("local").queryRecords("getKeyStore", dbr);
            if (!rec.isEmpty()) {
                for (int i = 0; i < rec.size(); ++i) {
                    DBRecord rec1 = rec.getRow(i);
                    String keyType = rec1.getString("KeyType");
                    keys.add(keyType);
                }
            }
            if (keyType2Req.equalsIgnoreCase("1") && !keys.contains("0")) {
                this.errMsg = "\u672c\u5730\u4e3b\u5bc6\u94a5\u72b6\u6001\u4e0d\u6b63\u5e38";
                bl = false;
                return bl;
            }
            if (!keyType2Req.equalsIgnoreCase("1") && !keys.contains("1")) {
                this.errMsg = "\u672c\u5730\u57fa\u672c\u5bc6\u94a5\u72b6\u6001\u4e0d\u6b63\u5e38";
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }
}

