/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security.securityManage;

import com.dc.datastore.DataStoreMan;
import com.dc.db.DBRecord;
import com.dc.db.DBSql;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.security.KeyStoreFactory;
import com.dc.eai.security.Normalsecurity;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecurityDeleteNode
extends Normalsecurity {
    private static Log log = LogFactory.getLog((Class)SecurityDeleteNode.class);

    public ServiceResult execute(CompositeData arg0) {
        Field fld;
        ServiceResult sr = new ServiceResult();
        CompositeData cd = new CompositeData();
        String orgID = arg0.getField("orgid").strValue();
        if (this.isExist(orgID)) {
            this.deleteNode(orgID);
            fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 10));
            fld.setValue("\u5220\u9664\u8282\u70b9\u5b8c\u6210");
        } else {
            fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 32));
            fld.setValue("\u6570\u636e\u5e93\u4e2d\u65e0\u6b64\u673a\u6784\u7684\u8282\u70b9\u4fe1\u606f!");
        }
        cd.addField("keymsg", fld);
        cd.addField("orgid", arg0.getField("orgid"));
        sr.setOutput(cd);
        sr.setStatus(ServiceResultStatus.SUCCESS);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExist(String orgID) {
        try {
            DBRecord dbr = new DBRecord();
            dbr.setString("OrgID", orgID);
            dbr.setString("status", "0");
            DBRecord rec = DBSql.getInstance("local").query("getNodeinfo", dbr);
            boolean bl = rec != null;
            return bl;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNode(String orgID) {
        try {
            Date currentDate = Calendar.getInstance().getTime();
            String formatDate = this.doFormatDate(currentDate, true);
            DBRecord dbr = new DBRecord();
            dbr.setString("OrgID", orgID);
            dbr.setString("status", "1");
            dbr.setString("ModifyDate", formatDate);
            DBSql.getInstance("local").execute("deleteNodeInfo", dbr);
            KeyStoreFactory.setNodeUpdated(true);
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    public String doFormatDate(Date dtIn, boolean bShowTimePartIn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dtIn);
    }
}

