/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security.securityManage;

import com.dc.datastore.DataStoreMan;
import com.dc.db.DBRecord;
import com.dc.db.DBSql;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.security.KeyStoreFactory;
import com.dc.eai.security.Normalsecurity;
import com.dc.eai.security.keystore.DESKey;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecurityAutoMK
extends Normalsecurity {
    private static Log log = LogFactory.getLog((Class)SecurityAutoMK.class);
    private boolean executeResult = false;

    public ServiceResult execute(CompositeData data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u6269\u5c55\u670d\u52a1->\u81ea\u52a8\u751f\u6210\u5bc6\u94a5<-\u5f00\u59cb\u6267\u884c\uff01");
        }
        ServiceResult sr = new ServiceResult();
        DESKey key = new DESKey();
        String autoMK = "";
        try {
            autoMK = key.creatDES();
            autoMK = DESKey.desEncrypt(autoMK, "1231231212abc324");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.isExistMK()) {
            this.executeResult = this.deleteMK();
        }
        this.saveMK(autoMK);
        CompositeData cd = new CompositeData();
        Field fld = new Field(new FieldAttr(FieldType.FIELD_STRING, 16));
        fld.setValue(autoMK);
        cd.addField("key", fld);
        cd.addField("tran_id", data.getField("tran_id"));
        Field fld2 = new Field(new FieldAttr(FieldType.FIELD_STRING, 16));
        fld2.setValue("\u6210\u529f\u751f\u6210\u4e3b\u5bc6\u94a5");
        cd.addField("keymsg", fld2);
        sr.setOutput(cd);
        if (log.isDebugEnabled() && this.executeResult) {
            log.debug((Object)"\u6269\u5c55\u670d\u52a1->\u81ea\u52a8\u751f\u6210\u5bc6\u94a5<-\u5bc6\u94a5\u5b58\u50a8\u6210\u529f\uff01");
        }
        sr.setStatus(ServiceResultStatus.SUCCESS);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExistMK() {
        try {
            String nodeID = "000000000";
            DBRecord dbr = new DBRecord();
            dbr.setString("nodeid", nodeID);
            dbr.setString("Keytype", "0");
            DBRecord result = DBSql.getInstance("local").query("existMasterKey", dbr);
            boolean bl = result == null;
            return bl;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteMK() {
        try {
            Date currentDate = Calendar.getInstance().getTime();
            String formatDate = this.doFormatDate(currentDate, true);
            DBRecord dbr = new DBRecord();
            dbr.setString("Keysign", "1");
            DBSql dbsql = DBSql.getInstance("local");
            int result1 = dbsql.execute("deleteOldMK", dbr);
            dbr = new DBRecord();
            dbr.setString("Keysign", "1");
            dbr.setString("Keysign_old", "0");
            dbr.setString("ModifyDate", formatDate);
            int result2 = dbsql.execute("alterMKInfo", dbr);
            boolean bl = result1 > 0 && result2 > 0;
            return bl;
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMK(String autoMK) {
        try {
            DBRecord rec = new DBRecord();
            Date currentDate = Calendar.getInstance().getTime();
            String formatDate = this.doFormatDate(currentDate, true);
            rec.setString("NodeID", "000000000");
            rec.setString("KeyType", "0");
            rec.setString("KeySign", "0");
            rec.setString("Key", autoMK);
            rec.setString("CreateDate", formatDate);
            DBSql.getInstance("local").execute("saveKey", rec);
            KeyStoreFactory.setKeyUpdated(true);
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    private String doFormatDate(Date dateIn, boolean bShowTimePartIn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dateIn);
    }
}

