/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security.dispatcher;

import com.dc.eai.channel.Channel;
import com.dc.eai.channel.ChannelException;
import com.dc.eai.channel.Tran;
import com.dc.eai.channel.TranException;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.config.NormalDispatchConfig;
import com.dc.eai.data.CompositeData;
import com.dc.eai.dispatch.Context;
import com.dc.eai.dispatch.Dispatch;
import com.dc.eai.dispatch.DispatchException;
import com.dc.eai.security.Security;
import com.dc.eai.service.ServiceResult;
import com.dc.eai.service.ServiceResultStatus;
import com.dc.exception.SystemException;
import com.dc.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.NDC;

public class SecurityDispatch
implements Dispatch {
    private static Log log = LogFactory.getLog((Class)SecurityDispatch.class);
    private NormalDispatchConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object doDispatch(Object data) {
        block39: {
            if (log.isInfoEnabled()) {
                log.info((Object)("\u6838\u5fc3\u8c03\u5ea6[" + this.config.getName() + "]\u5f00\u59cb"));
            }
            try {
                Object response;
                block38: {
                    Context context = Context.getInstance();
                    response = null;
                    String channelName = this.config.getChannel();
                    this.printInfo("\u6838\u5fc3\u8c03\u5ea6\uff1a\u6e20\u9053\u540d\u79f0[" + channelName + "]");
                    ComponentManager componentManager = ComponentManagerGetter.getManager();
                    boolean hasChannel = componentManager.containsComponent(channelName);
                    if (hasChannel) {
                        CompositeData request;
                        Channel channel = (Channel)ComponentManagerGetter.getManager().getComponent(channelName);
                        String senderSysType = channel.getConfig().getName();
                        this.printInfo("\u6838\u5fc3\u8c03\u5ea6\uff1a\u53d1\u9001\u65b9\u7cfb\u7edf\u7c7b\u578b[" + senderSysType + "]");
                        context.setSenderSysType(senderSysType);
                        Tran tran = null;
                        try {
                            tran = channel.getTran(data);
                        }
                        catch (ChannelException ce) {
                            this.printError("\u6838\u5fc3\u8c03\u5ea6\uff1a\u83b7\u53d6\u4ea4\u6613\u5f02\u5e38\uff0c\u7ec4\u5f02\u5e38\u5305\u8fd4\u56de", ce);
                            Object object = response = channel.processError(ce.errCode(), ce.getMessage());
                            NDC.remove();
                            return object;
                        }
                        NDC.pop();
                        NDC.push((String)tran.getConfig().getName());
                        String serviceName = null;
                        try {
                            request = tran.unpack(data);
                            serviceName = tran.getServiceName();
                        }
                        catch (ChannelException te) {
                            this.printError("\u6838\u5fc3\u8c03\u5ea6:\u6e20\u9053\u5f02\u5e38", te);
                            Object object = response = channel.processError(te.errCode(), te.getMessage());
                            NDC.remove();
                            return object;
                        }
                        catch (TranException te) {
                            this.printError("\u6838\u5fc3\u8c03\u5ea6\uff1a\u4ea4\u6613\u62c6\u5305\u5f02\u5e38\uff0c\u7ec4\u5f02\u5e38\u5305\u8fd4\u56de", te);
                            Object object = response = tran.packSystemError(te.errCode(), te.getMessage());
                            NDC.remove();
                            return object;
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)("\u6838\u5fc3\u8c03\u5ea6\uff1a\u6e20\u9053\u4ea4\u6613[" + tran.getConfig().getName() + "]"));
                            log.info((Object)("\u6838\u5fc3\u8c03\u5ea6\uff1a\u670d\u52a1\u540d[" + serviceName + "]"));
                        }
                        context.setTranName(tran.getConfig().getName());
                        context.setServiceName(serviceName);
                        boolean hasService = componentManager.containsComponent(serviceName);
                        if (hasService) {
                            Security service = (Security)componentManager.getComponent(serviceName);
                            if (service != null) {
                                ServiceResult result = service.execute(request);
                                ServiceResultStatus status = result.status();
                                this.printDebug("\u6838\u5fc3\u8c03\u5ea6\uff1a\u670d\u52a1\u6267\u884c\u7ed3\u679c\u72b6\u6001[" + status + "]");
                                context.setServiceStatus(Integer.toString(status.getValue()));
                                try {
                                    if (ServiceResultStatus.SUCCESS.equals(status)) {
                                        response = tran.pack(result.getOutput());
                                        break block38;
                                    }
                                    if (ServiceResultStatus.ERROR.equals(status)) {
                                        response = tran.packError(result.getOutput());
                                        break block38;
                                    }
                                    if (null != status) {
                                        Exception o = result.exception();
                                        SystemException se = new SystemException("service_execute_error", o);
                                        se.addScene("status", status);
                                        response = tran.packSystemError(se.errCode(), se.getMessage());
                                        break block38;
                                    }
                                    Exception o = result.exception();
                                    SystemException se = null;
                                    if (o != null) {
                                        if (!(o instanceof SystemException)) {
                                            se = new SystemException("service_unknow_exception", o);
                                            se.addScene("\u6838\u5fc3\u8c03\u5ea6", o);
                                        } else {
                                            se = (SystemException)o;
                                        }
                                    } else {
                                        se = new SystemException("service_unknow_exception");
                                        se.addScene("\u6838\u5fc3\u8c03\u5ea6", "\u670d\u52a1\u6267\u884c\u672a\u77e5\u5f02\u5e38");
                                    }
                                    if (log.isErrorEnabled()) {
                                        log.error((Object)"\u6838\u5fc3\u8c03\u5ea6\uff1a\u670d\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u7ec4\u5f02\u5e38\u5305\u8fd4\u56de", (Throwable)se);
                                    }
                                    response = tran.packSystemError(se.errCode(), se.getMessage());
                                }
                                catch (TranException te) {
                                    if (log.isErrorEnabled()) {
                                        log.error((Object)"\u6838\u5fc3\u8c03\u5ea6\uff1a\u4ea4\u6613\u7ec4\u5305\u5f02\u5e38", (Throwable)te);
                                    }
                                    response = tran.packSystemError(te.errCode(), te.getMessage());
                                }
                                catch (Exception e) {
                                    log.error((Object)"\u6838\u5fc3\u8c03\u5ea6\uff1a\u4ea4\u6613\u7ec4\u5305\u672a\u77e5\u5f02\u5e38", (Throwable)e);
                                }
                            } else {
                                DispatchException e = new DispatchException(this.config.getName(), "service_not_found");
                                e.addScene("servcie", serviceName);
                                this.printError("\u8c03\u5ea6\u5f02\u5e38\uff1a", e);
                                response = tran.packSystemError(e.errCode(), e.getMessage());
                            }
                        } else {
                            DispatchException e = new DispatchException(this.config.getName(), "service_not_found");
                            e.addScene("service", serviceName);
                            if (log.isErrorEnabled()) {
                                log.error((Object)"\u4ea4\u6613\u7ec4\u5305\u5f02\u5e38", (Throwable)e);
                            }
                            response = tran.packSystemError(e.errCode(), e.getMessage());
                        }
                    } else {
                        DispatchException e = new DispatchException(this.config.getName(), "channel_not_found");
                        e.addScene("channel", channelName);
                        throw e;
                    }
                }
                if (log.isDebugEnabled()) {
                    if (response instanceof byte[]) {
                        log.debug((Object)("\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a" + StringUtils.bytesToString((byte[])response)));
                    } else {
                        log.debug((Object)("\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a" + response));
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("\u6838\u5fc3\u8c03\u5ea6[" + this.config.getName() + "]\u6267\u884c\u7ed3\u675f"));
                }
                Object object = response;
                return object;
                {
                    catch (Exception e) {
                        log.debug((Object)"\u6838\u5fc3\u8c03\u5ea6\u5f02\u5e38", (Throwable)e);
                        break block39;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                NDC.remove();
            }
        }
        return null;
    }

    public void setConfig(NormalDispatchConfig config) {
        this.config = config;
    }

    private void printDebug(String debug) {
        if (log.isDebugEnabled()) {
            log.debug((Object)debug);
        }
    }

    private void printError(String error, Exception e) {
        if (log.isErrorEnabled()) {
            log.error((Object)"\u6838\u5fc3\u8c03\u5ea6\uff1a\u4ea4\u6613\u7ec4\u5305\u5f02\u5e38", (Throwable)e);
        }
    }

    private void printInfo(String info) {
        if (log.isInfoEnabled()) {
            log.debug((Object)info);
        }
    }
}

