/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security.adapter;

import com.dc.eai.security.adapter.SecurityTCPException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecurityTCPSocket {
    private static Log log = LogFactory.getLog((Class)SecurityTCPSocket.class);
    private String address = null;
    private int commport = 0;
    private int timeout = 3000;
    private int maxbytes = 2048;
    private InputStream in = null;
    private OutputStream out = null;
    private Socket socket;
    private byte[] recvbuff;
    private int currentOffset = 0;
    private int currentLength = 0;

    public SecurityTCPSocket(String address, int port, int timeout, int maxbytes) {
        this.address = address;
        this.commport = port;
        this.timeout = timeout;
        this.maxbytes = maxbytes;
        this.recvbuff = new byte[maxbytes];
    }

    public void connect() {
        try {
            this.socket = new Socket(this.address, this.commport);
            this.socket.setSoTimeout(this.timeout);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5efa\u7acb\u901a\u8bafsocket\u5bf9\u8c61,\u8bbe\u7f6e\u901a\u8baf\u63a5\u6536\u8d85\u65f6\u65f6\u95f4");
            }
        }
        catch (SocketException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SocketException is emerged.");
            }
            throw new SecurityTCPException("socket_connect_exception", e);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IOException is emerged.");
            }
            throw new SecurityTCPException("socket_connect_ioexception", e);
        }
    }

    public void close() {
        try {
            this.in.close();
            this.out.close();
            this.socket.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u5173\u95edsocket");
            }
        }
        catch (SocketException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SocketException is emerged.");
            }
            throw new SecurityTCPException("socket_close_exception", e);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IOException is emerged.");
            }
            throw new SecurityTCPException("socket_close_exception", e);
        }
    }

    public int send(byte[] buff, int buffOff, int buffLen) {
        int curOffset = buffOff;
        int len = buffLen;
        try {
            if (len <= this.maxbytes) {
                this.out.write(buff, curOffset, len);
            } else {
                this.out.write(buff, curOffset, this.maxbytes);
                len -= this.maxbytes;
                curOffset += this.maxbytes;
            }
            this.out.flush();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u53d1\u9001\u6570\u636e\u5931\u8d25");
                log.debug((Object)("\u6570\u636e\u957f\u5ea6:" + buffLen));
                log.debug((Object)("\u6570\u636e:" + buff));
            }
            throw new SecurityTCPException("send_date_error", e);
        }
        return buffLen;
    }

    public int send(byte[] buff) {
        return this.send(buff, 0, buff.length);
    }

    public int recv(byte[] buff, int buffOff, int buffLen) {
        if (buff == null || buffOff < 0 || buffLen <= 0 || buffOff + buffLen > buff.length) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        if (this.currentLength < buffLen) {
            if (this.currentLength > 0) {
                byte[] tmp = new byte[this.currentLength];
                System.arraycopy(this.recvbuff, this.currentOffset, tmp, 0, this.currentLength);
                System.arraycopy(tmp, 0, this.recvbuff, 0, this.currentLength);
            }
            this.currentOffset = 0;
            try {
                int tmpLength = this.in.read(this.recvbuff, this.currentLength, this.maxbytes - this.currentLength);
                this.currentLength += tmpLength;
                if (this.currentLength < buffLen) {
                    throw new SecurityTCPException("recieve_data_error");
                }
            }
            catch (IOException e) {
                throw new SecurityTCPException("recieve_data_error", e);
            }
        }
        System.arraycopy(this.recvbuff, this.currentOffset, buff, buffOff, buffLen);
        this.currentLength -= buffLen;
        this.currentOffset += buffLen;
        return buffLen;
    }

    public int recv(byte[] buff) {
        int lenAll = buff.length;
        int offset = 0;
        int lenRead = 0;
        while (lenAll - lenRead > 0) {
            try {
                lenRead += this.in.read(buff, offset, lenAll - lenRead);
            }
            catch (IOException e) {
                throw new SecurityTCPException("recieve_data_error", e);
            }
            offset = lenRead;
        }
        return lenAll;
    }

    public byte[] recv() {
        byte[] tmp = new byte[this.maxbytes];
        try {
            int length = this.in.read(tmp);
            System.out.println("---length readed-" + String.valueOf(length));
            byte[] received = new byte[length];
            System.arraycopy(tmp, 0, received, 0, length);
            return received;
        }
        catch (IOException e) {
            throw new SecurityTCPException("recieve_data_error", e);
        }
    }
}

