/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security.adapter;

import com.dc.eai.adapter.Adapter;
import com.dc.eai.adapter.AdapterCloseException;
import com.dc.eai.adapter.AdapterConnectException;
import com.dc.eai.adapter.AdapterReceiveDataException;
import com.dc.eai.adapter.AdapterSendDataException;
import com.dc.eai.component.LifeCycle;
import com.dc.eai.config.AdapterConfig;
import com.dc.eai.security.adapter.SecurityTCPException;
import com.dc.eai.security.adapter.SecurityTCPSocket;
import com.dc.util.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecurityAdapter
implements Adapter,
LifeCycle {
    private static Log log = LogFactory.getLog((Class)SecurityAdapter.class);
    private AdapterConfig config;
    private SecurityTCPSocket tcpsock;
    private int mode = 0;
    private String address = null;
    private int commport = 0;
    private int timeout = 3000;
    private int nodetype = 0;
    private int maxbytes = 0;
    private static final int SHORT_CONNECTION = 0;
    private static final int LONG_CONNECTION = 1;
    private static final String MODE = "mode";
    private static final String MAXBYTES = "maxbytes";
    private static final String NODETYPE = "nodetype";
    private static final String ADDRESS = "address";
    private static final String COMMPORT = "commport";
    private static final String TIMEOUT = "timeout";

    public AdapterConfig getConfig() {
        return this.config;
    }

    public void setConfig(AdapterConfig config) {
        this.config = config;
        this.mode = NumberUtils.intValue(config.getAttribute(MODE));
        this.address = config.getAttribute(ADDRESS);
        this.commport = NumberUtils.intValue(config.getAttribute(COMMPORT));
        this.timeout = NumberUtils.intValue(config.getAttribute(TIMEOUT));
        this.maxbytes = NumberUtils.intValue(config.getAttribute(MAXBYTES));
        this.nodetype = NumberUtils.intValue(config.getAttribute(NODETYPE));
        this.tcpsock = new SecurityTCPSocket(this.address, this.commport, this.timeout, this.maxbytes);
    }

    public SecurityAdapter() {
    }

    public SecurityAdapter(AdapterConfig config) {
        this.setConfig(config);
    }

    public void start() {
        if (this.mode == 1) {
            try {
                this.tcpsock.connect();
            }
            catch (SecurityTCPException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cannot establish socket connection to " + this.config.getAttribute(ADDRESS) + ":" + this.config.getAttribute(COMMPORT)), (Throwable)e);
                }
                throw new AdapterConnectException(e);
            }
        }
    }

    public void stop() {
        if (this.mode == 1) {
            try {
                this.tcpsock.close();
            }
            catch (SecurityTCPException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cannot destroy socket connection to " + this.config.getAttribute(ADDRESS) + ":" + this.config.getAttribute(COMMPORT)), (Throwable)e);
                }
                throw new AdapterCloseException(e);
            }
        }
    }

    public Object doComm(Object request) {
        Object nodeIP;
        byte[] req = (byte[])request;
        byte[] in = this.addLength(req);
        byte[] out = null;
        if (this.nodetype == 0) {
            nodeIP = this.getNodeIP(req);
            this.address = nodeIP;
            this.tcpsock = new SecurityTCPSocket(this.address, this.commport, this.timeout, this.maxbytes);
        }
        if (this.mode == 0) {
            try {
                this.tcpsock.connect();
                this.writepacket(this.tcpsock, in);
                System.out.println(this.tcpsock.toString() + this.address + this.commport);
                out = this.readpacket(this.tcpsock);
                out = this.checklength(out);
                nodeIP = out;
                return nodeIP;
            }
            catch (SecurityTCPException e) {
                log.error((Object)("\u65e0\u6cd5\u5efa\u7acb\u5230\u4ee5\u4e0b\u5730\u5740\u7684\u8fde\u63a5 " + this.address + ":" + this.config.getAttribute(COMMPORT)), (Throwable)e);
                throw new AdapterConnectException(e);
            }
            finally {
                this.tcpsock.close();
            }
        }
        if (this.mode == 1) {
            try {
                this.writepacket(this.tcpsock, in);
                out = this.readpacket(this.tcpsock);
                return this.checklength(out);
            }
            catch (AdapterSendDataException e) {
                this.tcpsock.close();
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u53d1\u9001\u6570\u636e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                }
                throw e;
            }
            catch (AdapterReceiveDataException e) {
                this.tcpsock.close();
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u63a5\u6536\u6570\u636e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                }
                throw e;
            }
            catch (SecurityTCPException e) {
                throw new AdapterConnectException(e);
            }
        }
        return null;
    }

    private byte[] checklength(byte[] source) {
        return source;
    }

    private byte[] readpacket(SecurityTCPSocket tcpsock) {
        try {
            return tcpsock.recv();
        }
        catch (SecurityTCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bfb\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterReceiveDataException(e);
        }
    }

    private void writepacket(SecurityTCPSocket tcpsock, byte[] buff) {
        try {
            tcpsock.send(buff);
        }
        catch (SecurityTCPException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            throw new AdapterSendDataException(e);
        }
    }

    private byte[] addLength(byte[] in) {
        int len = in.length;
        String bLen = String.valueOf(len);
        while (bLen.length() < 10) {
            bLen = "0" + bLen;
        }
        bLen.getBytes();
        String temp1 = bLen + new String(in);
        in = temp1.getBytes();
        return in;
    }

    private String getNodeIP(byte[] input) {
        int length = input.length;
        byte[] nodeId = new byte[15];
        for (int i = 0; i < 15; ++i) {
            nodeId[i] = input[length - 15 + i];
        }
        String orgIdStr = new String(nodeId);
        return orgIdStr.trim();
    }
}

