/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security;

import com.dc.exception.BaseException;
import com.dc.util.pack.PackUtils;

public class PinStringConverter {
    public static byte[] str2pin(byte[] in, int size) {
        if (size % 2 == 1) {
            throw new BaseException("\u9519\u8bef\u7684pin\u957f\u5ea6" + size + "\uff1a\u5fc5\u987b\u662f\u5076\u6570");
        }
        if (size > in.length) {
            byte[] b = PinStringConverter.str2pin(in);
            byte[] out = new byte[size];
            System.arraycopy(b, 0, out, 0, b.length);
            for (int i = 0; i < size - b.length; ++i) {
                out[i + b.length] = -1;
            }
            return out;
        }
        if (size < in.length) {
            throw new BaseException("\u5bc6\u7801\u957f\u5ea6\u6bd4\u8f93\u5165\u4e32\u77ed\uff1a" + size + "<" + in.length);
        }
        return PinStringConverter.str2pin(in);
    }

    private static byte[] str2pin(byte[] in) {
        byte[] out = new byte[in.length];
        if (in.length % 2 != 0) {
            throw new BaseException("\u9519\u8bef\u7684pin\u957f\u5ea6" + in.length + "\uff1a\u5fc5\u987b\u662f\u5076\u6570");
        }
        for (int count = 0; count < in.length; ++count) {
            char tmp_char = (char)in[count];
            if (tmp_char == 'f' || tmp_char == 'F') {
                if (count % 2 != 1) continue;
                out[count / 2] = -1;
                continue;
            }
            if (count % 2 != 1) continue;
            int h = in[count - 1] - 48;
            int l = in[count] - 48;
            int r = h * 16 + l;
            byte[] temp = new byte[1];
            PackUtils.put_int8(temp, 0, r);
            out[count / 2] = temp[0];
        }
        for (int x = in.length / 2; x < in.length; ++x) {
            out[x] = -1;
        }
        return out;
    }
}

