/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security;

import com.dc.datastore.DataStoreMan;
import com.dc.db.DBRecord;
import com.dc.db.DBRecordSet;
import com.dc.db.DBSql;
import com.dc.eai.security.KeyStoreFactory;
import com.dc.eai.security.SecurityConfigSet;
import com.dc.eai.security.SecurityNormalException;
import com.dc.eai.security.keystore.DESKey;
import com.dc.xml.binding.ExtDigesterHelper;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetKeyStore
implements Runnable {
    private Log log = LogFactory.getLog((Class)GetKeyStore.class);
    private int sleepTime = 2000;
    private boolean stopThread = false;

    public void run() {
        String secEffective;
        this.initFiled2encrypt();
        try {
            secEffective = KeyStoreFactory.getField2encrypt().getSwitch("SecEffective");
        }
        catch (Exception e) {
            throw new SecurityNormalException("\u83b7\u53d6\u5b89\u5168\u7ec4\u4ef6\u5f00\u5173\u5931\u8d25");
        }
        if (!secEffective.equalsIgnoreCase("0")) {
            while (!this.stopThread) {
                if (KeyStoreFactory.getKeyUpdated()) {
                    this.getkeystore();
                    KeyStoreFactory.setKeyUpdated(false);
                } else if (KeyStoreFactory.getNodeUpdated()) {
                    this.getNodeIP();
                    KeyStoreFactory.setNodeUpdated(false);
                } else if (KeyStoreFactory.getSysUpdated()) {
                    this.getNodeType();
                    this.getNodeID();
                    KeyStoreFactory.setSysUpdated(false);
                }
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)(e + "\n" + e.getMessage()));
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5b89\u5168\u5b50\u7cfb\u7edf\u5f53\u524d\u72b6\u6001\u4e3a\u5173\u95ed");
        }
    }

    public void stopRunning() {
        this.stopThread = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getkeystore() {
        block12: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u83b7\u53d6\u5bc6\u94a5\u4ed3\u5e93\u5f00\u59cb");
            }
            try {
                String key;
                String mK = "";
                String bK = "";
                DBRecord dbr = new DBRecord();
                dbr.setString("KeySign", "0");
                DBRecordSet rec = DBSql.getInstance("local").queryRecords("getKeyStore", dbr);
                HashMap keyStore = new HashMap();
                HashMap nodeKeyStore = new HashMap();
                HashMap resultStore = new HashMap();
                if (rec.isEmpty()) break block12;
                for (int i = 0; i < rec.size(); ++i) {
                    DBRecord rec1 = rec.getRow(i);
                    String nodeId = rec1.getString("NodeId");
                    String keyType = rec1.getString("KeyType");
                    key = rec1.getString("Key");
                    if (keyStore.get(nodeId) != null) {
                        nodeKeyStore = (HashMap)keyStore.get(nodeId);
                        nodeKeyStore.put(keyType, key);
                        continue;
                    }
                    HashMap<String, String> tmpnodeKeyStore = new HashMap<String, String>();
                    tmpnodeKeyStore.put(keyType, key);
                    keyStore.put(nodeId, tmpnodeKeyStore);
                }
                HashMap tmpMKStore = (HashMap)keyStore.get("000000000");
                String tmpMk = (String)tmpMKStore.get("0");
                try {
                    mK = DESKey.desDecrypt(tmpMk, "1231231212abc324");
                }
                catch (Exception e) {
                    throw new SecurityNormalException("\u89e3\u5bc6\u4e3b\u5bc6\u94a5\u5931\u8d25");
                }
                Set it = keyStore.keySet();
                Iterator itSet = it.iterator();
                while (itSet.hasNext()) {
                    key = (String)itSet.next();
                    HashMap tmp = (HashMap)keyStore.get(key);
                    if (!tmp.containsKey("1")) continue;
                    String tmpBK = (String)tmp.get("1");
                    try {
                        bK = DESKey.desDecrypt(tmpBK, mK);
                    }
                    catch (Exception e) {
                        throw new SecurityNormalException("\u89e3\u5bc6\u57fa\u672c\u5bc6\u94a5\u5931\u8d25");
                    }
                    HashMap result = new HashMap();
                    this.encryptWK(tmp, result, bK);
                    tmp = result;
                    resultStore.put(key, tmp);
                }
                KeyStoreFactory.setKeyStore(resultStore);
            }
            finally {
                DataStoreMan.getInstance().getDataStore("local").close(true);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u83b7\u53d6\u5bc6\u94a5\u4ed3\u5e93\u7ed3\u675f");
            this.log.debug((Object)"\u83b7\u53d6\u8282\u70b9IP\u4ee5\u53ca\u673a\u6784\u5bc6\u94a5\u7d22\u5f15&\u8282\u70b9ID\u5bf9\u5e94\u5217\u8868\u5f00\u59cb");
        }
    }

    private Map encryptWK(Map tmp, Map result, String bK) {
        Set it2 = tmp.keySet();
        Iterator itSet2 = it2.iterator();
        while (itSet2.hasNext()) {
            String key2 = (String)itSet2.next();
            if (key2.equalsIgnoreCase("0") || key2.equalsIgnoreCase("1")) continue;
            String tmpWK = (String)tmp.get(key2);
            String wK = "";
            try {
                wK = DESKey.desDecrypt(tmpWK, bK);
            }
            catch (Exception e) {
                throw new SecurityNormalException("\u89e3\u5bc6\u5de5\u4f5c\u5bc6\u94a5\u5931\u8d25");
            }
            result.put(key2, wK);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNodeIP() {
        try {
            DBRecordSet result = DBSql.getInstance("local").queryRecords("getIP", new DBRecord());
            HashMap<String, String> ipStore = new HashMap<String, String>();
            HashMap<String, String> org2node = new HashMap<String, String>();
            if (result != null) {
                for (int i = 0; i < result.size(); ++i) {
                    DBRecord dbr = result.getRow(i);
                    String orgId = dbr.getString("orgId");
                    String nodeIP = dbr.getString("NodeIP");
                    String status = dbr.getString("status");
                    String nodeID = dbr.getString("nodeid");
                    if (!status.equalsIgnoreCase("0")) continue;
                    ipStore.put(orgId, nodeIP);
                    org2node.put(orgId, nodeID);
                }
                if (!ipStore.isEmpty()) {
                    KeyStoreFactory.setIPstore(ipStore);
                    KeyStoreFactory.setorg2node(org2node);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u83b7\u53d6\u8282\u70b9IP\u4ee5\u53ca\u673a\u6784\u5bc6\u94a5\u7d22\u5f15&\u8282\u70b9ID\u5bf9\u5e94\u5217\u8868\u7ed3\u675f");
            }
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNodeType() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u8bbe\u7f6e\u672c\u5730\u8282\u70b9\u7c7b\u578b\u5f00\u59cb");
        }
        try {
            DBRecord dbr = new DBRecord();
            dbr.setString("ParaType", "localNodeId");
            DBRecord rec = DBSql.getInstance("local").query("getlocalNodetype", dbr);
            if (rec != null) {
                String localNodeID = rec.getString("ParaValue");
                char nodeAttr = localNodeID.charAt(localNodeID.length() - 1);
                if (nodeAttr == '1') {
                    KeyStoreFactory.setisCentral(true);
                } else if (nodeAttr == '0') {
                    KeyStoreFactory.setisCentral(false);
                }
            }
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u8bbe\u7f6e\u672c\u5730\u8282\u70b9\u7c7b\u578b\u7ed3\u675f");
        }
    }

    private void initFiled2encrypt() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u521d\u59cb\u5316\u52a0\u89e3\u5bc6Field\u5217\u8868\u5f00\u59cb");
        }
        try {
            String eaiHome = System.getProperty("EAI_HOME");
            File rules = new File(eaiHome + "/shared/field2encrypt.rule.xml");
            File input = new File(eaiHome + "/components/security/Field2Encrypt.xml");
            String pathOfRule = "file:///" + rules.getAbsolutePath();
            String pathOfXML = "file:///" + input.getAbsolutePath();
            Object filed2encrypt = ExtDigesterHelper.load(new URL(pathOfRule), this.getClass().getClassLoader(), new URL(pathOfXML));
            KeyStoreFactory.setField2encrypt((SecurityConfigSet)filed2encrypt);
        }
        catch (Exception exc) {
            throw new SecurityNormalException("\u521d\u59cb\u5316\u52a0\u89e3\u5bc6Field\u5217\u8868\u5931\u8d25");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u521d\u59cb\u5316\u52a0\u89e3\u5bc6Field\u5217\u8868\u7ed3\u675f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNodeID() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5f00\u59cb\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u672c\u5730\u673a\u6784\u53f7...");
        }
        try {
            DBRecord dbr = new DBRecord();
            dbr.setString("ParaType", "localNodeId");
            DBRecord rec = DBSql.getInstance("local").query("getlocalNodetype", dbr);
            if (rec != null) {
                String localNodeID = rec.getString("ParaValue");
                String NodeID2 = localNodeID.substring(0, 4);
                KeyStoreFactory.setLocalNodeID(NodeID2);
            }
        }
        finally {
            DataStoreMan.getInstance().getDataStore("local").close(true);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u672c\u5730\u673a\u6784\u53f7\u7ed3\u675f");
        }
    }
}

