/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security;

import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldType;
import com.dc.eai.security.KeyStoreFactory;
import com.dc.eai.security.SecurityConfig;
import com.dc.eai.security.SecurityInterface;
import com.dc.eai.security.SecurityNormalException;
import com.dc.eai.security.keystore.DESKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataProcess {
    private static Log log = LogFactory.getLog((Class)DataProcess.class);

    public static String encryptData(String srcData, int length, int keyType, String desNode) throws Exception {
        String secEffective;
        try {
            secEffective = KeyStoreFactory.getField2encrypt().getSwitch("SecEffective");
        }
        catch (Exception e) {
            throw new SecurityNormalException("\u83b7\u53d6\u5b89\u5168\u7ec4\u4ef6\u5f00\u5173\u5931\u8d25");
        }
        if (secEffective.equalsIgnoreCase("0")) {
            log.debug((Object)"\u5f53\u524d\u5b89\u5168\u7ec4\u4ef6\u72b6\u6001\u4e3a\u5173\u95ed,encryptData\u76f4\u63a5\u8fd4\u56de\u539f\u59cb\u6570\u636e");
            return srcData;
        }
        Map keyStore = KeyStoreFactory.getKeyStore();
        HashMap org2node = KeyStoreFactory.getorg2node();
        String nodeID = (String)org2node.get(desNode);
        String key = "";
        try {
            Map nodeKeyStore = (Map)keyStore.get(String.valueOf(nodeID));
            key = (String)nodeKeyStore.get(String.valueOf(keyType));
        }
        catch (Exception e) {
            return srcData;
        }
        String desdata = DESKey.desEncrypt(srcData, key);
        return desdata;
    }

    public static String decryptData(String srcData, int length, int keyType, String srcNode) throws Exception {
        String secEffective;
        try {
            secEffective = KeyStoreFactory.getField2encrypt().getSwitch("SecEffective");
        }
        catch (Exception e) {
            throw new SecurityNormalException("\u83b7\u53d6\u5b89\u5168\u7ec4\u4ef6\u5f00\u5173\u5931\u8d25");
        }
        if (secEffective.equalsIgnoreCase("0")) {
            log.debug((Object)"\u5f53\u524d\u5b89\u5168\u7ec4\u4ef6\u72b6\u6001\u4e3a\u5173\u95ed,encryptData\u76f4\u63a5\u8fd4\u56de\u539f\u59cb\u6570\u636e");
            return srcData;
        }
        Map keyStore = KeyStoreFactory.getKeyStore();
        HashMap org2node = KeyStoreFactory.getorg2node();
        String nodeID = (String)org2node.get(srcNode);
        String key = "";
        try {
            Map nodeKeyStore = (Map)keyStore.get(String.valueOf(nodeID));
            key = (String)nodeKeyStore.get(String.valueOf(keyType));
        }
        catch (Exception e) {
            return srcData;
        }
        String desData = DESKey.desDecrypt(srcData, key);
        return desData;
    }

    public static CompositeData encryptData(CompositeData input) {
        return DataProcess.encryptData(input, true);
    }

    public static CompositeData decryptData(CompositeData input) {
        return DataProcess.decryptData(input, true);
    }

    public static CompositeData encryptData(CompositeData input, boolean isRequest) {
        String orgID;
        String secEffective;
        try {
            secEffective = KeyStoreFactory.getField2encrypt().getSwitch("SecEffective");
        }
        catch (Exception e) {
            throw new SecurityNormalException("\u83b7\u53d6\u5b89\u5168\u7ec4\u4ef6\u5f00\u5173\u5931\u8d25");
        }
        if (secEffective.equalsIgnoreCase("0")) {
            log.debug((Object)"\u5f53\u524d\u5b89\u5168\u7ec4\u4ef6\u72b6\u6001\u4e3a\u5173\u95ed,encryptData\u76f4\u63a5\u8fd4\u56de\u539f\u59cb\u6570\u636e");
            return input;
        }
        CompositeData output = new CompositeData();
        String nodeInfo2Get = "";
        nodeInfo2Get = KeyStoreFactory.getisCentral() ? "DEST_BRANCH_NO" : "SOURCE_BRANCH_NO";
        try {
            orgID = (String)input.getStruct("SYS_HEAD").getField(nodeInfo2Get).getValue();
        }
        catch (Exception e) {
            throw new SecurityNormalException("\u5728CompositeData\u83b7\u53d6\u901a\u8baf\u53cc\u65b9\u673a\u6784\u5bc6\u94a5\u7d22\u5f15\u5931\u8d25");
        }
        Map field2encrypt = KeyStoreFactory.getField2encrypt().getConfigSet();
        DataProcess.encrypt(input, output, field2encrypt, orgID, isRequest);
        return output;
    }

    public static CompositeData decryptData(CompositeData input, boolean isRequest) {
        String orgID;
        String secEffective;
        try {
            secEffective = KeyStoreFactory.getField2encrypt().getSwitch("SecEffective");
        }
        catch (Exception e) {
            throw new SecurityNormalException("\u83b7\u53d6\u5b89\u5168\u7ec4\u4ef6\u5f00\u5173\u5931\u8d25");
        }
        if (secEffective.equalsIgnoreCase("0")) {
            log.debug((Object)"\u5f53\u524d\u5b89\u5168\u7ec4\u4ef6\u72b6\u6001\u4e3a\u5173\u95ed,decryptData\u76f4\u63a5\u8fd4\u56de\u539f\u59cb\u6570\u636e");
            return input;
        }
        CompositeData output = new CompositeData();
        String nodeInfo2Get = "";
        nodeInfo2Get = KeyStoreFactory.getisCentral() ? "SOURCE_BRANCH_NO" : "DEST_BRANCH_NO";
        try {
            orgID = (String)input.getStruct("SYS_HEAD").getField(nodeInfo2Get).getValue();
        }
        catch (Exception e) {
            throw new SecurityNormalException("\u5728CompositeData\u83b7\u53d6\u901a\u8baf\u53cc\u65b9\u673a\u6784\u5bc6\u94a5\u7d22\u5f15\u5931\u8d25");
        }
        Map field2encrypt = KeyStoreFactory.getField2encrypt().getConfigSet();
        DataProcess.decrypt(input, output, field2encrypt, orgID, isRequest);
        return output;
    }

    private static void encrypt(CompositeData source, CompositeData dest, Map fieldName, String orgID, boolean isRequest) {
        Iterator it = source.iterator();
        while (it.hasNext()) {
            AtomData data;
            String name = (String)it.next();
            AtomData atom = source.getObject(name);
            if (atom.isField()) {
                if (fieldName.containsKey(name)) {
                    Field fld = new Field(((Field)atom).getAttr());
                    SecurityConfig config = (SecurityConfig)fieldName.get(name);
                    String encryptType = config.getencryptType(isRequest);
                    if (encryptType != null && !encryptType.equals("default")) {
                        try {
                            Field tmp;
                            SecurityInterface impl = (SecurityInterface)(class$com$dc$eai$security$DataProcess == null ? DataProcess.class$("com.dc.eai.security.DataProcess") : class$com$dc$eai$security$DataProcess).getClassLoader().loadClass(encryptType).newInstance();
                            String paraType = config.getencryptParaType();
                            String encryptedData = "";
                            if (paraType.equalsIgnoreCase("String")) {
                                tmp = (Field)atom;
                                encryptedData = impl.EncryptData(tmp.strValue());
                            } else {
                                tmp = (Field)atom;
                                encryptedData = impl.EncryptData(source, tmp.getValue().toString());
                            }
                            fld.setValue(encryptedData);
                            dest.addField(name, fld);
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    String keyType = config.getkeyType();
                    DataProcess.encrypt((Field)atom, fld, keyType, orgID);
                    dest.addField(name, fld);
                    continue;
                }
                dest.addField(name, (Field)atom);
                continue;
            }
            if (atom.isArray()) {
                data = new Array();
                DataProcess.encrypt((Array)atom, data, fieldName, orgID, isRequest);
                dest.addArray(name, (Array)data);
                continue;
            }
            if (!atom.isStruct()) continue;
            data = new CompositeData();
            DataProcess.encrypt((CompositeData)atom, (CompositeData)data, fieldName, orgID, isRequest);
            dest.addStruct(name, (CompositeData)data);
        }
    }

    private static void encrypt(Array source, Array dest, Map fieldName, String orgID, boolean isRequest) {
        for (int i = 0; i < source.size(); ++i) {
            AtomData data;
            AtomData atom = source.getObject(i);
            if (atom == null) continue;
            if (atom.isArray()) {
                data = new Array();
                DataProcess.encrypt((Array)atom, data, fieldName, orgID, isRequest);
                dest.addArray((Array)data);
                continue;
            }
            if (atom.isStruct()) {
                data = new CompositeData();
                DataProcess.encrypt((CompositeData)atom, (CompositeData)data, fieldName, orgID, isRequest);
                dest.addStruct((CompositeData)data);
                continue;
            }
            if (!atom.isField()) continue;
            Field fld = new Field(((Field)atom).getAttr());
            DataProcess.fieldCopy(fld, (Field)atom);
            dest.addField(fld);
        }
    }

    private static void encrypt(Field source, Field dest, String keyType, String orgID) {
        String encryptedData = "";
        String srcData = "";
        if (source.getFieldType().equals(FieldType.FIELD_STRING)) {
            try {
                srcData = (String)source.getValue();
                encryptedData = srcData != null ? DataProcess.encryptData(srcData, srcData.length(), Integer.parseInt(keyType), orgID) : srcData;
            }
            catch (Exception e) {
                throw new SecurityNormalException("\u52a0\u5bc6Field\u5931\u8d25" + source);
            }
            dest.setValue(encryptedData);
        } else {
            DataProcess.fieldCopy(dest, source);
        }
    }

    private static void decrypt(CompositeData source, CompositeData dest, Map fieldName, String orgID, boolean isRequest) {
        Iterator it = source.iterator();
        while (it.hasNext()) {
            AtomData data;
            String name = (String)it.next();
            AtomData atom = source.getObject(name);
            if (atom.isField()) {
                if (fieldName.containsKey(name)) {
                    Field fld = new Field(((Field)atom).getAttr());
                    SecurityConfig config = (SecurityConfig)fieldName.get(name);
                    String decryptType = config.getdecryptType(isRequest);
                    if (decryptType != null && !decryptType.equals("default")) {
                        try {
                            Field tmp;
                            SecurityInterface impl = (SecurityInterface)(class$com$dc$eai$security$DataProcess == null ? DataProcess.class$("com.dc.eai.security.DataProcess") : class$com$dc$eai$security$DataProcess).getClassLoader().loadClass(decryptType).newInstance();
                            String paraType = config.getencryptParaType();
                            String decryptedData = "";
                            if (paraType.equalsIgnoreCase("String")) {
                                tmp = (Field)atom;
                                decryptedData = impl.DecryptData(tmp.strValue());
                            } else {
                                tmp = (Field)atom;
                                decryptedData = impl.DecryptData(source, tmp.getValue().toString());
                            }
                            fld.setValue(decryptedData);
                            dest.addField(name, fld);
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    String keyType = config.getkeyType();
                    DataProcess.decrypt((Field)atom, fld, keyType, orgID);
                    dest.addField(name, fld);
                    continue;
                }
                dest.addField(name, (Field)atom);
                continue;
            }
            if (atom.isArray()) {
                data = new Array();
                DataProcess.decrypt((Array)atom, data, fieldName, orgID, isRequest);
                dest.addArray(name, (Array)data);
                continue;
            }
            if (!atom.isStruct()) continue;
            data = new CompositeData();
            DataProcess.decrypt((CompositeData)atom, (CompositeData)data, fieldName, orgID, isRequest);
            dest.addStruct(name, (CompositeData)data);
        }
    }

    private static void decrypt(Array source, Array dest, Map fieldName, String orgID, boolean isRequest) {
        for (int i = 0; i < source.size(); ++i) {
            AtomData data;
            AtomData atom = source.getObject(i);
            if (atom == null) continue;
            if (atom.isArray()) {
                data = new Array();
                DataProcess.decrypt((Array)atom, data, fieldName, orgID, isRequest);
                dest.addArray((Array)data);
                continue;
            }
            if (atom.isStruct()) {
                data = new CompositeData();
                DataProcess.decrypt((CompositeData)atom, (CompositeData)data, fieldName, orgID, isRequest);
                dest.addStruct((CompositeData)data);
                continue;
            }
            if (!atom.isField()) continue;
            Field fld = new Field(((Field)atom).getAttr());
            DataProcess.fieldCopy(fld, (Field)atom);
            dest.addField(fld);
        }
    }

    private static void decrypt(Field source, Field dest, String keyType, String orgID) {
        String encryptedData = "";
        String srcData = "";
        if (source.getFieldType().equals(FieldType.FIELD_STRING)) {
            try {
                srcData = (String)source.getValue();
                encryptedData = srcData != null ? DataProcess.decryptData(srcData, srcData.length(), Integer.parseInt(keyType), orgID) : srcData;
            }
            catch (Exception e) {
                throw new SecurityNormalException("\u89e3\u5bc6Field\u5931\u8d25" + source);
            }
            dest.setValue(encryptedData);
        } else {
            DataProcess.fieldCopy(dest, source);
        }
    }

    private static void fieldCopy(Field destFld, Field srcFld) {
        if (srcFld.getFieldType().equals(FieldType.FIELD_STRING)) {
            destFld.setValue((String)srcFld.getValue());
        } else if (srcFld.getFieldType().equals(FieldType.FIELD_DOUBLE)) {
            destFld.setValue((Double)srcFld.getValue());
        } else if (srcFld.getFieldType().equals(FieldType.FIELD_FLOAT)) {
            destFld.setValue((Float)srcFld.getValue());
        } else if (srcFld.getFieldType().equals(FieldType.FIELD_INT)) {
            destFld.setValue((Integer)srcFld.getValue());
        } else if (srcFld.getFieldType().equals(FieldType.FIELD_INT24)) {
            destFld.setValue((Integer)srcFld.getValue());
        } else if (srcFld.getFieldType().equals(FieldType.FIELD_LONG)) {
            destFld.setValue((Long)srcFld.getValue());
        } else if (srcFld.getFieldType().equals(FieldType.FIELD_SHORT)) {
            destFld.setValue((Short)srcFld.getValue());
        } else if (srcFld.getFieldType().equals(FieldType.FIELD_BYTE)) {
            destFld.setValue((Byte)srcFld.getValue());
        } else if (srcFld.getFieldType().equals(FieldType.FIELD_IMAGE)) {
            destFld.setValue((byte[])srcFld.getValue());
        } else {
            throw new SecurityNormalException("Unknown Field Type!");
        }
    }

    public static byte[] decrypt(byte[] obj, String nodeID) throws NumberFormatException, Exception {
        Map configSet = KeyStoreFactory.getField2encrypt().getConfigSet();
        String input = new String(obj);
        input = input.replaceAll("\n", "");
        Iterator it = configSet.keySet().iterator();
        while (it.hasNext()) {
            String fldName = (String)it.next();
            if (log.isInfoEnabled()) {
                log.info((Object)("decrypt fieldName is " + fldName));
            }
            String keyType = ((SecurityConfig)configSet.get(fldName)).getkeyType();
            Pattern pattern = Pattern.compile("<data[^>]*name=\"" + fldName + "\"><field[^>]*>[^<]*");
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                String tmp = matcher.group();
                String src = tmp.substring(tmp.lastIndexOf(">") + 1, tmp.length());
                String des = DataProcess.decryptData(src, src.length(), Integer.parseInt(keyType), nodeID);
                String destmp = tmp.replaceAll(src, des);
                input = input.replaceAll(tmp, destmp);
            }
        }
        return input.getBytes();
    }

    public static byte[] encrypt(byte[] obj, String nodeID) throws NumberFormatException, Exception {
        String input;
        Map configSet = KeyStoreFactory.getField2encrypt().getConfigSet();
        String result = input = new String(obj);
        Iterator it = configSet.keySet().iterator();
        while (it.hasNext()) {
            String fldName = (String)it.next();
            if (log.isInfoEnabled()) {
                log.info((Object)("encrypt fieldName is " + fldName));
            }
            String keyType = ((SecurityConfig)configSet.get(fldName)).getkeyType();
            Pattern pattern = Pattern.compile("<data[^>]*name=\"" + fldName + "\"><field[^>]*>[^<]*");
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                String tmp = matcher.group();
                String src = tmp.substring(tmp.lastIndexOf(">") + 1, tmp.length());
                String des = DataProcess.encryptData(src, src.length(), Integer.parseInt(keyType), nodeID);
                String destmp = tmp.replaceAll(src, des);
                result = result.replaceAll(tmp, destmp);
            }
        }
        return result.getBytes();
    }
}

