/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.security;

import com.dc.eai.security.CryptMAC;

public class CryptMACBean
implements CryptMAC {
    public static native int GenEncrypt(byte[] var0, byte[] var1, int var2, byte[] var3);

    public static native int GenDecrypt(byte[] var0, byte[] var1, int var2, byte[] var3);

    public static native int EncryptPIN(byte[] var0, byte[] var1, int var2, byte[] var3);

    public static native int DecryptPIN(byte[] var0, byte[] var1, int var2, byte[] var3);

    public static native int AttachSecurityNode(byte[] var0);

    public static native int DetachSecurityNode();

    public byte[] GenEncrypt(String NodeID2, byte[] in) {
        byte[] node_id = NodeID2.getBytes();
        int len = in.length;
        int result = 0;
        byte[] out = new byte[len + 32];
        try {
            result = CryptMACBean.GenEncrypt(node_id, in, len, out);
        }
        catch (Exception e) {
            RuntimeException ex = new RuntimeException("CRY00001");
            throw ex;
        }
        if (result != 0) {
            RuntimeException ex = new RuntimeException("CRY00001");
            throw ex;
        }
        return out;
    }

    public byte[] GenDecrypt(String NodeID2, byte[] in) throws RuntimeException {
        byte[] node_id = NodeID2.getBytes();
        int len = in.length;
        byte[] out = new byte[len - 32];
        int result = 0;
        try {
            result = CryptMACBean.GenDecrypt(node_id, in, len, out);
        }
        catch (Exception e) {
            RuntimeException ex = new RuntimeException("CRY00002");
            throw ex;
        }
        if (result != 0) {
            RuntimeException ex = new RuntimeException("CRY00002");
            throw ex;
        }
        return out;
    }

    public byte[] EncryptPIN(String NodeID2, byte[] in) throws RuntimeException {
        byte[] inbuf = null;
        byte[] node_id = NodeID2.getBytes();
        int len = in.length;
        int result = 0;
        byte[] out = new byte[len];
        inbuf = CryptMACBean.AscToBcd(in, in.length);
        if (inbuf == null) {
            throw new RuntimeException("CRY00005");
        }
        try {
            result = CryptMACBean.EncryptPIN(node_id, inbuf, len, out);
        }
        catch (Exception e) {
            RuntimeException ex = new RuntimeException("CRY00003");
            throw ex;
        }
        if (result != 0) {
            RuntimeException ex = new RuntimeException("CRY00003");
            throw ex;
        }
        return out;
    }

    public byte[] DecryptPIN(String NodeID2, byte[] in) throws RuntimeException {
        return in;
    }

    public static byte[] AscToBcd(byte[] in, int size) {
        if (size > in.length) {
            return null;
        }
        if (size % 2 == 1) {
            return null;
        }
        boolean i = false;
        byte[] out = new byte[size];
        for (int count = 0; count < size; ++count) {
            char tmp_char = (char)in[count];
            if (tmp_char == 'f' || tmp_char == 'F') {
                if (count % 2 == 1) {
                    out[count / 2] = (byte)(255 + (in[count - 1] - 63 << 4));
                }
                ++count;
                while (count < size) {
                    tmp_char = (char)in[count];
                    if (tmp_char != 'F' && tmp_char != 'f') {
                        return null;
                    }
                    if (count % 2 == 1) {
                        out[count / 2] = -1;
                    }
                    ++count;
                }
                continue;
            }
            if (count % 2 != 1) continue;
            out[count / 2] = (byte)(255 + (in[count - 1] - 63 << 4) + (in[count] - 63));
        }
        for (int x = size / 2; x < in.length; ++x) {
            out[x] = -1;
        }
        return out;
    }

    public static byte[] BcdToAsc(byte[] in, int size) {
        if (size > in.length) {
            return null;
        }
        boolean i = false;
        int asc_size = size * 2;
        byte[] out = new byte[asc_size];
        for (int count = 0; count < asc_size; ++count) {
            char tmp_char = (char)in[count / 2];
            out[count] = count % 2 == 1 ? (byte)((in[count / 2] & 0xF) + 48) : (byte)((in[count / 2] >> 4) + 48);
            if (out[count] == 63) {
                out[count] = 70;
                ++count;
                while (count < asc_size) {
                    if (in[count / 2] != -1) {
                        return null;
                    }
                    out[count] = 70;
                    ++count;
                }
                continue;
            }
            if ((char)out[count] <= '9' && (char)out[count] >= '0') continue;
            return null;
        }
        return out;
    }

    static {
        System.out.println("java.library.path: " + System.getProperty("java.library.path"));
        System.loadLibrary("security");
    }
}

