/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.platform.plugins.svc_mgr;

import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.load.AbstractComponentLoader;
import com.dc.eai.load.impl.ConsoleComponentLoader;
import com.dc.eai.load.impl.TimerComponentLoader;
import com.dc.eai.load.impl.UnreloadableComponentLoader;
import com.dc.eai.load.impl.VaryComponentLoader;
import com.dc.eai.platform.plugins.svc_mgr.ServiceManager;
import com.dc.eai.platform.plugins.svc_mgr.ServiceManagerException;
import com.dc.util.classloader.PathClassFinder;
import com.dc.util.classloader.Source;
import com.dc.util.xml.CommonData;
import com.dc.util.xml.XMLCommonData;
import com.dc.util.xml.store.XMLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceManagerImpl
implements ServiceManager {
    private Log log = LogFactory.getLog((Class)ServiceManagerImpl.class);
    private ComponentManager cm = ComponentManagerGetter.getManager();
    private ClassLoader cl;

    public ServiceManagerImpl(ClassLoader cl) {
        this.cl = cl;
    }

    public void start(String path) {
        Source s = new PathClassFinder(path).getSource("component.xml");
        if (s == null) {
            ServiceManagerException sme = new ServiceManagerException("not_component_path");
            sme.addScene("path", path);
            throw sme;
        }
        CommonData root = this.loadXML(s);
        this.addComponent(root, this.cm, new File(path));
    }

    public void stop(String name) {
        Object o;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u9700\u505c\u6b62\u7684\u670d\u52a1\u7ec4\u4ef6\u540d=[" + name + "]"));
            this.log.debug((Object)("\u5bb9\u5668\u4e2d\u542b\u6709\u8be5\u7ec4\u4ef6=" + this.cm.containsComponent(name)));
            if (this.cm.containsComponent(name)) {
                this.log.debug((Object)this.cm.getComponentMetaData(name));
            }
            String[] names = this.cm.getAllNames();
            for (int i = 0; i < names.length; ++i) {
                this.log.debug((Object)names[i]);
            }
        }
        if ((o = this.cm.getComponent(name)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u4e0d\u5b58\u5728\u7684\u670d\u52a1\u7ec4\u4ef6\u540d=[" + name + "]"));
            }
            ServiceManagerException sme = new ServiceManagerException("no_component");
            sme.addScene("name", name);
            throw sme;
        }
        Object result = this.cm.removeComponent(name);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u670d\u52a1\u5df2\u505c\u6b62\uff0c\u670d\u52a1\u7ec4\u4ef6\u540d=[" + name + ""));
        }
    }

    private CommonData loadXML(Source s) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u88c5\u8f7dXML\u6587\u4ef6\u5f00\u59cb");
        }
        XMLCommonData root = new XMLCommonData();
        try {
            XMLoader.load((CommonData)root, s.getInputStream());
        }
        catch (IOException e) {
            IllegalStateException is = new IllegalStateException("GetInputStream error, source: " + s.toString() + "\n" + e.getMessage());
            throw is;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u88c5\u8f7dXML\u6587\u4ef6\u6210\u529f\uff0cURL=[" + s + "]"));
        }
        return root;
    }

    private void addComponent(CommonData root, ComponentManager cmgr, File current) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u83b7\u53d6\u7ec4\u4ef6\u88c5\u8f7d\u5668\u7c7b\u578b\u5f00\u59cb");
        }
        String loaderType = (String)root.getChild("component").getChild("loader").getChild("update-manner").getAttribute("name");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u5668\u7c7b\u578b=[" + loaderType + "]"));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u83b7\u53d6\u7ec4\u4ef6\u88c5\u8f7d\u8def\u5f84\u5f00\u59cb");
        }
        StringBuffer path = new StringBuffer();
        if (root.getChild("component").getChild("loader").getChild("path") == null) {
            path.append(current.getAbsolutePath()).append(File.pathSeparatorChar).append(current.getAbsolutePath() + File.separator + "class").append(File.pathSeparatorChar).append(ServiceManagerImpl.getPath(current.getAbsolutePath() + File.separator + "lib"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u9ed8\u8ba4\u8def\u5f84=[" + path + "]"));
            }
        } else {
            for (int childIndex = 0; childIndex < root.getChild("component").getChild("loader").getChild("path").childCount(); ++childIndex) {
                String tempPath = (String)root.getChild("component").getChild("loader").getChild("path").getChild(childIndex).getValue();
                File dir = current;
                boolean absolute = true;
                while (tempPath.length() >= 1 && tempPath.substring(0, 1).equals(".")) {
                    absolute = false;
                    if (tempPath.substring(0, 2).equals("..")) {
                        tempPath = tempPath.substring(3);
                        dir = dir.getParentFile();
                        continue;
                    }
                    tempPath = tempPath.substring(2);
                }
                if (absolute) {
                    path.append(tempPath);
                } else {
                    path.append(dir.getAbsolutePath() + File.separator + tempPath);
                }
                path.append(File.pathSeparatorChar);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u914d\u7f6e\u4e2d\u6307\u5b9a\u7ec4\u4ef6\u88c5\u8f7d\u8def\u5f84=[" + path + "]"));
            }
        }
        AbstractComponentLoader loader = null;
        if (root.getChild("component").getChild("loader").getChild("default-entry") != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u83b7\u53d6\u7ec4\u4ef6\u88c5\u8f7d\u914d\u7f6e\u89c4\u5219\u5f00\u59cb");
            }
            String rule = (String)root.getChild("component").getChild("loader").getChild("default-entry").getChild("rule").getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u914d\u7f6e\u89c4\u5219=[" + rule + "]"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u83b7\u53d6\u7ec4\u4ef6\u88c5\u8f7d\u914d\u7f6e\u5f00\u59cb");
            }
            String config = (String)root.getChild("component").getChild("loader").getChild("default-entry").getChild("conf").getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u914d\u7f6e=[" + rule + "]"));
            }
            if (loaderType.equals("VaryReload")) {
                loader = new VaryComponentLoader(path.toString(), rule, config);
            } else if (loaderType.equals("TimerReload")) {
                loader = new TimerComponentLoader(path.toString(), rule, config);
            } else if (loaderType.equals("ConsoleReload")) {
                loader = new ConsoleComponentLoader(path.toString(), rule, config, (String)root.getChild("component").getAttribute("name"));
            } else if (loaderType.equals("NeverReload")) {
                loader = new UnreloadableComponentLoader(path.toString(), rule, config);
            }
        } else if (root.getChild("component").getChild("loader").getChild("class-entry") != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u83b7\u53d6\u7ec4\u4ef6\u88c5\u8f7d\u7c7b\u5f00\u59cb");
            }
            String clazz = (String)root.getChild("component").getChild("loader").getChild("class-entry").getAttribute("class");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4\u4ef6\u88c5\u8f7d\u7c7b=[" + clazz + "]"));
            }
            if (loaderType.equals("VaryReload")) {
                loader = new VaryComponentLoader(path.toString(), clazz);
            } else if (loaderType.equals("TimerReload")) {
                loader = new TimerComponentLoader(path.toString(), clazz);
            } else if (loaderType.equals("ConsoleReload")) {
                loader = new ConsoleComponentLoader(path.toString(), clazz, (String)root.getChild("component").getAttribute("name"));
            } else if (loaderType.equals("NeverReload")) {
                loader = new UnreloadableComponentLoader(path.toString(), clazz);
            }
        }
        try {
            CommonData descCD;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u7ec4\u4ef6\u88c5\u8f7d\u5f00\u59cb");
            }
            String desc = (descCD = root.getChild("component").getChild("desc")) == null ? "" : (String)descCD.getValue();
            cmgr.addComponent((String)root.getChild("component").getAttribute("name"), new Class[]{Class.forName((String)root.getChild("component").getChild("type").getValue(), true, this.cl)}, desc, loader);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u7ec4\u4ef6\u88c5\u8f7d\u6210\u529f");
            }
        }
        catch (ClassNotFoundException e) {
            IllegalStateException is = new IllegalStateException("ClassNotFound! ClassName: " + (String)root.getChild("component").getChild("type").getValue() + "\n" + e.getMessage());
            throw is;
        }
    }

    private static String getPath(String lib) {
        StringBuffer path = new StringBuffer();
        File lib_dir = new File(lib);
        if (lib_dir.exists()) {
            File[] jars = lib_dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                path.append(jars[i].getAbsoluteFile()).append(File.pathSeparatorChar);
            }
        }
        return path.toString();
    }
}

