/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.platform;

import com.dc.eai.aop.AopConfig;
import com.dc.eai.aop.TargetSource;
import com.dc.eai.aop.proxy.JdkDynamicAopProxy;
import com.dc.eai.aop.proxy.ProxyConfig;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentMetaData;
import com.dc.eai.component.LifeCycle;
import com.dc.eai.component.ThreadUnsafe;
import com.dc.eai.load.ComponentLoader;
import com.dc.eai.platform.ServerException;
import com.dc.eai.platform.support.AdvisorChainFactoryUtils;
import com.dc.eai.platform.support.DefaultComponentMetaData;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Container
implements ComponentManager {
    private static Log log = LogFactory.getLog((Class)Container.class);
    Map name2component = Collections.synchronizedMap(new HashMap(101));
    Map cache_name2proxy = Collections.synchronizedMap(new HashMap(101));
    Map cache_name2meta = Collections.synchronizedMap(new HashMap(101));
    ClassLoader svr_loader;
    ClassLoader app_loader;
    AopConfig aopConf;
    private boolean lazyLoad = true;

    public Container(ClassLoader server, ClassLoader appli) {
        this.svr_loader = server;
        this.app_loader = appli;
    }

    public Object createComponent(String name, Class[] interfaces, Object o) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentMetaData getComponentMetaData(Object o) {
        ComponentMetaData metaData = null;
        if (o instanceof String) {
            Map map = this.cache_name2meta;
            synchronized (map) {
                metaData = (ComponentMetaData)this.cache_name2meta.get(o);
                if (metaData == null) {
                    Component c = (Component)this.name2component.get(o);
                    if (c == null) {
                        return null;
                    }
                    metaData = new DefaultComponentMetaData(c.name, c.desc, c.interfaces);
                    this.cache_name2meta.put(o, metaData);
                    return metaData;
                }
            }
        }
        if (Proxy.isProxyClass(o.getClass())) {
            Iterator names = this.cache_name2proxy.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                Object proxy = this.cache_name2proxy.get(name);
                if (!o.equals(proxy)) continue;
                metaData = this.getComponentMetaData(name);
                break;
            }
        } else {
            metaData = (ComponentMetaData)this.cache_name2meta.get(o);
            if (metaData != null) {
                return metaData;
            }
            Iterator names = this.name2component.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                Component c = (Component)this.name2component.get(name);
                if (!o.equals(c.cmp)) continue;
                metaData = this.getComponentMetaData(name);
                break;
            }
        }
        if (metaData != null && !this.cache_name2meta.containsKey(o)) {
            this.cache_name2meta.put(o, metaData);
        }
        return metaData;
    }

    public Object getComponent(String name) {
        Object rv = this.cache_name2proxy.get(name);
        if (rv != null) {
            return rv;
        }
        if (!this.containsComponent(name)) {
            return null;
        }
        final Object component = ((Component)this.name2component.get(name)).getCmp();
        if (component == null) {
            return null;
        }
        if (this.getAopConf() == null || !AdvisorChainFactoryUtils.mayJoinIntercept(this.getAopConf(), component, component.getClass(), name)) {
            rv = component instanceof ThreadUnsafe ? ((ThreadUnsafe)component).copy() : component;
        } else {
            if (component instanceof ThreadUnsafe) {
                TargetSource ts = new TargetSource(){

                    public Class getTargetClass() {
                        return component.getClass();
                    }

                    public boolean isStatic() {
                        return false;
                    }

                    public Object getTarget() throws Exception {
                        return ((ThreadUnsafe)component).copy();
                    }

                    public void releaseTarget(Object target) throws Exception {
                    }
                };
                ProxyConfig pc = new ProxyConfig(ts, this.getComponentMetaData(component).getInterfaces(), this.getAopConf().getAdvisors(), AdvisorChainFactoryUtils.COMPONENT_ADVISOR_CHAIN_FACTORY);
                JdkDynamicAopProxy ap = new JdkDynamicAopProxy(pc);
                this.cache_name2proxy.put(name, ap.getProxy(this.app_loader));
            } else {
                TargetSource ts = new TargetSource(){

                    public Class getTargetClass() {
                        return component.getClass();
                    }

                    public boolean isStatic() {
                        return false;
                    }

                    public Object getTarget() throws Exception {
                        return component;
                    }

                    public void releaseTarget(Object target) throws Exception {
                    }
                };
                ProxyConfig pc = new ProxyConfig(ts, this.getComponentMetaData(component).getInterfaces(), this.getAopConf().getAdvisors(), AdvisorChainFactoryUtils.COMPONENT_ADVISOR_CHAIN_FACTORY);
                JdkDynamicAopProxy ap = new JdkDynamicAopProxy(pc);
                this.cache_name2proxy.put(name, ap.getProxy(this.app_loader));
            }
            rv = this.cache_name2proxy.get(name);
        }
        if (component instanceof LifeCycle) {
            ((LifeCycle)component).start();
        }
        return rv;
    }

    public boolean containsComponent(String name) {
        return this.name2component.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeComponent(String name) {
        Object rv;
        Map map = this.name2component;
        synchronized (map) {
            Component c = (Component)this.name2component.get(name);
            if (c == null) {
                return null;
            }
            this.cache_name2proxy.remove(name);
            this.cache_name2meta.remove(name);
            Component component = c;
            synchronized (component) {
                if (c.getCmp() instanceof LifeCycle) {
                    ((LifeCycle)c.getCmp()).stop();
                }
                rv = c.getCmp();
            }
            this.name2component.remove(name);
        }
        return rv;
    }

    public String[] getAllNames() {
        if (this.name2component.keySet().size() > 0) {
            String[] names = new String[this.name2component.keySet().size()];
            names = this.name2component.keySet().toArray(names);
            return names;
        }
        return new String[0];
    }

    public String[] getAllNames(Class interfaces) {
        ArrayList<String> namelist = new ArrayList<String>();
        Iterator iterator = this.name2component.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            Component component = (Component)this.name2component.get(name);
            for (int i = 0; i < component.interfaces.length; ++i) {
                if (!component.interfaces[i].equals(interfaces)) continue;
                namelist.add(name);
            }
        }
        String[] allNames = new String[namelist.size()];
        namelist.toArray(allNames);
        return allNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponent(String name, Class[] interfaces, String desc, Object o) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Component [" + name + "]\tregistered"));
        }
        final Object fo = o;
        if (name == null) {
            throw new ServerException("ComponentNameCannotBeNull");
        }
        if (interfaces == null || interfaces.length == 0) {
            ServerException e = new ServerException("ComponentInterfacesNotDefined");
            e.addScene("name", o);
            throw e;
        }
        Map map = this.name2component;
        synchronized (map) {
            if (this.name2component.get(name) != null) {
                ServerException e = new ServerException("NameHasBeenBoundAlready");
                e.addScene("name", name);
                throw e;
            }
            Component c = new Component();
            c.name = name;
            c.desc = desc;
            c.interfaces = interfaces;
            if (o instanceof ComponentLoader) {
                c.loader = (ComponentLoader)o;
                if (!this.lazyLoad) {
                    try {
                        c.getCmp();
                    }
                    catch (Exception e) {}
                }
            } else {
                c.loader = new ComponentLoader(){

                    public boolean needReload() {
                        return false;
                    }

                    public Object loadComponent() {
                        return fo;
                    }
                };
            }
            this.name2component.put(name, c);
        }
    }

    public AopConfig getAopConf() {
        return this.aopConf;
    }

    public void setAopConf(AopConfig config) {
        this.aopConf = config;
        this.cache_name2proxy.clear();
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    public Object getCacheMetaData() {
        return this.cache_name2meta;
    }

    public Object getCacheComponent() {
        return this.name2component;
    }

    public Object getCacheProxy() {
        return this.cache_name2proxy;
    }

    static class Component {
        String name;
        String desc;
        Class[] interfaces;
        ComponentLoader loader;
        Object cmp;

        Component() {
        }

        public synchronized Object getCmp() {
            if (this.cmp == null || this.loader.needReload()) {
                this.cmp = this.loader.loadComponent();
                if (this.cmp == null) {
                    ServerException e = new ServerException("ReturnNullAfterLoading");
                    e.addScene("name", this.name);
                    throw e;
                }
            }
            return this.cmp;
        }
    }
}

