/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.platform;

import com.dc.concurrent.Executor;
import com.dc.eai.aop.AopConfig;
import com.dc.eai.component.ComponentManager;
import com.dc.eai.component.ComponentManagerGetter;
import com.dc.eai.load.impl.ComponentMonitorImpl;
import com.dc.eai.platform.Container;
import com.dc.eai.platform.ServerException;
import com.dc.xml.binding.ExtDigesterHelper;
import com.dc.xml.binding.InStreamFactory;
import com.dc.xml.binding.Utilities;
import com.dc.xml.loading.Load;
import com.dc.xml.loading.LoadManager;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BootRelay {
    private static Log log = LogFactory.getLog((Class)BootRelay.class);

    public static void boot(ClassLoader server, ClassLoader apps) {
        ClassLoader old_cl;
        block38: {
            block37: {
                Container container;
                block36: {
                    block35: {
                        URL data;
                        URL rule;
                        block34: {
                            block33: {
                                old_cl = Thread.currentThread().getContextClassLoader();
                                Thread.currentThread().setContextClassLoader(server);
                                container = new Container(server, apps);
                                try {
                                    ComponentManagerGetter.setManager(container);
                                    rule = server.getResource("urn-conf.rule.xml");
                                    data = server.getResource("server-conf.xml");
                                    if (rule == null || data == null) {
                                        throw new IllegalStateException("urn-conf's [rule,data]=" + rule + "," + data);
                                    }
                                    ExtDigesterHelper.load(rule, server, data);
                                    Load l = null;
                                    try {
                                        l = (Load)Utilities.get("urn:obj:sys:server-start-mission", server);
                                    }
                                    catch (Exception e) {
                                        ServerException se = new ServerException("ExceptionOccuredWhenCreatingLoadMission", e);
                                        se.addScene("URI", "urn:obj:sys:server-start-mission");
                                        throw se;
                                    }
                                    container.setLazyLoad(!Boolean.getBoolean("platform.load"));
                                    LoadManager.getInstance().loadSync(l);
                                    if (log.isInfoEnabled()) {
                                        log.info((Object)"Server start mission success");
                                    }
                                }
                                catch (Throwable e) {
                                    if (!log.isErrorEnabled()) break block33;
                                    log.error((Object)"Server start mission failed", e);
                                }
                            }
                            try {
                                List svr_paths;
                                ComponentMonitorImpl svr_cm = new ComponentMonitorImpl(server);
                                ComponentManagerGetter.getManager().addComponent("urn:obj:sys:server-components-monitor", new Class[]{ComponentManager.class}, "\u5e73\u53f0\u7ec4\u4ef6\u63cf\u8ff0\u540c\u6b65\u5668", svr_cm);
                                try {
                                    svr_paths = (List)Utilities.get("urn:obj:sys:server-paths");
                                }
                                catch (Exception e) {
                                    ServerException se = new ServerException("ExceptionOccuredWhenFoundServerComponentPath", e);
                                    se.addScene("URI", "urn:obj:sys:server-paths");
                                    throw se;
                                }
                                svr_cm.sync(svr_paths, container);
                                if (log.isInfoEnabled()) {
                                    log.info((Object)"Server components load success.");
                                }
                            }
                            catch (Throwable e) {
                                if (!log.isErrorEnabled()) break block34;
                                log.error((Object)"Server components load failed.", e);
                            }
                        }
                        Thread.currentThread().setContextClassLoader(apps);
                        try {
                            rule = apps.getResource("urn-conf.rule.xml");
                            data = apps.getResource("app-conf.xml");
                            if (rule == null || data == null) {
                                throw new IllegalStateException("urn-conf's [rule,data]=" + rule + "," + data);
                            }
                            ExtDigesterHelper.load(rule, apps, data);
                            Load l2 = null;
                            try {
                                l2 = (Load)Utilities.get("urn:obj:sys:application-start-mission", apps);
                            }
                            catch (Exception e) {
                                ServerException se = new ServerException("ExceptionOccuredWhenCreatingLoadMission", e);
                                se.addScene("URI", "urn:obj:sys:application-start-mission");
                                throw se;
                            }
                            LoadManager.getInstance().loadSync(l2);
                            if (log.isInfoEnabled()) {
                                log.info((Object)"Applications start mission success");
                            }
                        }
                        catch (Throwable e) {
                            if (!log.isErrorEnabled()) break block35;
                            log.error((Object)"Applications start mission failed", e);
                        }
                    }
                    try {
                        ComponentMonitorImpl app_cm = new ComponentMonitorImpl(apps);
                        ComponentManagerGetter.getManager().addComponent("urn:obj:sys:application-components-monitor", new Class[]{ComponentManager.class}, "\u5e73\u53f0\u7ec4\u4ef6\u63cf\u8ff0\u540c\u6b65\u5668", app_cm);
                        List app_paths = null;
                        try {
                            app_paths = (List)Utilities.get("urn:obj:sys:application-paths");
                        }
                        catch (Exception e) {
                            ServerException se = new ServerException("ExceptionOccuredWhenFoundAppsComponentPath", e);
                            se.addScene("URI", "urn:obj:sys:application-paths");
                            throw se;
                        }
                        app_cm.sync(app_paths, container);
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Application components loading success");
                        }
                    }
                    catch (Throwable e) {
                        if (!log.isErrorEnabled()) break block36;
                        log.error((Object)"Application components loading failed", e);
                    }
                }
                try {
                    AopConfig ac = (AopConfig)Utilities.get("urn:obj:sys:aop-config", server);
                    container.setAopConf(ac);
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Container AOP setup success");
                    }
                }
                catch (Exception e1) {
                    if (!log.isErrorEnabled()) break block37;
                    log.error((Object)"Container AOP setup failed", (Throwable)e1);
                }
            }
            try {
                List l = (List)Utilities.get("urn:obj:sys:actor-config", server);
                if (l.size() == 0 && log.isWarnEnabled()) {
                    log.warn((Object)"Actor num is ZERO!");
                }
                for (int i = 0; i < l.size(); ++i) {
                    Object run_obj = l.get(i);
                    String name = ComponentManagerGetter.getManager().getComponentMetaData(run_obj).getName();
                    Executor exec = (Executor)ComponentManagerGetter.getManager().getComponent("urn:obj:sys:server-actor-executor");
                    try {
                        exec.execute((Runnable)run_obj);
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)("Actor [" + name + "] started"));
                        continue;
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Actor [" + name + "] start failed"), (Throwable)e);
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Actors startup success");
                }
            }
            catch (Exception e1) {
                if (!log.isErrorEnabled()) break block38;
                log.error((Object)"Actors startup failed", (Throwable)e1);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\u5171\u6709 " + ComponentManagerGetter.getManager().getAllNames().length + " \u4e2a\u7ec4\u4ef6\u88c5\u8f7d"));
        }
        Thread.currentThread().setContextClassLoader(old_cl);
    }

    static {
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing URL Handler (zip,env,clazz)");
        }
        InStreamFactory.init();
    }
}

