/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.pack.serialized;

import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.config.FieldStoreModeConfig;
import com.dc.eai.config.IOConfig;
import com.dc.eai.conv.DataConvertException;
import com.dc.eai.conv.FieldConverter;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.Packet;
import com.dc.eai.conv.PacketException;
import com.dc.eai.conv.fieldconv.StringFieldConverter;
import com.dc.eai.conv.fieldconv.WithLengthFieldConverter;
import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.pack.EncryptFieldConverter;
import com.dc.eai.pack.serialized.PackConfig;
import com.dc.util.NumberUtils;
import com.dc.util.pack.PackUtils;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerializedPackageConverter
implements PackageConverter {
    private Log log = LogFactory.getLog((Class)SerializedPackageConverter.class);
    private FieldConverter lfc;
    private FieldStoreModeConfig modeconfig;
    private FieldIOConfig lengthconfig = new FieldIOConfig();
    private PackConfig PINconfig;
    private EncryptFieldConverter encryptfc;
    private EncryptFieldConverter encryptfcEBCDIC;
    private FieldConverter stringfc;

    public SerializedPackageConverter() {
        this.lengthconfig.setName("length");
        this.lengthconfig.setLength(4);
        this.lengthconfig.setScale(0);
        this.lengthconfig.setType(FieldType.FIELD_INT);
        this.modeconfig = new FieldStoreModeConfig();
        this.modeconfig.setStoreMode(FieldType.FIELD_INT, "string");
        this.modeconfig.setStoreMode(FieldType.FIELD_DOUBLE, "string");
        this.modeconfig.setStoreMode(FieldType.FIELD_IMAGE, "string");
        this.modeconfig.setStoreMode(FieldType.FIELD_STRING, "string");
        this.lengthconfig.setStoreMode("string");
        this.lfc = new WithLengthFieldConverter();
        this.encryptfc = new EncryptFieldConverter();
        this.encryptfcEBCDIC = new EncryptFieldConverter();
        this.encryptfcEBCDIC.setEncoding("EBCDIC");
        this.stringfc = new StringFieldConverter();
    }

    public void pack(OutputPacket packet, CompositeData data, IOConfig config) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"******** \u524d\u7f6e\u5e8f\u5217\u5316\u62a5\u6587\u7ec4\u5305\u5f00\u59cb ");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u7ec4\u5165\u53d8\u91cf\u4e2a\u6570\u5f00\u59cb");
        }
        int count = 0;
        this.putInt32(packet, count);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u7ec4\u5165\u53d8\u91cf\u4e2a\u6570\u6210\u529f");
        }
        Iterator variableNameList = data.iterator();
        while (variableNameList.hasNext()) {
            String variableName = (String)variableNameList.next();
            AtomData value = data.getObject(variableName);
            if (value.isField()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("\u7ec4\u5355\u4e2a\u53d8\u91cf" + variableName + "\u5f00\u59cb"));
                }
                this.putStringWithLength(packet, variableName);
                Field field = (Field)value;
                this.putTypeAndValue(packet, field, variableName);
                ++count;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("\u7ec4\u5355\u4e2a\u53d8\u91cf" + variableName + "\u6210\u529f"));
                continue;
            }
            if (!value.isArray()) continue;
            Array dataArray = (Array)value;
            int size = dataArray.size();
            if (dataArray.getObject(0).isField()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("\u7ec4\u6570\u7ec4" + variableName + "\u5f00\u59cb"));
                }
                for (int i = 0; i < size; ++i) {
                    String name = variableName + "#" + i;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("\u7ec4\u6570\u7ec4\u53d8\u91cf" + name + "\u5f00\u59cb"));
                    }
                    this.putStringWithLength(packet, name);
                    Field field = dataArray.getField(i);
                    this.putTypeAndValue(packet, field);
                    ++count;
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("\u7ec4\u6570\u7ec4\u53d8\u91cf" + name + "\u6210\u529f"));
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("\u7ec4\u6570\u7ec4" + variableName + "\u6210\u529f"));
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4Group" + variableName + "\u5f00\u59cb"));
            }
            String groupName = variableName + "##";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4Group\u53d8\u91cf" + groupName + "\u5f00\u59cb"));
            }
            this.putStringWithLength(packet, groupName);
            this.putInt32(packet, 3);
            this.putInt32(packet, size);
            ++count;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u7ec4Group\u53d8\u91cf" + groupName + "\u6210\u529f"));
            }
            for (int i = 0; i < size; ++i) {
                CompositeData dataStruct = dataArray.getStruct(i);
                Iterator fieldList = dataStruct.iterator();
                while (fieldList.hasNext()) {
                    String fieldName = (String)fieldList.next();
                    String name = variableName + "." + fieldName + "#" + i;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("\u7ec4Group\u7684\u5143\u7d20\u53d8\u91cf" + name + "\u5f00\u59cb"));
                    }
                    this.putStringWithLength(packet, name);
                    Field field = dataStruct.getField(fieldName);
                    this.putTypeAndValue(packet, field);
                    ++count;
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("\u7ec4Group\u7684\u5143\u7d20\u53d8\u91cf" + name + "\u6210\u529f"));
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("\u7ec4Group" + variableName + "\u6210\u529f"));
        }
        PackUtils.put_int32(packet.getBuff(), 0, count);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"******** \u524d\u7f6e\u5e8f\u5217\u5316\u62a5\u6587\u7ec4\u5305\u6210\u529f ");
        }
    }

    public void unpack(InputPacket packet, CompositeData data, IOConfig config) {
        if (packet.getOffset() == packet.getLength()) {
            return;
        }
        if (packet.exceed(4)) {
            throw this.PacketLenOverflowException(packet, 4);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"******** \u524d\u7f6e\u5e8f\u5217\u5316\u62a5\u6587\u62c6\u5305\u5f00\u59cb ");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u62c6\u51fa\u53d8\u91cf\u4e2a\u6570\u5f00\u59cb");
        }
        int number = PackUtils.get_int32(packet.getBuff(), packet.getOffset());
        packet.advance(4);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("\u62c6\u51fa\u53d8\u91cf\u4e2a\u6570\u6210\u529f\uff0c\u4e2a\u6570\u4e3a[" + number + "]"));
        }
        CompositeData struct = new CompositeData();
        int repeat = 0;
        int k = 0;
        int count = 0;
        int currentCount = 0;
        boolean flag = false;
        String groupName = null;
        int arrI = 0;
        for (int i = 0; i < number; ++i) {
            String tailName;
            Field value;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u62c6\u7b2c" + i + "\u4e2a\u53d8\u91cf\u5f00\u59cb"));
            }
            String fieldName = this.getStringWithLength(packet);
            int fieldType = this.getInt(packet);
            switch (fieldType) {
                case 3: {
                    int fieldIntValue = this.getInt(packet);
                    FieldAttr fieldattr = new FieldAttr(FieldType.FIELD_INT, 4);
                    value = new Field(fieldattr);
                    value.setValue(fieldIntValue);
                    break;
                }
                case 20: {
                    int fieldIntValue = this.getInt(packet);
                    FieldAttr fieldattr = new FieldAttr(FieldType.FIELD_BYTE, 1);
                    value = new Field(fieldattr);
                    value.setValue(fieldIntValue);
                    break;
                }
                case 6: {
                    String fieldStringValue = this.getStringWithLength(packet);
                    int length = fieldStringValue.length();
                    int scale = 0;
                    if (fieldStringValue.indexOf(43) >= 0 || fieldStringValue.indexOf(45) >= 0) {
                        --length;
                    }
                    if (fieldStringValue.indexOf(46) > 0) {
                        --length;
                        scale = fieldStringValue.length() - fieldStringValue.indexOf(46) - 1;
                    }
                    double fieldDoubleValue = NumberUtils.doubleValue(fieldStringValue);
                    FieldAttr fieldattr = new FieldAttr(FieldType.FIELD_DOUBLE, length);
                    value = new Field(fieldattr);
                    value.setValue(fieldDoubleValue);
                    break;
                }
                case 7: {
                    value = this.getStringWithLength(packet, fieldName);
                    break;
                }
                case 8: {
                    byte[] bv = this.getImageWithLength(packet);
                    FieldAttr fieldattr = new FieldAttr(FieldType.FIELD_IMAGE, bv.length);
                    value = new Field(fieldattr);
                    value.setValue(bv);
                    break;
                }
                default: {
                    throw new PacketException("SerializedPackage_FieldType_Err");
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u6210\u529f\u62c6\u51fa\u7b2c" + i + "\u4e2a\u53d8\u91cf,\u53d8\u91cf\u540d\u4e3a\uff1a" + fieldName));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u5c06\u62c6\u51fa\u7684value\u653e\u5165data\u4e2d\u5f00\u59cb,\u503c\uff1a[" + value.getValue() + "]"));
            }
            if (!flag) {
                if (fieldName.indexOf(35) < 0) {
                    data.addField(fieldName, value);
                } else if (fieldName.indexOf(46) < 0) {
                    if (fieldName.lastIndexOf(35) == fieldName.length() - 1) {
                        groupName = fieldName.substring(0, fieldName.indexOf(35));
                        struct = new CompositeData();
                        k = 0;
                        currentCount = 0;
                        count = 0;
                        repeat = value.intValue();
                        arrI = 0;
                        if (data.getArray(groupName) == null) {
                            data.addArray(groupName, new Array());
                        }
                    } else {
                        String arrName = fieldName.substring(0, fieldName.indexOf(35));
                        tailName = fieldName.substring(fieldName.indexOf(35) + 1);
                        if (data.getArray(arrName) == null) {
                            data.addArray(arrName, new Array());
                            arrI = 0;
                        } else if (!Integer.toString(arrI).equals(tailName)) {
                            throw new PacketException("Packet_Array_Index_Wrong");
                        }
                        data.getArray(arrName).addField(value);
                        ++arrI;
                    }
                } else {
                    groupName = fieldName.substring(0, fieldName.indexOf(46));
                    String name = fieldName.substring(fieldName.indexOf(46) + 1, fieldName.indexOf(35));
                    int index = NumberUtils.intValue(fieldName.substring(fieldName.indexOf(35) + 1));
                    if (repeat == 1) {
                        flag = true;
                    }
                    if (k < repeat) {
                        if (index == k) {
                            ++currentCount;
                            struct.addField(name, value);
                            if (k == 0) {
                                ++count;
                            }
                            if (k != 0 && currentCount == count) {
                                data.getArray(groupName).addStruct(struct);
                                struct = new CompositeData();
                                ++k;
                                currentCount = 0;
                            }
                        } else {
                            if (k == 0) {
                                data.getArray(groupName).addStruct(struct);
                                struct = new CompositeData();
                                ++k;
                                currentCount = 0;
                            }
                            struct.addField(name, value);
                            ++currentCount;
                        }
                    } else if (k >= repeat) {
                        throw new PacketException("Packet_Group_Index_Overflow");
                    }
                }
            } else if (fieldName.indexOf(35) < 0) {
                data.getArray(groupName).addStruct(struct);
                flag = false;
                data.addField(fieldName, value);
            } else if (fieldName.indexOf(46) < 0) {
                data.getArray(groupName).addStruct(struct);
                flag = false;
                if (fieldName.lastIndexOf(35) == fieldName.length() - 1) {
                    groupName = fieldName.substring(0, fieldName.indexOf(35));
                    struct = new CompositeData();
                    k = 0;
                    repeat = value.intValue();
                    if (repeat == 1) {
                        flag = true;
                    }
                    if (data.getArray(groupName) == null) {
                        data.addArray(groupName, new Array());
                    }
                } else {
                    String arrName = fieldName.substring(0, fieldName.indexOf(35));
                    tailName = fieldName.substring(fieldName.indexOf(35) + 1);
                    if (data.getArray(arrName) == null) {
                        data.addArray(arrName, new Array());
                        arrI = 0;
                    } else if (!Integer.toString(arrI).equals(tailName)) {
                        throw new PacketException("Packet_Array_Index_Wrong");
                    }
                    data.getArray(arrName).addField(value);
                    ++arrI;
                }
            } else {
                String groupName1 = fieldName.substring(0, fieldName.indexOf(46));
                String name = fieldName.substring(fieldName.indexOf(46) + 1, fieldName.indexOf(35));
                int index = NumberUtils.intValue(fieldName.substring(fieldName.indexOf(35) + 1));
                if (!groupName.equals(groupName1)) {
                    throw new PacketException("Packet_Group_Err");
                }
                struct.addField(name, value);
                if (i == number - 1) {
                    data.getArray(groupName).addStruct(struct);
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)"\u62c6\u51fa\u7684value\u653e\u5165data\u4e2d\u6210\u529f");
        }
    }

    protected void putStringWithLength(OutputPacket packet, String value) {
        this.putInt32(packet, value.length());
        packet.ensure(value.length());
        PackUtils.put_string(packet.getBuff(), packet.getOffset(), value, value.length());
        packet.advance(value.length());
    }

    protected void putInt32(OutputPacket packet, int value) {
        packet.ensure(4);
        PackUtils.put_int32(packet.getBuff(), packet.getOffset(), value);
        packet.advance(4);
    }

    protected void putTypeAndValue(OutputPacket packet, Field field) {
        boolean isShort = false;
        FieldType fieldType = field.getFieldType();
        int variableType = 3;
        if (fieldType == FieldType.FIELD_BYTE) {
            variableType = 20;
        }
        if (fieldType == FieldType.FIELD_DOUBLE) {
            variableType = 6;
        }
        if (fieldType == FieldType.FIELD_STRING) {
            variableType = 7;
        }
        if (fieldType == FieldType.FIELD_IMAGE) {
            variableType = 8;
        }
        if (fieldType == FieldType.FIELD_SHORT) {
            isShort = true;
        }
        this.putInt32(packet, variableType);
        switch (variableType) {
            case 3: 
            case 20: {
                if (!isShort) {
                    this.putInt32(packet, field.intValue());
                    break;
                }
                this.putInt32(packet, field.shortValue());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                FieldIOConfig config = new FieldIOConfig();
                config.setName("fld");
                config.setType(field.getFieldType());
                config.setLength(field.getAttr().getLength());
                config.setScale(field.getAttr().getScale());
                config.setStoreMode("string");
                CompositeData data = new CompositeData();
                data.addField("fld", field);
                this.lfc.pack(packet, data, config);
            }
        }
    }

    protected void putTypeAndValue(OutputPacket packet, Field field, String name) {
        boolean isShort = false;
        FieldType fieldType = field.getFieldType();
        int variableType = 3;
        if (fieldType == FieldType.FIELD_BYTE) {
            variableType = 20;
        }
        if (fieldType == FieldType.FIELD_DOUBLE) {
            variableType = 6;
        }
        if (fieldType == FieldType.FIELD_STRING) {
            variableType = 7;
        }
        if (fieldType == FieldType.FIELD_IMAGE) {
            variableType = 8;
        }
        if (fieldType == FieldType.FIELD_SHORT) {
            isShort = true;
        }
        this.putInt32(packet, variableType);
        switch (variableType) {
            case 3: 
            case 20: {
                if (!isShort) {
                    this.putInt32(packet, field.intValue());
                    break;
                }
                this.putInt32(packet, field.shortValue());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                FieldIOConfig config = new FieldIOConfig();
                config.setName(name);
                config.setType(field.getFieldType());
                config.setLength(field.getAttr().getLength());
                config.setScale(field.getAttr().getScale());
                config.setStoreMode("string");
                CompositeData data = new CompositeData();
                data.addField(name, field);
                if (this.PINconfig != null && this.PINconfig.isEncrypt(name)) {
                    if (this.PINconfig.getMode(name).equals("imageEBCDIC")) {
                        this.encryptfcEBCDIC.pack(packet, data, config);
                        break;
                    }
                    this.encryptfc.pack(packet, data, config);
                    break;
                }
                this.lfc.pack(packet, data, config);
            }
        }
    }

    protected int getInt(InputPacket packet) {
        if (packet.exceed(4)) {
            throw this.PacketLenOverflowException(packet, 4);
        }
        int fieldValue = PackUtils.get_int32(packet.getBuff(), packet.getOffset());
        packet.advance(4);
        return fieldValue;
    }

    protected String getStringWithLength(InputPacket packet) {
        if (packet.exceed(4)) {
            throw this.PacketLenOverflowException(packet, 4);
        }
        int length = PackUtils.get_int32(packet.getBuff(), packet.getOffset());
        packet.advance(4);
        if (packet.exceed(length)) {
            throw this.PacketLenOverflowException(packet, length);
        }
        String value = PackUtils.get_string(packet.getBuff(), packet.getOffset(), length);
        packet.advance(length);
        return value;
    }

    protected Field getStringWithLength(InputPacket packet, String name) {
        if (packet.exceed(4)) {
            throw this.PacketLenOverflowException(packet, 4);
        }
        int length = PackUtils.get_int32(packet.getBuff(), packet.getOffset());
        packet.advance(4);
        FieldIOConfig fieldconfig = new FieldIOConfig();
        fieldconfig.setName("temp");
        fieldconfig.setLength(length);
        fieldconfig.setType(FieldType.FIELD_STRING);
        fieldconfig.setStoreMode("string");
        CompositeData data = new CompositeData();
        if (this.PINconfig != null && this.PINconfig.isEncrypt(name)) {
            if (this.PINconfig.getMode(name).equals("imageEBCDIC")) {
                this.encryptfcEBCDIC.unpack(packet, data, fieldconfig);
            } else {
                this.encryptfc.unpack(packet, data, fieldconfig);
            }
        } else {
            this.stringfc.unpack(packet, data, fieldconfig);
        }
        Field value = data.getField("temp");
        return value;
    }

    protected byte[] getImageWithLength(InputPacket packet) {
        if (packet.exceed(4)) {
            throw this.PacketLenOverflowException(packet, 4);
        }
        int length = PackUtils.get_int32(packet.getBuff(), packet.getOffset());
        packet.advance(4);
        if (packet.exceed(length)) {
            throw this.PacketLenOverflowException(packet, length);
        }
        byte[] value = new byte[length];
        System.arraycopy(packet.getBuff(), packet.getOffset(), value, 0, length);
        packet.advance(length);
        return value;
    }

    protected RuntimeException PacketLenOverflowException(Packet packet, int length) {
        DataConvertException e = new DataConvertException("PacketLenOverflow");
        e.addScene("Packet", packet);
        e.addScene("Current", packet.getOffset());
        e.addScene("RequestLen", length);
        return e;
    }

    public void setPackConfig(PackConfig config) {
        this.PINconfig = config;
    }
}

