/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.pack.objectdata;

import com.dc.eai.channel.object.exception.TranReflectException;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.pack.objectdata.FieldConverter;
import com.dc.eai.pack.objectdata.ObjectDataConfig;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectDataConverter {
    private static Log log = LogFactory.getLog((Class)ObjectDataConverter.class);

    public void pack(Object cbo, CompositeData compositeData, ObjectDataConfig config) {
        Class<?> outputDataType = cbo.getClass();
        Field[] fields = outputDataType.getFields();
        if (log.isInfoEnabled()) {
            log.info((Object)("ObjectDataConverter\u7ec4\u5305\u5f00\u59cb,compositeData is " + compositeData));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("object is " + outputDataType.getName()));
            log.debug((Object)("config is" + config.getClsName()));
            this.printConfig(config);
        }
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Class<?> fieldType = field.getType();
            String fieldName = field.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("ObjectDataConverter\u7ec4\u5305: field is : " + fieldName + " fieldType is :" + fieldType.getName()));
            }
            this.converterJavaBean(compositeData, cbo, field, config);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("ObjectDataConverter \u7ec4\u5305  field \u7ed3\u675f\uff0cfield is\uff1a " + fieldName));
        }
    }

    private void converterJavaBean(CompositeData cData, Object cbo, Field field, ObjectDataConfig dataConfig) {
        FieldConverter fieldConverter = new FieldConverter();
        List configList = dataConfig.getChildren();
        String fieldName = field.getName();
        String fieldTypeName = field.getType().getName();
        HashMap<String, ObjectDataConfig> dataConfigCache = new HashMap<String, ObjectDataConfig>();
        for (int i = 0; i < configList.size(); ++i) {
            ObjectDataConfig config = (ObjectDataConfig)configList.get(i);
            dataConfigCache.put(config.getClsName(), config);
        }
        AtomData comChild = cData.getObject(fieldName);
        if (comChild instanceof CompositeData) {
            CompositeData comData = (CompositeData)comChild;
            ObjectDataConfig childConfig = (ObjectDataConfig)dataConfigCache.get(fieldTypeName);
            Object object = this.createObject(comData, childConfig);
            try {
                field.set(cbo, object);
            }
            catch (IllegalArgumentException e) {
                TranReflectException te = new TranReflectException("\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", e);
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", (Throwable)te);
                }
                throw te;
            }
            catch (IllegalAccessException e) {
                TranReflectException te = new TranReflectException("\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", e);
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", (Throwable)te);
                }
                throw te;
            }
        }
        if (comChild instanceof com.dc.eai.data.Array) {
            com.dc.eai.data.Array comArray = cData.getArray(fieldName);
            String arrayName = fieldTypeName.substring(2, fieldTypeName.length() - 1);
            ObjectDataConfig childConfig = (ObjectDataConfig)dataConfigCache.get(arrayName);
            Object objectArray = this.createObjectArray(comArray, childConfig);
            Class<?> type = field.getType();
            try {
                field.set(cbo, objectArray);
            }
            catch (IllegalArgumentException e) {
                TranReflectException te = new TranReflectException("\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", e);
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", (Throwable)te);
                }
                throw te;
            }
            catch (IllegalAccessException e) {
                TranReflectException te = new TranReflectException("\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", e);
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", (Throwable)te);
                }
                throw te;
            }
        }
        com.dc.eai.data.Field comField = cData.getField(fieldName);
        try {
            Object fieldValue = fieldConverter.setValueByType(comField);
            field.set(cbo, fieldValue);
        }
        catch (IllegalArgumentException e) {
            TranReflectException te = new TranReflectException("\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", (Throwable)te);
            }
            throw te;
        }
        catch (IllegalAccessException e) {
            TranReflectException te = new TranReflectException("\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u65e0\u6cd5\u4e3ajavaBean\u8d4b\u503c", (Throwable)te);
            }
            throw te;
        }
        catch (Exception e) {
            TranReflectException te = new TranReflectException("\u5bf9javaBean\u8d4b\u503c\u65f6\u51fa\u73b0\u5f02\u5e38", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u5bf9javaBean\u8d4b\u503c\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)te);
            }
            throw te;
        }
    }

    private Object createObjectArray(com.dc.eai.data.Array comArray, ObjectDataConfig childArrayConfig) {
        Object object;
        int size = childArrayConfig.size();
        try {
            Class<?> cls = Class.forName(childArrayConfig.getClsName());
            object = Array.newInstance(cls, size);
        }
        catch (ClassNotFoundException e) {
            TranReflectException te = new TranReflectException("\u65e0\u6cd5\u4ece\u7ed9\u5b9a\u7684name: " + childArrayConfig.getClsName() + "\u83b7\u5f97Class", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u83b7\u5f97Class", (Throwable)te);
            }
            throw te;
        }
        ObjectDataConfig config = (ObjectDataConfig)childArrayConfig.getChildren().get(0);
        for (int i = 0; i < size; ++i) {
            AtomData arrayChild = comArray.getObject(i);
            if (arrayChild instanceof com.dc.eai.data.Array) {
                com.dc.eai.data.Array array = (com.dc.eai.data.Array)arrayChild;
                ObjectDataConfig arrayConfig = (ObjectDataConfig)childArrayConfig.getChildren().get(i);
                Object value = this.createObjectArray(array, arrayConfig);
                Array.set(object, i, value);
                continue;
            }
            Object value = this.createObject((CompositeData)arrayChild, config);
            Array.set(object, i, value);
        }
        return object;
    }

    private Object createObject(CompositeData comData, ObjectDataConfig childConfig) {
        Object object = null;
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("\u5f00\u59cb\u83b7\u53d6\u7c7b\u7684\u5b9e\u4f8b" + childConfig.getClsName()));
            }
            object = Class.forName(childConfig.getClsName()).newInstance();
        }
        catch (ClassNotFoundException e) {
            TranReflectException te = new TranReflectException("\u65e0\u6cd5\u4ece\u7ed9\u5b9a\u7684name: " + childConfig.getClsName() + "\u83b7\u5f97Class", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u83b7\u5f97Class", (Throwable)te);
            }
            throw te;
        }
        catch (InstantiationException e) {
            TranReflectException te = new TranReflectException("\u65e0\u6cd5\u4ece\u7ed9\u5b9a\u7684name: " + childConfig.getClsName() + "\u83b7\u5f97Class", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u83b7\u5f97Class", (Throwable)te);
            }
            throw te;
        }
        catch (IllegalAccessException e) {
            TranReflectException te = new TranReflectException("\u65e0\u6cd5\u4ece\u7ed9\u5b9a\u7684name: " + childConfig.getClsName() + "\u83b7\u5f97Class", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u83b7\u5f97Class", (Throwable)te);
            }
            throw te;
        }
        catch (Exception e) {
            TranReflectException te = new TranReflectException("\u65e0\u6cd5\u4ece\u7ed9\u5b9a\u7684name: " + childConfig.getClsName() + "\u83b7\u5f97Class", e);
            if (log.isErrorEnabled()) {
                log.error((Object)"\u83b7\u5f97Class", (Throwable)te);
            }
            throw te;
        }
        if (object == null) {
            TranReflectException te = new TranReflectException("\u65e0\u6cd5\u4ece\u7ed9\u5b9a\u7684name\uff1a" + childConfig.getClsName() + "\u83b7\u5f97object.");
            if (log.isErrorEnabled()) {
                log.error((Object)"\u83b7\u5f97object", (Throwable)te);
            }
            throw te;
        }
        this.pack(object, comData, childConfig);
        if (log.isInfoEnabled()) {
            log.info((Object)("\u83b7\u53d6\u7c7b\u7684\u5b9e\u4f8b\u5b8c\u6210" + childConfig.getClsName()));
        }
        return object;
    }

    public void unPack(Object cbo, CompositeData compositeData, ObjectDataConfig config) {
        Class<?> inputDataType = cbo.getClass();
        Field[] fields = inputDataType.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Class<?> fieldType = field.getType();
            String fieldName = field.getName();
            if (log.isInfoEnabled()) {
                log.info((Object)("ObjectDataConverter\u62c6\u5305\u5f00\u59cb\uff0cjavaBean Name is\uff1a " + cbo.getClass().getName()));
            }
            Object fieldValue = null;
            try {
                fieldValue = field.get(cbo);
            }
            catch (IllegalArgumentException e) {
                TranReflectException te = new TranReflectException("\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6javaBean\u7684\u503c");
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6javaBean\u7684\u503c", (Throwable)te);
                }
                throw te;
            }
            catch (IllegalAccessException e) {
                TranReflectException te = new TranReflectException("\u65e0\u6cd5\u83b7\u53d6javaBean\u7684\u503c");
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u65e0\u6cd5\u83b7\u53d6javaBean\u7684\u503c", (Throwable)te);
                }
                throw te;
            }
            this.converterComposite(compositeData, fieldType, fieldName, fieldValue, config);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("ObjectDataConverter\u62c6\u5305\u7ed3\u675f,CompositeData is\uff1a " + compositeData));
        }
    }

    private void converterComposite(CompositeData cData, Class fieldType, String fieldName, Object fieldValue, ObjectDataConfig dataConfig) {
        List configList = dataConfig.getChildren();
        FieldConverter fieldConverter = new FieldConverter();
        com.dc.eai.data.Field field = fieldConverter.createFieldByType(fieldType, fieldValue);
        if (field != null) {
            cData.addField(fieldName, field);
        } else {
            for (int i = 0; i < configList.size(); ++i) {
                ObjectDataConfig childConfig = (ObjectDataConfig)configList.get(i);
                String objectName = childConfig.getClsName();
                if (!fieldName.equals(objectName)) continue;
                if (childConfig.size() > 0) {
                    com.dc.eai.data.Array array = this.createArray(fieldValue, childConfig);
                    cData.addArray(fieldName, array);
                    continue;
                }
                CompositeData childComData = this.createCompositeData(fieldValue, childConfig);
                cData.addStruct(fieldName, childComData);
            }
        }
    }

    private com.dc.eai.data.Array createArray(Object fieldValue, ObjectDataConfig childConfig) {
        List configList = childConfig.getChildren();
        Object[] fieldValue_ = (Object[])fieldValue;
        com.dc.eai.data.Array array = new com.dc.eai.data.Array(true);
        for (int i = 0; i < childConfig.size(); ++i) {
            Object child = fieldValue_[i];
            for (int j = 0; j < configList.size(); ++j) {
                ObjectDataConfig childArrayConfig = (ObjectDataConfig)configList.get(j);
                if (childArrayConfig.size() > 0) {
                    com.dc.eai.data.Array arrayChild = this.createArray(child, childArrayConfig);
                    array.addArray(arrayChild);
                    continue;
                }
                CompositeData childArrayData = this.createCompositeData(child, childArrayConfig);
                array.addStruct(childArrayData);
            }
        }
        return array;
    }

    private CompositeData createCompositeData(Object fieldValue, ObjectDataConfig dataConfig) {
        CompositeData comData = new CompositeData(true);
        this.unPack(fieldValue, comData, dataConfig);
        return comData;
    }

    private void printConfig(ObjectDataConfig config) {
        List list = config.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            ObjectDataConfig childConfig = (ObjectDataConfig)list.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)(config.getClsName() + "'s child  config[ " + i + "] is " + childConfig.getClsName()));
            }
            if (childConfig.size() <= 0) continue;
            this.printConfig(childConfig);
        }
    }
}

