/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.pack.objectdata;

import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import java.awt.Image;

public class FieldConverter {
    public Field createFieldByType(Class CBOFieldType, Object fieldValue) {
        String objectType = "";
        if (CBOFieldType == String.class) {
            objectType = "string";
            Field field = this.createStringField(fieldValue);
            return field;
        }
        if (CBOFieldType == Image.class) {
            objectType = "image";
            Field field = this.createImageField(fieldValue);
            return field;
        }
        if (CBOFieldType == Byte.class) {
            objectType = "byte";
            Field field = this.createByteField(fieldValue);
            return field;
        }
        if (CBOFieldType == Short.class) {
            objectType = "short";
            Field field = this.createShortField(fieldValue);
            return field;
        }
        if (CBOFieldType == Integer.TYPE) {
            objectType = "int";
            Field field = this.createIntField(fieldValue);
            return field;
        }
        if (CBOFieldType == Long.TYPE) {
            objectType = "long";
            Field field = this.createLongField(fieldValue);
            return field;
        }
        if (CBOFieldType == Float.TYPE) {
            objectType = "float";
            Field field = this.createFloatField(fieldValue);
            return field;
        }
        if (CBOFieldType == Double.TYPE) {
            objectType = "double";
            Field field = this.createDoubleField(fieldValue);
            return field;
        }
        return null;
    }

    private Field createStringField(Object fieldValue) {
        FieldAttr attr = new FieldAttr(FieldType.FIELD_STRING, ((String)fieldValue).length());
        Field field = new Field(attr);
        field.setValue((String)fieldValue);
        return field;
    }

    private Field createImageField(Object fieldValue) {
        FieldAttr attr = new FieldAttr(FieldType.FIELD_IMAGE, ((byte[])fieldValue).length);
        Field field = new Field(attr);
        field.setValue((byte[])fieldValue);
        return field;
    }

    private Field createByteField(Object fieldValue) {
        FieldAttr attr = new FieldAttr(FieldType.FIELD_BYTE, 0);
        Field field = new Field(attr);
        field.setValue(((Number)fieldValue).byteValue());
        return field;
    }

    private Field createShortField(Object fieldValue) {
        FieldAttr attr = new FieldAttr(FieldType.FIELD_SHORT, 0);
        Field field = new Field(attr);
        field.setValue(((Number)fieldValue).shortValue());
        return field;
    }

    private Field createIntField(Object fieldValue) {
        FieldAttr attr = new FieldAttr(FieldType.FIELD_INT, 0);
        Field field = new Field(attr);
        field.setValue(((Number)fieldValue).intValue());
        return field;
    }

    private Field createLongField(Object fieldValue) {
        FieldAttr attr = new FieldAttr(FieldType.FIELD_LONG, 0);
        Field field = new Field(attr);
        field.setValue(((Number)fieldValue).longValue());
        return field;
    }

    private Field createFloatField(Object fieldValue) {
        FieldAttr attr = new FieldAttr(FieldType.FIELD_FLOAT, 0);
        Field field = new Field(attr);
        field.setValue(((Number)fieldValue).floatValue());
        return field;
    }

    private Field createDoubleField(Object fieldValue) {
        FieldAttr attr = new FieldAttr(FieldType.FIELD_DOUBLE, 0);
        Field field = new Field(attr);
        field.setValue(((Number)fieldValue).doubleValue());
        return field;
    }

    public Object setValueByType(Field comField) {
        String fieldName = comField.getFieldType().getName();
        if (fieldName.equals("string")) {
            String value = comField.strValue();
            return value;
        }
        if (fieldName.equals("image")) {
            byte[] value = comField.imageValue();
            return value;
        }
        if (fieldName.equals("byte")) {
            byte value = comField.byteValue();
            return new Byte(value);
        }
        if (fieldName.equals("short")) {
            short value = comField.shortValue();
            return new Integer(value);
        }
        if (fieldName.equals("int")) {
            int value = comField.intValue();
            return new Integer(value);
        }
        if (fieldName.equals("long")) {
            long value = comField.longValue();
            return new Long(value);
        }
        if (fieldName.equals("float")) {
            float value = comField.floatValue();
            return new Float(value);
        }
        if (fieldName.equals("double")) {
            double value = comField.doubleValue();
            return new Double(value);
        }
        return null;
    }
}

