/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.pack.hostout;

import com.dc.eai.config.IOConfig;
import com.dc.eai.conv.DataConvertException;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.PackageModeFactory;
import com.dc.eai.conv.Packet;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.eai.pack.hostout.FormFactory;
import com.dc.util.pack.PackUtils;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostoutPackageConverter
implements PackageConverter {
    private static final String OPM_DATA_COMPRESS = "OPM_DATA_COMPRESS";
    private static Log log = LogFactory.getLog((Class)HostoutPackageConverter.class);
    private String formValueMode;
    private PackageConverter converter;
    private ThreadLocal forms = new ThreadLocal();

    public void setConverter(PackageConverter converter) {
        this.converter = converter;
    }

    private void setForms(ArrayList formlist) {
        this.forms.set(formlist);
    }

    private ArrayList getForms() {
        return (ArrayList)this.forms.get();
    }

    protected RuntimeException PacketLenOverflowException(Packet packet, int length) {
        DataConvertException e = new DataConvertException("PacketLenOverflow");
        e.addScene("Packet", packet);
        e.addScene("Current", packet.getOffset());
        e.addScene("RequestLen", length);
        return e;
    }

    private InputPacket uncompress(InputPacket source, int length) {
        byte[] newBuff = new byte[]{};
        byte[] buff = source.getBuff();
        int newBuffOffset = 0;
        int size = 0;
        int buffOffset = source.getOffset();
        int formLength = buffOffset + length;
        while (buffOffset < formLength) {
            byte ch = buff[buffOffset];
            if (ch == 30) {
                byte byt = buff[buffOffset + 1];
                int count = buff[buffOffset + 2];
                byte[] tempBuff = new byte[size += count];
                System.arraycopy(newBuff, 0, tempBuff, 0, newBuff.length);
                newBuff = tempBuff;
                for (int i = 0; i < count; ++i) {
                    newBuff[newBuffOffset++] = byt;
                }
                buffOffset += 3;
                source.advance(3);
                continue;
            }
            byte[] tempBuff = new byte[++size];
            System.arraycopy(newBuff, 0, tempBuff, 0, newBuff.length);
            newBuff = tempBuff;
            newBuff[newBuffOffset] = buff[buffOffset];
            ++newBuffOffset;
            ++buffOffset;
            source.advance(1);
        }
        return new InputPacket(newBuff);
    }

    public void pack(OutputPacket packet, CompositeData data, IOConfig config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u4e3b\u673a\u8f93\u51fa\u62a5\u6587\u7684\u62a5\u6587\u4f53\u7ec4\u5305\u5f00\u59cb");
        }
        if (this.converter == null) {
            this.converter = PackageModeFactory.getFactory().getPackageMode(this.formValueMode);
        }
        ArrayList formids = this.getForms();
        for (int i = 0; i < formids.size(); ++i) {
            String formId = (String)formids.get(i);
            IOConfig form = FormFactory.getInstance().getForm(formId);
            CompositeData formdata = data.getStruct(formId);
            if (formdata == null) break;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Form:" + formId + "\u7ec4\u5305\u5f00\u59cb"));
            }
            if (Boolean.valueOf(form.getAttribute("convert")).booleanValue()) {
                int oldOffset = packet.getOffset();
                packet.ensure(2);
                PackUtils.put_int16(packet.getBuff(), packet.getOffset(), 0);
                packet.advance(2);
                packet.ensure(8);
                PackUtils.put_string(packet.getBuff(), packet.getOffset(), formId, 8, "EBCDIC");
                packet.advance(8);
                this.converter.pack(packet, formdata, form);
                PackUtils.put_int16(packet.getBuff(), oldOffset, packet.getOffset() - oldOffset);
            } else {
                Field unconvertedForm = data.getField(formId);
                if (unconvertedForm == null) continue;
                int length = unconvertedForm.imageValue().length;
                packet.ensure(length);
                System.arraycopy(unconvertedForm.imageValue(), 0, packet.getBuff(), packet.getOffset(), length);
                packet.advance(length);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Form:" + formId + "\u7ec4\u5305\u6210\u529f"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u5165EndOfForm\u5f00\u59cb");
        }
        byte[] endForm = new byte[]{0, 11, -58, -58, -58, -58, -58, -58, -58, -58, 64};
        packet.ensure(11);
        System.arraycopy(endForm, 0, packet.getBuff(), packet.getOffset(), 11);
        packet.advance(11);
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u7ec4\u5165EndOfForm\u6210\u529f");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u4e3b\u673a\u8f93\u51fa\u62a5\u6587\u7684\u62a5\u6587\u4f53\u7ec4\u5305\u6210\u529f ");
        }
    }

    public void unpack(InputPacket packet, CompositeData data, IOConfig config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"hostout\u62a5\u6587\u62c6\u5305");
        }
        ArrayList<String> forms = new ArrayList<String>();
        if (this.converter == null) {
            this.converter = PackageModeFactory.getFactory().getPackageMode(this.formValueMode);
        }
        boolean endOfPacket = false;
        while (!endOfPacket) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u62c6Form\u7684\u957f\u5ea6\u5f00\u59cb");
            }
            if (packet.exceed(2)) {
                throw this.PacketLenOverflowException(packet, 2);
            }
            int length = PackUtils.get_int16(packet.getBuff(), packet.getOffset()) - 10;
            packet.advance(2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5f97\u5230Form\u7684\u957f\u5ea6\u6210\u529f\uff0c\u4e3a\uff1a" + (length + 10)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u62c6Form\u7684FormID\u5f00\u59cb");
            }
            if (packet.exceed(8)) {
                throw this.PacketLenOverflowException(packet, 8);
            }
            String formId = PackUtils.get_string(packet.getBuff(), packet.getOffset(), 8, "EBCDIC", ' ', true);
            forms.add(formId);
            packet.advance(8);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u5f97\u5230Form\u7684FormID\u6210\u529f\uff0c\u4e3a\uff1a" + formId));
            }
            if (!formId.equals("FFFFFFFF")) {
                IOConfig formconfig;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u62c6Form:" + formId + "\u7684\u6570\u636e\u5185\u5bb9\u5f00\u59cb"));
                }
                if (Boolean.valueOf((formconfig = FormFactory.getInstance().getForm(formId)).getAttribute("convert")).booleanValue()) {
                    InputPacket formValue;
                    Field dataCompress = data.getField(OPM_DATA_COMPRESS);
                    if (dataCompress.strValue().equals("1")) {
                        formValue = this.uncompress(packet, length);
                    } else {
                        byte[] buff = packet.getBuff();
                        byte[] newBuff = new byte[length];
                        System.arraycopy(buff, packet.getOffset(), newBuff, 0, length);
                        formValue = new InputPacket(newBuff);
                        packet.advance(length);
                    }
                    CompositeData formStruct = new CompositeData();
                    this.converter.unpack(formValue, formStruct, formconfig);
                    data.addStruct(formId, formStruct);
                } else {
                    byte[] buff = packet.getBuff();
                    byte[] newBuff = new byte[length + 10];
                    System.arraycopy(buff, packet.getOffset() - 10, newBuff, 0, length + 10);
                    packet.advance(length);
                    InputPacket formPacket = new InputPacket(newBuff);
                    FieldAttr formAttr = new FieldAttr(FieldType.FIELD_IMAGE, length + 10);
                    Field unconvertedForm = new Field(formAttr);
                    unconvertedForm.setValue(newBuff);
                    data.addField(formId, unconvertedForm);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("\u62c6Form:" + formId + "\u6210\u529f"));
                continue;
            }
            packet.advance(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8be5Form\u4e3aEndOfForm");
            }
            endOfPacket = true;
        }
        this.setForms(forms);
        if (log.isDebugEnabled()) {
            log.debug((Object)"******** \u4e3b\u673a\u8f93\u51fa\u62a5\u6587\u7684\u62a5\u6587\u4f53\u62c6\u5305\u6210\u529f");
        }
    }
}

