/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.pack;

import com.dc.eai.config.ArrayIOConfig;
import com.dc.eai.config.AtomDataIOConfig;
import com.dc.eai.config.FieldIOConfig;
import com.dc.eai.config.IOConfig;
import com.dc.eai.config.StructIOConfig;
import com.dc.eai.conv.FieldConverter;
import com.dc.eai.conv.FieldConverterFactory;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.conv.Packet;
import com.dc.eai.conv.PacketException;
import com.dc.eai.data.Array;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.expr.CompositeDataExprData;
import com.dc.expr.Exp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraditionalPackageConverter
implements PackageConverter {
    private Log log = LogFactory.getLog((Class)TraditionalPackageConverter.class);

    public void unpack(InputPacket packet, CompositeData data, IOConfig config) {
        this.pack_unpack(packet, data, config, false);
    }

    public void pack(OutputPacket packet, CompositeData data, IOConfig config) {
        this.pack_unpack(packet, data, config, true);
    }

    void pack_unpack(Packet packet, CompositeData data, IOConfig config, boolean is_pack) throws PacketException {
        int count = config.size();
        for (int i = 0; i < count; ++i) {
            Object item = config.getObject(i);
            if (item instanceof FieldIOConfig) {
                FieldIOConfig field_config = (FieldIOConfig)item;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("name: " + field_config.getName()));
                }
                this.pack_unpack_field(packet, data, field_config, is_pack);
                continue;
            }
            if (item instanceof ArrayIOConfig) {
                Exp option;
                ArrayIOConfig array_config = (ArrayIOConfig)item;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("name: " + array_config.getName()));
                }
                CompositeDataExprData expr_data = new CompositeDataExprData(data);
                Exp group_option_exp = array_config.getCondition();
                if (group_option_exp != null && !(option = group_option_exp.eval(expr_data)).boolValue()) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)"\u8df3\u8fc7\u8be5\u7ec4");
                    continue;
                }
                this.pack_unpack_array(packet, data, array_config, is_pack);
                continue;
            }
            PacketException pe = new PacketException("PacketConfig_ElementError");
            throw pe;
        }
    }

    void pack_unpack_field(Packet packet, CompositeData data, FieldIOConfig config, boolean is_pack) {
        Exp option;
        String name = config.getName();
        String mode = config.getStoreMode();
        FieldConverter fc = FieldConverterFactory.getInstance().getFieldConverter(mode);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("name: " + name));
        }
        CompositeDataExprData expr_data = new CompositeDataExprData(data);
        Exp option_exp = config.getOption();
        if (option_exp != null && !(option = option_exp.eval(expr_data)).boolValue()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"\u8df3\u8fc7\u8be5\u57df");
            }
            return;
        }
        if (is_pack) {
            Field value = data.getField(name);
            if (value == null) {
                if (config.isRequired()) {
                    PacketException pe = new PacketException("FieldNotExist");
                    pe.addScene("name", name);
                    throw pe;
                }
                value = new Field(new FieldAttr(config.getType(), config.getLength(), config.getScale()));
                data.addField(config.getName(), value);
                fc.pack((OutputPacket)packet, data, config);
            } else {
                fc.pack((OutputPacket)packet, data, config);
            }
        } else {
            fc.unpack((InputPacket)packet, data, config);
        }
    }

    void pack_unpack_array(Packet packet, CompositeData data, ArrayIOConfig config, boolean is_pack) {
        boolean flag = true;
        boolean step = true;
        CompositeDataExprData expr_data = new CompositeDataExprData(data);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5f00\u59cb\u62c6\u7ec4");
        }
        int recycle = 0;
        Exp size_exp = config.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"\u5f00\u59cb\u83b7\u53d6\u6570\u7ec4\u957f\u5ea6");
        }
        if (size_exp != null) {
            Exp option = size_exp.eval(expr_data);
            recycle = option.intValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("\u6570\u7ec4\u957f\u5ea6\uff1a" + recycle));
            }
        }
        if (!config.isVertical()) {
            Array array;
            if (!is_pack) {
                array = new Array();
                data.addArray(config.getName(), array);
            } else {
                array = data.getArray(config.getName());
            }
            for (int i = 0; i < recycle; ++i) {
                AtomDataIOConfig item_config;
                CompositeData inArray_data = array.getStruct(i);
                if (inArray_data == null) {
                    inArray_data = new CompositeData();
                    array.addStruct(inArray_data);
                }
                if ((item_config = config.getConfig()) instanceof FieldIOConfig) {
                    FieldIOConfig field_config = (FieldIOConfig)item_config;
                    this.pack_unpack_field(packet, inArray_data, field_config, is_pack);
                    continue;
                }
                if (!(item_config instanceof StructIOConfig)) continue;
                StructIOConfig struct_config = (StructIOConfig)item_config;
                for (int k = 0; k < struct_config.getSize(); ++k) {
                    AtomDataIOConfig item = struct_config.getItem(k);
                    if (!(item instanceof FieldIOConfig)) {
                        PacketException pe = new PacketException("NestedGroupErr");
                        pe.addScene("name", config.getName() + "." + ((StructIOConfig)item).getName());
                        throw pe;
                    }
                    FieldIOConfig field_config = (FieldIOConfig)item;
                    this.pack_unpack_field(packet, inArray_data, field_config, is_pack);
                }
            }
        } else {
            Array array;
            AtomDataIOConfig item_config = config.getConfig();
            int item_size = 0;
            if (item_config instanceof StructIOConfig) {
                StructIOConfig struct_config = (StructIOConfig)item_config;
                item_size = struct_config.getSize();
            } else {
                item_size = 1;
            }
            if (!is_pack) {
                array = new Array();
                data.addArray(config.getName(), array);
            } else {
                array = data.getArray(config.getName());
            }
            for (int i = 0; i < item_size; ++i) {
                for (int k = 0; k < recycle; ++k) {
                    CompositeData struct_data = array.getStruct(k);
                    if (struct_data == null) {
                        struct_data = new CompositeData();
                        array.addStruct(struct_data);
                    }
                    AtomDataIOConfig itemconfig = config.getConfig();
                    if (item_config instanceof FieldIOConfig) {
                        FieldIOConfig field_config = (FieldIOConfig)itemconfig;
                        this.pack_unpack_field(packet, struct_data, field_config, is_pack);
                        continue;
                    }
                    if (!(itemconfig instanceof StructIOConfig)) continue;
                    StructIOConfig struct_config = (StructIOConfig)itemconfig;
                    AtomDataIOConfig item = struct_config.getItem(i);
                    if (item instanceof FieldIOConfig) {
                        FieldIOConfig field_config = (FieldIOConfig)item;
                        this.pack_unpack_field(packet, struct_data, field_config, is_pack);
                        continue;
                    }
                    PacketException pe = new PacketException("NestedGroupErr");
                    pe.addScene("name", config.getName() + "." + ((StructIOConfig)item).getName());
                    throw pe;
                }
            }
        }
    }
}

