/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.pack;

import com.dc.eai.config.IOConfig;
import com.dc.eai.conv.InputPacket;
import com.dc.eai.conv.OutputPacket;
import com.dc.eai.conv.PackageConverter;
import com.dc.eai.data.Array;
import com.dc.eai.data.AtomData;
import com.dc.eai.data.CompositeData;
import com.dc.eai.data.Field;
import com.dc.eai.data.FieldAttr;
import com.dc.eai.data.FieldType;
import com.dc.util.NumberUtils;
import com.dc.util.xml.CommonData;
import com.dc.util.xml.XMLCommonData;
import com.dc.util.xml.store.XMLoader;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;

public class StandardPackageConverter
implements PackageConverter {
    public static final String SYS_HEADER_TAG = "sys-header";
    public static final String APP_HEADER_TAG = "app-header";
    public static final String BODY_TAG = "body";
    public static final String DATA_TAG = "data";
    public static final String FIELD_TAG = "field";
    public static final String ARRAY_TAG = "array";
    public static final String STRUCT_TAG = "struct";
    public static final String ROOT_TAG = "service";

    private static int getLength(CommonData commonData) {
        int length;
        if (commonData.getAttribute("length") == null) {
            length = 0;
        } else {
            try {
                length = Integer.parseInt((String)commonData.getAttribute("length"));
            }
            catch (NumberFormatException e) {
                length = 0;
            }
        }
        return length;
    }

    private static int getScale(CommonData commonData) {
        int scale;
        if (commonData.getAttribute("scale") == null) {
            scale = 0;
        } else {
            try {
                scale = Integer.parseInt((String)commonData.getAttribute("scale"));
            }
            catch (NumberFormatException e) {
                scale = 0;
            }
        }
        return scale;
    }

    private static AtomData populateData(CommonData commonData) {
        String name = commonData.getName();
        if (name.equals(FIELD_TAG)) {
            String type = (String)commonData.getAttribute("type");
            FieldType fieldType = FieldType.getEnum(type);
            int length = StandardPackageConverter.getLength(commonData);
            int scale = StandardPackageConverter.getScale(commonData);
            FieldAttr fieldAttr = new FieldAttr(fieldType, length, scale);
            Field field = new Field(fieldAttr);
            String strValue = (String)commonData.getValue();
            if (fieldType == FieldType.FIELD_BYTE) {
                byte value = (byte)NumberUtils.intValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_DOUBLE) {
                double value = NumberUtils.doubleValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_FLOAT) {
                float value = (float)NumberUtils.doubleValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_INT) {
                int value = NumberUtils.intValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_INT24 || fieldType == FieldType.FIELD_LONG) {
                long value = NumberUtils.longValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_SHORT) {
                short value = (short)NumberUtils.intValue(strValue);
                field.setValue(value);
            } else if (fieldType == FieldType.FIELD_IMAGE) {
                byte[] value = strValue.getBytes();
                field.setValue(value);
            } else {
                field.setValue(strValue);
            }
            return field;
        }
        if (name.equals(ARRAY_TAG)) {
            Array array = new Array();
            int count = commonData.childCount();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    CommonData childCommonData = commonData.getChild(i);
                    String childName = childCommonData.getName();
                    if (childName.equals(STRUCT_TAG)) {
                        array.addStruct((CompositeData)StandardPackageConverter.populateData(childCommonData));
                        continue;
                    }
                    if (childName.equals(ARRAY_TAG)) {
                        array.addArray((Array)StandardPackageConverter.populateData(childCommonData));
                        continue;
                    }
                    if (!childName.equals(FIELD_TAG)) continue;
                    array.addField((Field)StandardPackageConverter.populateData(childCommonData));
                }
            }
            return array;
        }
        CompositeData struct = new CompositeData();
        int count = commonData.childCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                CommonData childCommonData = commonData.getChild(i);
                struct = StandardPackageConverter.toCompositeData(childCommonData, struct);
            }
        }
        return struct;
    }

    public static CompositeData toCompositeData(CommonData commonData, CompositeData data) {
        String tagname = commonData.getName();
        if (tagname.equals(DATA_TAG)) {
            String dataName = (String)commonData.getAttribute("name");
            int count = commonData.childCount();
            for (int i = 0; i < count; ++i) {
                CommonData child = commonData.getChild(i);
                if (!child.getName().equals("attribute-list")) {
                    data.addObject(dataName, StandardPackageConverter.populateData(child));
                    continue;
                }
                int attr_count = child.childCount();
                for (int j = 0; j < attr_count; ++j) {
                    CommonData attr = child.getChild(j);
                    data.getObject(dataName).setAttribute((String)attr.getAttribute("name"), (String)attr.getValue());
                }
            }
        }
        return data;
    }

    public static CommonData toCommonData(CommonData commonData, CompositeData data) {
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            Iterator attrIter;
            String name = (String)iter.next();
            AtomData atomData = data.getObject(name);
            if (atomData == null) continue;
            CommonData dataElement = commonData.addChild(DATA_TAG);
            if (atomData.isField()) {
                Field field = (Field)atomData;
                FieldAttr fieldAttr = field.getAttr();
                FieldType fieldType = fieldAttr.getType();
                int length = fieldAttr.getLength();
                int scale = fieldAttr.getScale();
                dataElement.setAttribute("name", name);
                CommonData fieldElement = dataElement.addChild(FIELD_TAG);
                fieldElement.setAttribute("type", fieldType.getName());
                fieldElement.setAttribute("length", "" + length);
                fieldElement.setAttribute("scale", "" + scale);
                if (fieldType == FieldType.FIELD_IMAGE) {
                    fieldElement.setValue(new String((byte[])field.getValue()));
                } else {
                    fieldElement.setValue("" + field.getValue());
                }
            } else if (atomData.isArray()) {
                dataElement.setAttribute("name", name);
                Array array = (Array)atomData;
                StandardPackageConverter.toCommonData(dataElement, array);
            } else {
                CompositeData struct = (CompositeData)atomData;
                dataElement.setAttribute("name", name);
                CommonData structElement = dataElement.addChild(STRUCT_TAG);
                StandardPackageConverter.toCommonData(structElement, struct);
            }
            if (!(attrIter = atomData.attributeIterator()).hasNext()) continue;
            CommonData attrList = dataElement.addChild("attribute-list");
            while (attrIter.hasNext()) {
                String attrName = (String)attrIter.next();
                CommonData attrData = attrList.addChild("attribute");
                attrData.setAttribute("name", attrName);
                attrData.setValue(atomData.getAttribute(attrName));
            }
        }
        return commonData;
    }

    public static CommonData toCommonData(CompositeData data) {
        XMLCommonData commonData = new XMLCommonData();
        CommonData root = commonData.addChild(ROOT_TAG);
        CommonData body = root.addChild(BODY_TAG);
        if (data != null) {
            StandardPackageConverter.toCommonData(body, data);
        }
        return commonData;
    }

    private static void toCommonData(CommonData commonData, Array array) {
        CommonData arrayElement = commonData.addChild(ARRAY_TAG);
        for (int i = 0; i < array.size(); ++i) {
            AtomData arrayItem = array.getObject(i);
            if (arrayItem.isField()) {
                Field field = (Field)arrayItem;
                FieldAttr fieldAttr = field.getAttr();
                FieldType fieldType = fieldAttr.getType();
                int length = fieldAttr.getLength();
                int scale = fieldAttr.getScale();
                CommonData dataElement = arrayElement.addChild(DATA_TAG);
                dataElement.setAttribute("name", "");
                CommonData fieldElement = dataElement.addChild(FIELD_TAG);
                fieldElement.setAttribute("type", fieldType.getName());
                fieldElement.setAttribute("length", "" + length);
                fieldElement.setAttribute("scale", "" + scale);
                fieldElement.setValue("" + field.getValue());
                continue;
            }
            if (arrayItem.isArray()) {
                StandardPackageConverter.toCommonData(arrayElement, (Array)arrayItem);
                continue;
            }
            CommonData struct = arrayElement.addChild(STRUCT_TAG);
            StandardPackageConverter.toCommonData(struct, (CompositeData)arrayItem);
        }
    }

    public static void CommonDatatoCompositeData(CommonData root, CompositeData data) {
        if (root.childCount() == 1) {
            int i;
            int count;
            CommonData realroot = root.getChild(0);
            CommonData commonData = realroot.getChild(SYS_HEADER_TAG);
            if (commonData != null) {
                count = commonData.childCount();
                for (i = 0; i < count; ++i) {
                    CommonData sys_header = commonData.getChild(i);
                    if (sys_header == null) continue;
                    StandardPackageConverter.toCompositeData(sys_header, data);
                }
            }
            if ((commonData = realroot.getChild(APP_HEADER_TAG)) != null) {
                count = commonData.childCount();
                for (i = 0; i < count; ++i) {
                    CommonData app_header = commonData.getChild(i);
                    if (app_header == null) continue;
                    StandardPackageConverter.toCompositeData(app_header, data);
                }
            }
            if ((commonData = realroot.getChild(BODY_TAG)) != null) {
                count = commonData.childCount();
                for (i = 0; i < count; ++i) {
                    CommonData body = commonData.getChild(i);
                    if (body == null) continue;
                    StandardPackageConverter.toCompositeData(body, data);
                }
            }
        }
    }

    public void unpack(InputPacket packet, CompositeData data, IOConfig config) {
        XMLCommonData commonData = new XMLCommonData();
        byte[] xmlData = packet.getBuff();
        packet.advance(packet.getLength());
        XMLoader.load((CommonData)commonData, xmlData);
        StandardPackageConverter.CommonDatatoCompositeData(commonData, data);
    }

    public void pack(OutputPacket packet, CompositeData data, IOConfig config) {
        CommonData commonData = new XMLCommonData();
        commonData = StandardPackageConverter.toCommonData(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLoader.store(commonData, out);
        byte[] xmlData = out.toByteArray();
        packet.ensure(packet.getOffset() + xmlData.length);
        System.arraycopy(xmlData, 0, packet.getBuff(), packet.getOffset(), xmlData.length);
        packet.advance(xmlData.length);
    }
}

