/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.objects;

import com.dc.eai.objects.CreateStrategy;
import com.dc.eai.objects.ObjectFactory;
import com.dc.exception.BaseException;
import java.util.HashMap;
import java.util.Iterator;

public class DefaultFactory
implements ObjectFactory {
    protected static final String FACTORY_OBJECT_PREFIX = "&";
    HashMap name2creator = new HashMap();

    public Object createObject(Object o) {
        CreateStrategy s = (CreateStrategy)this.name2creator.get(o.toString());
        if (s != null) {
            return s.getObject();
        }
        return null;
    }

    public void addShare(String name, Object share) {
        this.name2creator.put(name.toString(), new ShareStrategy(share));
    }

    public void addNew(String name, Class clazz) {
        this.name2creator.put(name.toString(), new NewStrategy(clazz));
    }

    public void addPtototype(String name, Object clonable) {
        this.name2creator.put(name.toString(), new PrototypeStrategy(clonable));
    }

    public void addBypass(String name, String cursivefactory, String cursiveProduct) {
        this.name2creator.put(name.toString(), new BypassStrategy(FACTORY_OBJECT_PREFIX + cursivefactory, cursiveProduct));
    }

    protected class BypassStrategy
    implements CreateStrategy {
        String factoryName = null;
        String productName = null;

        public BypassStrategy(String factoryName, String productName) {
            this.factoryName = factoryName;
            this.productName = productName;
        }

        public Object getObject() {
            return ((ObjectFactory)DefaultFactory.this.name2creator.get(this.factoryName)).createObject(this.productName);
        }
    }

    protected class SimpleParaStrategy
    implements CreateStrategy {
        Class clazz = null;
        Iterator para = null;

        public void setPara(Iterator para) {
            this.para = para;
        }

        public SimpleParaStrategy(Class clazz) {
            this.clazz = clazz;
        }

        public Object getObject() {
            return null;
        }
    }

    protected static class PrototypeStrategy
    implements CreateStrategy {
        Object prototype = null;

        public PrototypeStrategy(Object prototype) {
            if (!(prototype instanceof Cloneable)) {
                throw new BaseException(prototype.getClass() + " not support clone, so Prototype cannot work");
            }
            this.prototype = (Cloneable)prototype;
        }

        public Object getObject() {
            try {
                return this.prototype.getClass().getMethod("clone", null);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected class NewStrategy
    implements CreateStrategy {
        Class clazz = null;

        public NewStrategy(Class clazz) {
            this.clazz = clazz;
        }

        public Object getObject() {
            try {
                return this.clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected class ShareStrategy
    implements CreateStrategy {
        Object flyweight = null;

        public ShareStrategy(Object flyweight) {
            this.flyweight = flyweight;
        }

        public Object getObject() {
            return this.flyweight;
        }
    }
}

