/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.manage.load;

import com.dc.eai.manage.infobean.ConfInfo;
import com.dc.eai.manage.infobean.FormatUtil;
import com.dc.eai.manage.infobean.StoreInfoBean;
import com.dc.eai.manage.load.ConfInfoLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;

public class HelpLoader {
    private static Log log = LogFactory.getLog((Class)ConfInfoLoader.class);
    private ConfInfo confInfo = null;

    public void load() throws NullPointerException {
        this.confInfo = ConfInfo.getInstance();
        String eai_home = System.getProperty("EAI_HOME");
        if (eai_home == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u73af\u5883\u53d8\u91cf EAI_HOME \u672a\u8bbe\u7f6e");
            }
            throw new NullPointerException();
        }
        this.setHelperInfo(eai_home + "/shared/command.xml");
    }

    private void setHelperInfo(String xmlUrl) {
        block10: {
            try {
                ArrayList<StoreInfoBean> helperList = new ArrayList<StoreInfoBean>();
                Document document = ConfInfoLoader.readDocument(xmlUrl);
                if (document != null) {
                    List featureList = ConfInfoLoader.getChildrenElement(document, "commandlist/command");
                    for (int i = 0; i < featureList.size(); ++i) {
                        Element featureElement = (Element)featureList.get(i);
                        StoreInfoBean storeInfo = new StoreInfoBean();
                        storeInfo.setStoreName(featureElement.getAttributeValue("name"));
                        Element implElement = (Element)featureList.get(i);
                        if (implElement == null) {
                            storeInfo.setStorePath("\u65e0\u5b9e\u73b0\u7c7b");
                        } else {
                            storeInfo.setStorePath(implElement.getAttributeValue("impl-class"));
                        }
                        Element paramElement = featureElement.getChild("param");
                        if (paramElement == null) {
                            storeInfo.setStoreType("\u65e0\u53c2\u6570");
                        } else {
                            storeInfo.setStoreType(paramElement.getText());
                        }
                        Element descElement = featureElement.getChild("description");
                        if (descElement == null) {
                            storeInfo.setStoreDesc("\u65e0\u63cf\u8ff0\u4fe1\u606f");
                        } else {
                            storeInfo.setStoreDesc(descElement.getText());
                        }
                        helperList.add(storeInfo);
                    }
                    this.confInfo.setHelperList(helperList);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)("\u83b7\u53d6\u547d\u4ee4\u7ec4\u4ef6\u5217\u8868\u5931\u8d25 " + e.getMessage()));
            }
        }
    }

    public static void main(String[] args) throws NullPointerException {
        HelpLoader confloader = new HelpLoader();
        confloader.load();
        FormatUtil formatUntil = new FormatUtil();
        ArrayList<String[]> storList = new ArrayList<String[]>();
        String[] title = new String[]{"name", "para", "impl-class", "desc"};
        StoreInfoBean infoBean = null;
        ArrayList list = null;
        list = ConfInfo.getHelperList();
        for (int i = 0; i < list.size(); ++i) {
            infoBean = (StoreInfoBean)list.get(i);
            String[] StrBean = new String[]{infoBean.getStoreName(), infoBean.getStoreType(), infoBean.getStorePath(), infoBean.getStoreDesc()};
            storList.add(StrBean);
        }
        int length = 80;
        int len = 40;
        StringBuffer buffer = new StringBuffer();
        buffer.append(FormatUtil.outTitleCol(title, storList));
        System.out.println(buffer.toString());
    }
}

