/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eai.manage.load;

import com.dc.eai.manage.infobean.BaseServiceInfoBean;
import com.dc.eai.manage.infobean.ConfInfo;
import com.dc.eai.manage.infobean.StoreInfoBean;
import com.dc.eai.manage.infobean.TranInfoBean;
import com.dc.eai.manage.load.InfoLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class ConfInfoLoader
implements InfoLoader {
    private static Log log = LogFactory.getLog((Class)ConfInfoLoader.class);
    private ConfInfo confInfo = null;
    private String eai_home = null;
    private ArrayList componentList = new ArrayList();
    private ArrayList actorInfoList = new ArrayList();
    private ArrayList inteceptorInfoList = new ArrayList();
    private ArrayList transList = new ArrayList();
    private ArrayList serverAdapterList = new ArrayList();

    public static Element getChildElement(Object document, String visitedNodeName) {
        Element visitElement;
        block2: {
            visitElement = null;
            try {
                visitElement = (Element)XPath.selectSingleNode((Object)document, (String)visitedNodeName);
            }
            catch (JDOMException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5b50\u8282\u70b9\u4fe1\u606f\u51fa\u9519 " + e.getMessage()));
            }
        }
        return visitElement;
    }

    public static void main(String[] args) {
        ConfInfoLoader cl = new ConfInfoLoader();
        ConfInfo confInfo = ConfInfo.getInstance();
        cl.load();
        ArrayList al = ConfInfo.getPfSequenceList();
        System.out.println("pfseqsize =" + al.size());
        for (int i = 0; i < al.size(); ++i) {
            StoreInfoBean si = (StoreInfoBean)al.get(i);
            System.out.println("name =" + si.getStoreName());
        }
        ArrayList alactor = ConfInfo.getActorList();
        System.out.println("alactor.size()==" + alactor.size());
        for (int i = 0; i < alactor.size(); ++i) {
            StoreInfoBean si = (StoreInfoBean)alactor.get(i);
            System.out.println("actorname" + si.getStoreName());
            System.out.println("actorDesc" + si.getStoreDesc());
        }
        ArrayList cmp = new ArrayList();
        cmp = ConfInfo.getComponentList();
        System.out.println("cmp.size() =" + cmp.size());
        for (int i = 0; i < cmp.size(); ++i) {
            StoreInfoBean si = (StoreInfoBean)cmp.get(i);
            System.out.println("cmpName =" + si.getStoreName());
            System.out.println("intfaceType= " + si.getStoreType());
            System.out.println("cmpPath= " + si.getStorePath());
            System.out.println("cmpType= " + si.getCmpType());
        }
        ArrayList appseqList = ConfInfo.getAppSequenceList();
        System.out.println("appseqList.size() =" + appseqList.size());
        for (int i = 0; i < appseqList.size(); ++i) {
            StoreInfoBean si = (StoreInfoBean)appseqList.get(i);
            System.out.println("appseq =" + si.getStoreName());
        }
        ArrayList appCmpList = ConfInfo.getAppComponentList();
        System.out.println("appCmpList.size() =" + appCmpList.size());
        for (int i = 0; i < appCmpList.size(); ++i) {
            StoreInfoBean si = (StoreInfoBean)appCmpList.get(i);
            System.out.println("appCmpName =" + si.getStoreName());
        }
        ArrayList interceptorList = ConfInfo.getInterceptorList();
        System.out.println("interceptorList.size() =" + interceptorList.size());
        for (int i = 0; i < interceptorList.size(); ++i) {
            StoreInfoBean si = (StoreInfoBean)interceptorList.get(i);
            System.out.println("interceptorList =" + si.getStoreName());
            System.out.println("getPointCutName =" + si.getPointCutName());
            System.out.println("getStorePath =" + si.getStorePath());
            System.out.println("getStoreType =" + si.getStoreType());
            System.out.println("getStoreType =" + si.getStoreDesc());
        }
        ArrayList trans = ConfInfo.getTranList();
        System.out.println("trans.size() =" + trans.size());
        for (int i = 0; i < trans.size(); ++i) {
            TranInfoBean si = (TranInfoBean)trans.get(i);
            System.out.println("transName =" + si.getTranName());
            System.out.println("getChannelName =" + si.getChannelName());
            System.out.println("getServerName =" + si.getServiceName());
        }
        ArrayList servers = ConfInfo.getServerAdapterList();
        System.out.println("servers.size() =" + servers.size());
        for (int i = 0; i < servers.size(); ++i) {
            BaseServiceInfoBean si = (BaseServiceInfoBean)servers.get(i);
            System.out.println("serversName =" + si.getBaseServiceName());
            System.out.println("getServerlName =" + si.getServerAdapterName());
        }
    }

    private void setCmpDesc(ArrayList allCmpList, ArrayList usedCmpList) {
        for (int i = 0; i < allCmpList.size(); ++i) {
            StoreInfoBean actorBran = (StoreInfoBean)allCmpList.get(i);
            String aName = actorBran.getStoreName();
            String desc = actorBran.getStoreDesc();
            for (int j = 0; j < usedCmpList.size(); ++j) {
                StoreInfoBean actorBranTemp = (StoreInfoBean)allCmpList.get(j);
                StoreInfoBean actorBranTemp2 = (StoreInfoBean)usedCmpList.get(j);
                String type = actorBranTemp.getStoreType();
                String pointCutName = actorBranTemp2.getPointCutName();
                String aTempName = actorBranTemp.getStoreName();
                if (!aName.equals(aTempName)) continue;
                actorBranTemp.setStoreName(aName);
                actorBranTemp.setStoreDesc(desc);
                actorBranTemp.setPointCutName(pointCutName);
                actorBranTemp.setStoreType(type);
                usedCmpList.set(j, actorBranTemp);
            }
        }
    }

    private void getActorInfo(String xmlUrl) {
        block4: {
            String actor_cmp_url = this.eai_home + "/actions";
            this.findComponentInfo(actor_cmp_url, 2, "");
            try {
                ArrayList<StoreInfoBean> actorList = new ArrayList<StoreInfoBean>();
                Document document = ConfInfoLoader.readDocument(xmlUrl);
                if (document != null) {
                    List actor = ConfInfoLoader.getChildrenElement(document, "actor-config/actor");
                    for (int i = 0; i < actor.size(); ++i) {
                        Element actorElement = (Element)actor.get(i);
                        StoreInfoBean storeInfo = new StoreInfoBean();
                        String actorName = actorElement.getAttributeValue("name");
                        storeInfo.setStoreName(actorName);
                        actorList.add(storeInfo);
                    }
                    this.setCmpDesc(this.actorInfoList, actorList);
                    this.confInfo.setActorList(actorList);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("\u83b7\u53d6actor\u4fe1\u606f\u51fa\u9519" + e.getMessage()));
            }
        }
    }

    private void getAppComponentInfo(String xmlUrl) {
        block4: {
            try {
                ArrayList<StoreInfoBean> appCmpList = new ArrayList<StoreInfoBean>();
                Document document = ConfInfoLoader.readDocument(xmlUrl);
                if (document != null) {
                    List cmpTempList = ConfInfoLoader.getChildrenElement(document, "conf/component/path");
                    for (int i = 0; i < cmpTempList.size(); ++i) {
                        Element cmpElement = (Element)cmpTempList.get(i);
                        StoreInfoBean storeInfo = new StoreInfoBean();
                        storeInfo.setStoreName(cmpElement.getAttributeValue("url"));
                        appCmpList.add(storeInfo);
                    }
                    this.confInfo.setAppComponentList(appCmpList);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("\u83b7\u53d6\u5e94\u7528\u542f\u52a8\u7ec4\u4ef6\u4fe1\u606f\u51fa\u9519 " + e.getMessage()));
            }
        }
    }

    private void getAppSequenceInfo(String xmlUrl) {
        block4: {
            try {
                ArrayList<StoreInfoBean> sequenceList = new ArrayList<StoreInfoBean>();
                Document document = ConfInfoLoader.readDocument(xmlUrl);
                if (document != null) {
                    List featureList = ConfInfoLoader.getChildrenElement(document, "conf/sequence/single");
                    for (int i = 0; i < featureList.size(); ++i) {
                        Element featureElement = (Element)featureList.get(i);
                        StoreInfoBean storeInfo = new StoreInfoBean();
                        storeInfo.setStoreName(featureElement.getAttributeValue("name"));
                        sequenceList.add(storeInfo);
                    }
                    this.confInfo.setAppSequenceList(sequenceList);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("\u83b7\u53d6\u5e94\u7528\u542f\u52a8\u5e8f\u5217\u4fe1\u606f\u51fa\u9519 " + e.getMessage()));
            }
        }
    }

    public static List getChildrenElement(Object document, String visitedNodeName) {
        List visitElements;
        block2: {
            visitElements = null;
            try {
                visitElements = XPath.selectNodes((Object)document, (String)visitedNodeName);
            }
            catch (JDOMException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("\u83b7\u53d6\u6307\u5b9a\u5143\u7d20\u8def\u5f84\u7684\u5b50\u5143\u7d20\u5217\u8868\u51fa\u9519 " + e.getMessage()));
            }
        }
        return visitElements;
    }

    private void getPfSeqInfo(String xmlUrl) {
        block4: {
            try {
                ArrayList<StoreInfoBean> sequenceList = new ArrayList<StoreInfoBean>();
                Document document = ConfInfoLoader.readDocument(xmlUrl);
                if (document != null) {
                    List featureList = ConfInfoLoader.getChildrenElement(document, "conf/feature");
                    for (int i = 0; i < featureList.size(); ++i) {
                        Element featureElement = (Element)featureList.get(i);
                        StoreInfoBean storeInfo = new StoreInfoBean();
                        storeInfo.setStoreName(featureElement.getAttributeValue("uri"));
                        sequenceList.add(storeInfo);
                    }
                    this.confInfo.setPfSequenceList(sequenceList);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("\u83b7\u53d6\u5e73\u53f0\u542f\u52a8\u5e8f\u5217\u4fe1\u606f\u51fa\u9519 " + e.getMessage()));
            }
        }
    }

    public void load() {
        this.eai_home = System.getProperty("EAI_HOME");
        if (this.eai_home == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\u8bbe\u7f6e\u73af\u5883\u53d8\u91cf\u51fa\u9519 \u8bf7\u8bbe\u7f6e\u73af\u5883\u53d8\u91cf EAI_HOME");
            }
            throw new NullPointerException();
        }
        this.confInfo = new ConfInfo();
        String server_conf_url = this.eai_home + "/server/server-conf.xml";
        String app_conf_url = this.eai_home + "/shared/app-conf.xml";
        String actor_url = this.eai_home + "/actions/actor-config.xml";
        String interceptor_url = this.eai_home + "/interceptors/aop-config.xml";
        String channel_url = this.eai_home + "/components/channel";
        String server_url = this.eai_home + "/components/server";
        this.getPfSeqInfo(server_conf_url);
        this.findComponentInfos();
        this.getAppSequenceInfo(app_conf_url);
        this.getAppComponentInfo(app_conf_url);
        this.getActorInfo(actor_url);
        this.getIntercepterInfo(interceptor_url);
        this.getTransInfo(channel_url);
        this.getServerAdaptesInfo(server_url);
    }

    private void findComponentInfos() {
        String cmpPath = this.eai_home + "/components/";
        this.addComponent(cmpPath);
        this.confInfo.setComponentList(this.componentList);
    }

    private boolean addComponent(String xmlUrl) {
        String channel_url = this.eai_home + "/components/channel";
        String server_url = this.eai_home + "/components/server";
        String service_url = this.eai_home + "/components/service";
        String adapter_url = this.eai_home + "/components/adapter";
        String normaldispatch_url = this.eai_home + "/components/normaldispatch";
        String passthrough_url = this.eai_home + "/components/passthrough";
        boolean flag = true;
        File srcDir = new File(xmlUrl);
        File[] sfiles = srcDir.listFiles();
        int iFilesCount = this.getFileSize(sfiles);
        for (int i = 0; i < iFilesCount; ++i) {
            String cmpType = "";
            if (sfiles[i].getName().equals("service")) {
                cmpType = "service";
                this.findComponentInfo(service_url, 1, cmpType);
                continue;
            }
            if (sfiles[i].getName().equals("channel")) {
                cmpType = "channel";
                this.findComponentInfo(channel_url, 1, cmpType);
                continue;
            }
            if (sfiles[i].getName().equals("server")) {
                cmpType = "server";
                this.findComponentInfo(server_url, 1, cmpType);
                continue;
            }
            if (sfiles[i].getName().equals("adapter")) {
                cmpType = "adapter";
                this.findComponentInfo(server_url, 1, cmpType);
                continue;
            }
            if (sfiles[i].getName().equals("normaldispatch")) {
                cmpType = "normaldispatch";
                this.findComponentInfo(normaldispatch_url, 1, cmpType);
                continue;
            }
            if (!sfiles[i].getName().equals("passthrough")) continue;
            cmpType = "passthrough";
            this.findComponentInfo(passthrough_url, 1, cmpType);
        }
        return flag;
    }

    public static Document readDocument(String filePath) throws IOException {
        block3: {
            try {
                SAXBuilder builder = new SAXBuilder(false);
                Document anotherDocument = builder.build(new File(filePath));
                return anotherDocument;
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("\u4ece\u6307\u5b9a\u8def\u5f84\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u4fe1\u606f\u51fa\u9519" + e.getMessage()));
            }
        }
        return null;
    }

    public static Document readDocument(File srcfile) throws IOException {
        block4: {
            try {
                SAXBuilder builder = new SAXBuilder(false);
                Document anotherDocument = builder.build(srcfile);
                return anotherDocument;
            }
            catch (JDOMException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("\u4ece\u6307\u5b9a\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u4fe1\u606f\u51fa\u9519" + e.getMessage()));
                }
            }
            catch (NullPointerException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("\u4ece\u6307\u5b9a\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u4fe1\u606f\u51fa\u9519" + e.getMessage()));
            }
        }
        return null;
    }

    private void findComponentInfo(String srcsDir, int flag, String cmpType) {
        File srcDir = new File(srcsDir);
        File[] sfiles = srcDir.listFiles();
        int filesCount = 0;
        if (sfiles != null) {
            filesCount = sfiles.length;
        }
        for (int i = 0; i < filesCount; ++i) {
            if (sfiles[i].isFile()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" \u6587\u4ef6  " + sfiles[i].getName()));
                }
                this.getComponentDoc(sfiles[i], flag, cmpType);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  \u76ee\u5f55  " + sfiles[i].getName()));
            }
            if (filesCount == 0) continue;
            String[] childFilePath = new String[filesCount];
            childFilePath[i] = sfiles[i].getPath();
            System.out.println(childFilePath[i]);
            this.findComponentInfo(childFilePath[i], flag, cmpType);
        }
    }

    private void getComponentDoc(File cmpfile, int flag, String cmpType) {
        block8: {
            if (cmpfile.getName().equals("component.xml")) {
                try {
                    Document doc = ConfInfoLoader.readDocument(cmpfile);
                    String filePath = cmpfile.getPath();
                    switch (flag) {
                        case 1: {
                            this.addCmpInfo(doc, filePath, cmpType);
                            break;
                        }
                        case 2: {
                            this.addActorsInfo(doc, filePath);
                            break;
                        }
                        case 3: {
                            this.addInterceptorsInfo(doc, filePath);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error((Object)("\u5224\u65ad\u6587\u4ef6\u662f\u5426\u662fcomponent.xml\u6587\u4ef6\u51fa\u9519" + ex.getMessage()));
                }
            }
        }
    }

    private void addCmpInfo(Document doc, String filePath, String cmpType) {
        if (doc != null) {
            StoreInfoBean storeInfo = new StoreInfoBean();
            Element rootElement = ConfInfoLoader.getChildElement(doc, "/component");
            String cmpName = "";
            if (rootElement != null) {
                cmpName = rootElement.getAttributeValue("name");
                int x = filePath.indexOf("dist");
                filePath.substring(x + 4, filePath.length());
                System.out.println(x);
                storeInfo.setStorePath(filePath.substring(x + 4, filePath.length()));
                storeInfo.setStoreName(cmpName);
            }
            Element typeElement = ConfInfoLoader.getChildElement(doc, "/component/type");
            String type = "";
            if (typeElement != null) {
                type = typeElement.getValue();
                storeInfo.setStoreType(type);
            }
            storeInfo.setCmpType(cmpType);
            this.componentList.add(storeInfo);
        }
    }

    private void addActorsInfo(Document doc, String filePath) {
        if (doc != null) {
            StoreInfoBean storeInfo = new StoreInfoBean();
            Element rootElement = ConfInfoLoader.getChildElement(doc, "/component");
            String cmpName = "";
            if (rootElement != null) {
                cmpName = rootElement.getAttributeValue("name");
                storeInfo.setStorePath(filePath);
                storeInfo.setStoreName(cmpName);
            }
            Element typeElement = ConfInfoLoader.getChildElement(doc, "/component/type");
            String type = "";
            if (typeElement != null) {
                type = typeElement.getValue();
                storeInfo.setStoreType(type);
            }
            Element descElement = ConfInfoLoader.getChildElement(doc, "/component/desc");
            String desc = "";
            if (descElement != null) {
                desc = descElement.getValue();
                storeInfo.setStoreDesc(desc);
            }
            this.actorInfoList.add(storeInfo);
        }
    }

    private void addInterceptorsInfo(Document doc, String filePath) {
        if (doc != null) {
            StoreInfoBean storeInfo = new StoreInfoBean();
            Element rootElement = ConfInfoLoader.getChildElement(doc, "/component");
            String cmpName = "";
            if (rootElement != null) {
                cmpName = rootElement.getAttributeValue("name");
                storeInfo.setStorePath(filePath);
                storeInfo.setStoreName(cmpName);
            }
            Element typeElement = ConfInfoLoader.getChildElement(doc, "/component/type");
            String type = "";
            if (typeElement != null) {
                type = typeElement.getValue();
                storeInfo.setStoreType(type);
            }
            Element descElement = ConfInfoLoader.getChildElement(doc, "/component/desc");
            String desc = "";
            if (descElement != null) {
                desc = descElement.getValue();
                storeInfo.setStoreDesc(desc);
            }
            this.inteceptorInfoList.add(storeInfo);
        }
    }

    private void getIntercepterInfo(String xmlUrl) {
        block4: {
            String intercepter_cmp_url = this.eai_home + "/interceptors";
            this.findComponentInfo(intercepter_cmp_url, 3, "");
            try {
                ArrayList<StoreInfoBean> interceptorList = new ArrayList<StoreInfoBean>();
                Document document = ConfInfoLoader.readDocument(xmlUrl);
                if (document != null) {
                    List interceptorTempList = ConfInfoLoader.getChildrenElement(document, "aop-config/interceptor");
                    List pointCutTempList = ConfInfoLoader.getChildrenElement(document, "aop-config/pointcut");
                    for (int i = 0; i < interceptorTempList.size(); ++i) {
                        Element pointCutElement = (Element)pointCutTempList.get(i);
                        Element interceptorElement = (Element)interceptorTempList.get(i);
                        StoreInfoBean storeInfo = new StoreInfoBean();
                        storeInfo.setStoreName(interceptorElement.getAttributeValue("name"));
                        storeInfo.setPointCutName(pointCutElement.getAttributeValue("name"));
                        interceptorList.add(storeInfo);
                    }
                    this.setCmpDescIntercepterInfo(this.inteceptorInfoList, interceptorList);
                    this.confInfo.setInterceptorList(interceptorList);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("\u83b7\u53d6\u62e6\u622a\u5668\u4fe1\u606f\u51fa\u9519" + e.getMessage()));
            }
        }
    }

    private void setCmpDescIntercepterInfo(ArrayList allCmpList, ArrayList usedCmpList) {
        ArrayList list = new ArrayList();
        list.addAll(usedCmpList);
        usedCmpList.clear();
        for (int i = 0; i < list.size(); ++i) {
            StoreInfoBean actorBran = (StoreInfoBean)list.get(i);
            String storeName = actorBran.getStoreName();
            String pointCutName = actorBran.getPointCutName();
            for (int j = 0; j < allCmpList.size(); ++j) {
                StoreInfoBean actorBranTemp = (StoreInfoBean)allCmpList.get(j);
                if (storeName.equalsIgnoreCase(actorBranTemp.getStoreName())) {
                    actorBran.setStoreType(actorBranTemp.getStoreType());
                    continue;
                }
                if (!pointCutName.equals(actorBranTemp.getStoreName())) continue;
                actorBran.setStoreDesc(actorBranTemp.getStoreDesc());
            }
            usedCmpList.add(actorBran);
        }
    }

    private void getTransInfo(String xmlUrl) {
        File srcDir = new File(xmlUrl);
        File[] sfiles = srcDir.listFiles();
        int iFilesCount = this.getFileSize(sfiles);
        for (int i = 0; i < iFilesCount; ++i) {
            String channelName = sfiles[i].getName();
            String trans_url = xmlUrl + "/" + channelName + "/trans";
            this.findSpecChannelInfo(trans_url, channelName);
        }
        this.confInfo.setTranList(this.transList);
    }

    private int getFileSize(File[] files) {
        int iSize = 0;
        if (files != null) {
            iSize = files.length;
        }
        return iSize;
    }

    private void findSpecChannelInfo(String xmlUrl, String channelName) {
        File srcDir = new File(xmlUrl);
        File[] sfiles = srcDir.listFiles();
        int iFilesCount = this.getFileSize(sfiles);
        for (int i = 0; i < iFilesCount; ++i) {
            try {
                Document document = ConfInfoLoader.readDocument(sfiles[i]);
                Element rootElement = ConfInfoLoader.getChildElement(document, "/tran");
                String tranName = "";
                TranInfoBean tranInfo = new TranInfoBean();
                if (rootElement != null) {
                    tranName = rootElement.getAttributeValue("name");
                    tranInfo.setTranName(tranName);
                }
                String serviceName = "";
                if (rootElement != null) {
                    serviceName = rootElement.getAttributeValue("service-name");
                    tranInfo.setServiceName(serviceName);
                }
                tranInfo.setChannelName(channelName);
                this.transList.add(tranInfo);
                continue;
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("\u83b7\u53d6\u4ea4\u6613\u4fe1\u606f\u51fa\u9519" + e.getMessage()));
            }
        }
    }

    private void getServerAdaptesInfo(String xmlUrl) {
        File srcDir = new File(xmlUrl);
        File[] sfiles = srcDir.listFiles();
        int iFilesCount = this.getFileSize(sfiles);
        for (int i = 0; i < iFilesCount; ++i) {
            String serverlName = sfiles[i].getName();
            String serversAdapter_url = xmlUrl + "/" + serverlName + "/server.xml";
            String servers_url = xmlUrl + "/" + serverlName + "/base-services";
            String serverAdapterName = this.getServerAdapterName(serversAdapter_url);
            this.findSpecServerInfo(servers_url, serverAdapterName);
        }
        this.confInfo.setServerAdapterList(this.serverAdapterList);
    }

    private String getServerAdapterName(String xmlUrl) {
        String serverAdapterName;
        block4: {
            serverAdapterName = "";
            File srcDir = new File(xmlUrl);
            if (srcDir != null) {
                try {
                    Document document = ConfInfoLoader.readDocument(srcDir);
                    Element rootElement = ConfInfoLoader.getChildElement(document, "/server");
                    if (rootElement != null) {
                        serverAdapterName = rootElement.getAttributeValue("name");
                    }
                }
                catch (IOException ioe) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"\u4e0d\u80fd\u83b7\u53d6\u670d\u52a1\u9002\u914d\u5668\u540d\u79f0");
                }
            }
        }
        return serverAdapterName;
    }

    private void findSpecServerInfo(String xmlUrl, String serverName) {
        File srcDir = new File(xmlUrl);
        File[] sfiles = srcDir.listFiles();
        int iFilesCount = this.getFileSize(sfiles);
        for (int i = 0; i < iFilesCount; ++i) {
            try {
                Document document = ConfInfoLoader.readDocument(sfiles[i]);
                Element rootElement = ConfInfoLoader.getChildElement(document, "/base-service");
                String baseServiceName = "";
                BaseServiceInfoBean bserverInfo = new BaseServiceInfoBean();
                bserverInfo.setServerAdapterName(serverName);
                if (rootElement != null) {
                    baseServiceName = rootElement.getAttributeValue("name");
                    bserverInfo.setBaseServiceName(baseServiceName);
                }
                this.serverAdapterList.add(bserverInfo);
                continue;
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("\u83b7\u53d6\u670d\u52a1\u4fe1\u606f\u51fa\u9519" + e.getMessage()));
            }
        }
    }
}

